/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.util;

import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNormaliser;
import fi.csc.microarray.util.IOUtils;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class SamBamUtils {
    private SamBamUtilStateListener stateListener;
    private ChromosomeNormaliser chromosomeNormaliser = new ChromosomeNormaliser(){

        @Override
        public String normaliseChromosome(String chromosomeName) {
            String SEPARATOR = ".";
            if (chromosomeName.contains(SEPARATOR)) {
                chromosomeName = chromosomeName.substring(0, chromosomeName.indexOf(SEPARATOR));
            }
            return chromosomeName;
        }
    };

    public SamBamUtils() {
    }

    public SamBamUtils(SamBamUtilStateListener stateListener) {
        this.stateListener = stateListener;
    }

    private void updateState(String state, double percentage) {
        if (this.stateListener != null) {
            this.stateListener.stateChanged(new SamBamUtilState(state, percentage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertElandToSortedBam(File elandFile, File bamFile) throws IOException {
        BufferedReader in = null;
        SAMFileWriter writer = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(elandFile)));
            SAMFileHeader header = new SAMFileHeader();
            header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
            writer = new SAMFileWriterFactory().makeBAMWriter(header, false, bamFile);
            String line = in.readLine();
            while (line != null) {
                String[] fields = line.split("\t");
                SAMRecord alignment = new SAMRecord(header);
                alignment.setReadName(fields[0]);
                alignment.setReadBases(fields[1].getBytes());
                alignment.setAlignmentStart(Integer.parseInt(fields[7]));
                alignment.setReadNegativeStrandFlag("R".equals(fields[8]));
                alignment.setReferenceName(fields[6]);
                writer.addAlignment(alignment);
                line = in.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(in);
            SamBamUtils.closeIfPossible(writer);
            throw throwable;
        }
        IOUtils.closeIfPossible(in);
        SamBamUtils.closeIfPossible(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortSamBam(File samBamFile, File sortedBamFile) {
        SAMFileReader.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
        SAMFileReader reader = new SAMFileReader(IOUtil.openFileForReading((File)samBamFile));
        SAMFileWriter writer = null;
        try {
            reader.getFileHeader().setSortOrder(SAMFileHeader.SortOrder.coordinate);
            writer = new SAMFileWriterFactory().makeBAMWriter(reader.getFileHeader(), false, sortedBamFile);
            SAMRecordIterator iterator = reader.iterator();
            while (iterator.hasNext()) {
                writer.addAlignment((SAMRecord)iterator.next());
            }
        }
        catch (Throwable throwable) {
            SamBamUtils.closeIfPossible(reader);
            SamBamUtils.closeIfPossible(writer);
            throw throwable;
        }
        SamBamUtils.closeIfPossible(reader);
        SamBamUtils.closeIfPossible(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normaliseBam(File bamFile, File normalisedBamFile) {
        SAMFileReader.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
        SAMFileReader reader = new SAMFileReader(IOUtil.openFileForReading((File)bamFile));
        SAMFileWriter writer = null;
        try {
            SAMFileHeader normalisedHeader = reader.getFileHeader();
            SAMSequenceDictionary normalisedDictionary = new SAMSequenceDictionary();
            for (SAMSequenceRecord sequenceRecord : normalisedHeader.getSequenceDictionary().getSequences()) {
                String sequenceName = this.chromosomeNormaliser.normaliseChromosome(sequenceRecord.getSequenceName());
                normalisedDictionary.addSequence(new SAMSequenceRecord(sequenceName, sequenceRecord.getSequenceLength()));
            }
            normalisedHeader.setSequenceDictionary(normalisedDictionary);
            writer = new SAMFileWriterFactory().makeBAMWriter(normalisedHeader, true, normalisedBamFile);
            for (SAMRecord rec : reader) {
                rec.setHeader(normalisedHeader);
                writer.addAlignment(rec);
            }
        }
        catch (Throwable throwable) {
            SamBamUtils.closeIfPossible(reader);
            SamBamUtils.closeIfPossible(writer);
            throw throwable;
        }
        SamBamUtils.closeIfPossible(reader);
        SamBamUtils.closeIfPossible(writer);
    }

    public void indexBam(File bamFile, File baiFile) {
        SAMFileReader.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
        IOUtil.assertFileIsReadable((File)bamFile);
        SamReader bam = SamReaderFactory.makeDefault().referenceSequence(null).enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS}).open(bamFile);
        if (bam.type() != SamReader.Type.BAM_TYPE) {
            throw new SAMException("Input file must be bam file, not sam file.");
        }
        if (!bam.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Input bam file must be sorted by coordinate");
        }
        BAMIndexer.createIndex((SamReader)bam, (File)baiFile);
        CloserUtil.close((Object)bam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocessEland(File elandFile, File preprocessedBamFile, File baiFile) throws IOException {
        File sortedTempBamFile = File.createTempFile("converted", "bam");
        try {
            SamBamUtils.convertElandToSortedBam(elandFile, sortedTempBamFile);
            this.normaliseBam(sortedTempBamFile, preprocessedBamFile);
            sortedTempBamFile.delete();
            this.indexBam(preprocessedBamFile, baiFile);
        }
        finally {
            sortedTempBamFile.delete();
        }
    }

    public void preprocessSamBam(File samBamFile, File preprocessedBamFile, File baiFile) throws IOException {
        this.updateState("sorting", 0.0);
        File sortedTempBamFile = File.createTempFile("sorted", "bam");
        SamBamUtils.sortSamBam(samBamFile, sortedTempBamFile);
        this.updateState("normalising", 33.3);
        this.normaliseBam(sortedTempBamFile, preprocessedBamFile);
        sortedTempBamFile.delete();
        this.updateState("indexing", 66.0);
        this.indexBam(preprocessedBamFile, baiFile);
        this.updateState("done", 100.0);
    }

    public static List<String> readChromosomeNames(URL bam, URL index) throws FileNotFoundException, URISyntaxException {
        SAMFileReader reader = SamBamUtils.getSAMReader(bam, index);
        LinkedList<String> chromosomes = new LinkedList<String>();
        for (SAMSequenceRecord record : reader.getFileHeader().getSequenceDictionary().getSequences()) {
            chromosomes.add(record.getSequenceName());
        }
        SamBamUtils.closeIfPossible(reader);
        return chromosomes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAMFileReader getSAMReader(URL bam, URL index) throws FileNotFoundException, URISyntaxException {
        SAMFileReader reader = null;
        Object bamStream = null;
        Object indexStream = null;
        try {
            bamStream = "file".equals(bam.getProtocol()) ? new SeekableFileStream(new File(bam.toURI())) : new SeekableHTTPStream(bam);
            SeekableBufferedStream bamBufferedStream = new SeekableBufferedStream((SeekableStream)bamStream){

                public String getSource() {
                    return super.getSource() + "_fake-source.bam";
                }
            };
            indexStream = "file".equals(index.getProtocol()) ? new SeekableFileStream(new File(index.toURI())) : new SeekableHTTPStream(index);
            SeekableBufferedStream indexBufferedStream = new SeekableBufferedStream((SeekableStream)indexStream);
            SAMFileReader sAMFileReader = new SAMFileReader((SeekableStream)bamBufferedStream, (SeekableStream)indexBufferedStream, false);
            return sAMFileReader;
        }
        finally {
            SamBamUtils.closeIfPossible(reader);
        }
    }

    private static void closeIfPossible(SAMFileWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(SAMFileReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(TabixReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isSamBamExtension(String extension) {
        if (extension == null) {
            return false;
        }
        return "sam".equals(extension = extension.toLowerCase()) || "bam".equals(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printSamBam(InputStream samBamStream, int maxRecords) throws IOException {
        SAMFileReader.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
        SAMFileReader in = new SAMFileReader(samBamStream);
        SAMFileHeader header = in.getFileHeader();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMWriter(header, true, (OutputStream)buffer);
        int i = 0;
        try {
            for (SAMRecord rec : in) {
                if (i > maxRecords) {
                    break;
                }
                out.addAlignment(rec);
                ++i;
            }
        }
        finally {
            SamBamUtils.closeIfPossible(out);
        }
        if (i > maxRecords) {
            buffer.write("SAM/BAM too long for viewing, truncated here!\n".getBytes());
        }
        return buffer.toString();
    }

    public class SamBamUtilState {
        private String state;
        private double percentage;

        public SamBamUtilState(String state, double percentage) {
            this.state = state;
            this.percentage = percentage;
        }

        public String getState() {
            return this.state;
        }

        public double getPercentage() {
            return this.percentage;
        }
    }

    public static interface SamBamUtilStateListener {
        public void stateChanged(SamBamUtilState var1);
    }
}

