/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadPileTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ScaleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.BaseStorage;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.CoverageStorage;
import java.awt.Color;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

public class CoverageTrack
extends ScaleTrack {
    private boolean highlightSNP = false;
    private Collection<Feature> refReads = new TreeSet<Feature>();
    private boolean strandSpecificCoverageType;
    private Integer detailsIndex = null;
    private Integer referenceIndex = null;
    private CoverageStorage coverageStorage = new CoverageStorage();

    public CoverageTrack(DataThread coverage, DataThread referenceSequenceFile) {
        super(100, 3);
        this.detailsIndex = this.addDataThread(coverage);
        if (referenceSequenceFile != null) {
            this.referenceIndex = this.addDataThread(referenceSequenceFile);
        }
    }

    @Override
    public void initializeListener() {
        super.initializeListener();
    }

    private Collection<Drawable> getCoverageDrawables(Strand strand, Color color) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Chromosome chr = this.getView().getBpRegion().start.chr;
        char[] refSeq = ReadPileTrack.getReferenceArray(this.refReads, this.view, Strand.FORWARD);
        float bpWidth = (float)((double)this.getView().getWidth() / this.getView().getBpRegionDouble().getLength());
        int bottomlineY = 0;
        int previousValueY = 0;
        int previousEndX = -1;
        Color lineColor = new Color(color.getRGB(), false);
        TreeMap<BpCoord, BaseStorage.Base> totalBases = this.coverageStorage.getTotalBases();
        for (BaseStorage.Base base : totalBases.values()) {
            BaseStorage.Nucleotide reference = null;
            int viewIndex = (int)(base.getBpLocation() - this.view.getBpRegion().start.bp);
            if (viewIndex >= 0 && viewIndex < refSeq.length) {
                reference = BaseStorage.Nucleotide.fromCharacter(refSeq[viewIndex]);
                BaseStorage.Base refBase = new BaseStorage.Base(base.getBpLocation(), reference);
                refBase.setNucleotideCounts(base.getNucleotideCounts());
                base = refBase;
            }
            BpCoord location = new BpCoord(base.getBpLocation(), chr);
            float startX = this.getView().bpToTrackFloat(location).floatValue();
            int width = (int)(startX + bpWidth) - (int)startX;
            int profileY = 0;
            BaseStorage.Base coverageBase = this.coverageStorage.getBase(location, strand);
            if (coverageBase == null) continue;
            profileY = super.getScaledY(coverageBase.getCoverage());
            int valueY = bottomlineY + profileY;
            drawables.add(new RectDrawable((int)startX, bottomlineY, width, valueY, color, null));
            if (previousEndX < (int)startX) {
                drawables.add(new LineDrawable(previousEndX, bottomlineY, previousEndX, previousValueY, lineColor));
                previousValueY = 0;
            }
            drawables.add(new LineDrawable((int)startX, previousValueY, (int)startX, valueY, lineColor));
            drawables.add(new LineDrawable((int)startX, valueY, (int)startX + width, valueY, lineColor));
            this.drawSNPBar(drawables, (int)bpWidth, bottomlineY, base, strand, (int)startX);
            previousValueY = valueY;
            previousEndX = (int)startX + width;
        }
        drawables.add(new LineDrawable(previousEndX, bottomlineY, previousEndX, previousValueY, lineColor));
        return drawables;
    }

    private void drawSNPBar(Collection<Drawable> drawables, int bpWidth, int bottomlineY, BaseStorage.Base base, Strand strand, int endX) {
        if (!this.strandSpecificCoverageType && this.highlightSNP && base.hasSignificantSNPs()) {
            int y = bottomlineY;
            for (BaseStorage.Nucleotide nt : BaseStorage.Nucleotide.values()) {
                int increment = 0;
                if ((increment += base.getSNPCounts()[nt.ordinal()]) <= 0) continue;
                Color c = GBrowserConstants.charColors[nt.ordinal()];
                int scaledY = super.getScaledY(y);
                int scaledIncrement = super.getScaledY(increment);
                drawables.add(new RectDrawable(endX, scaledY, bpWidth, scaledIncrement, c, Color.black));
                y += increment;
            }
        }
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        super.updateScale();
        drawables.addAll(super.getScaleDrawables());
        drawables.addAll(this.getCoverageDrawables());
        return drawables;
    }

    @Override
    public int getMaxTotalCoverage() {
        int max = 0;
        for (BaseStorage.Base base : this.coverageStorage.getTotalBases().values()) {
            if (base.getCoverage() <= max) continue;
            max = base.getCoverage();
        }
        return max;
    }

    private Collection<Drawable> getCoverageDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.strandSpecificCoverageType) {
            drawables.addAll(this.getCoverageDrawables(Strand.FORWARD, GBrowserConstants.FORWARD_COLOR));
            drawables.addAll(this.getCoverageDrawables(Strand.REVERSE, GBrowserConstants.REVERSE_COLOR));
        } else {
            drawables.addAll(this.getCoverageDrawables(Strand.BOTH, GBrowserConstants.getCoverageColor()));
        }
        return drawables;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        this.coverageStorage.addBaseCoverage(dataResult, this.view.getRequestRegion());
        if (dataResult.getStatus().getDataThread() == this.dataThreads.get(this.referenceIndex)) {
            this.refReads.addAll(dataResult.getFeatures());
        }
    }

    @Override
    public void defineDataTypes() {
        this.addDataType((DataThread)this.dataThreads.get(this.detailsIndex), DataType.COVERAGE);
        if (this.highlightSNP && this.getView().getBpRegion().getLength() < (long)(this.getView().getWidth() * 2)) {
            this.addDataType((DataThread)this.dataThreads.get(this.referenceIndex), DataType.SEQUENCE);
        }
    }

    public void setSNPHighlight(boolean highlightSnp) {
        this.highlightSNP = highlightSnp;
    }

    public void setStrandSpecificCoverageType(boolean b) {
        this.strandSpecificCoverageType = b;
    }
}

