/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Interpretation;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.AbstractTsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.FileLine;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.TsvLine;
import java.io.IOException;
import java.net.URISyntaxException;

public class TsvLineParser
extends AbstractTsvLineParser {
    private String[] header;
    private int chrColumn;
    private int startColumn;
    private int endColumn;
    private String headerStart;

    public TsvLineParser(DataUrl data, Interpretation.TrackType trackType) throws IOException, URISyntaxException {
        this(data);
        if (Interpretation.TrackType.TSV == trackType) {
            this.setChrColumn(0);
        } else if (Interpretation.TrackType.TSV_WITH_ROW_ID == trackType) {
            this.setChrColumn(1);
        } else {
            throw new IllegalArgumentException("Unsupported trackType");
        }
    }

    public TsvLineParser(DataUrl data, int chrColumn) throws IOException, URISyntaxException {
        this(data);
        this.setChrColumn(chrColumn);
    }

    private TsvLineParser(DataUrl data) throws IOException, URISyntaxException {
        LineDataSource dataSource = new LineDataSource(data);
        this.headerStart = dataSource.readLine();
        String contentRow = dataSource.readLine();
        String[] splittedHeader = this.headerStart.split("\t");
        String[] splittedContent = contentRow.split("\t");
        if (splittedHeader.length == splittedContent.length - 1) {
            String[] headerWithId = new String[contentRow.length()];
            headerWithId[0] = "";
            System.arraycopy(splittedHeader, 0, headerWithId, 1, splittedHeader.length);
            this.header = headerWithId;
        } else {
            this.header = splittedHeader;
        }
    }

    private void setChrColumn(int chrColumn) {
        this.chrColumn = chrColumn;
        this.startColumn = chrColumn + 1;
        this.endColumn = chrColumn + 2;
    }

    @Override
    public Region getRegion() {
        if (this.isContentLine()) {
            long start = this.getLong(this.startColumn);
            long end = this.getLong(this.endColumn);
            Chromosome chr = new Chromosome(this.getString(this.chrColumn));
            return new Region(start, end, chr);
        }
        return null;
    }

    @Override
    public String getHeaderStart() {
        return this.headerStart;
    }

    @Override
    public FileLine getFileLine() {
        TsvLine line = new TsvLine();
        line.setRegion(this.getRegion());
        line.setHeaders(this.header);
        line.setValues(this.values);
        return line;
    }
}

