/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.AbstractTsvLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.FileLine;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.InMemoryIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class FileLineConversion
extends DataThread {
    private static final long IN_MEMORY_INDEX_LIMIT = 1000000L;
    private Index index;
    private LineParser parser;

    public FileLineConversion(DataUrl data, AbstractTsvLineParser parser, GBrowser browser) throws URISyntaxException, IOException, UnsortedDataException, GBrowserException {
        super(browser, null);
        RandomAccessLineDataSource dataSource = new RandomAccessLineDataSource(data);
        this.parser = parser;
        if (dataSource.length() < 1000000L) {
            LineDataSource lineDataSource = new LineDataSource(data);
            this.index = new InMemoryIndex(lineDataSource, parser);
            super.setDataSource(lineDataSource);
        } else {
            this.index = new BinarySearchIndex(dataSource, parser);
            super.setDataSource(dataSource);
        }
    }

    @Override
    protected void processDataRequest(DataRequest request) throws InterruptedException {
        if (this.index == null) {
            return;
        }
        long start = request.start.bp;
        long end = request.end.bp;
        int EXTRA = 1000000;
        start = Math.max(start - (long)EXTRA, 1L);
        Region requestRegion = new Region(start, end += (long)EXTRA, request.start.chr);
        TreeMap<IndexKey, String> lines = null;
        try {
            lines = this.index.getFileLines(new DataRequest(requestRegion, request.getRequestedContents(), request.getStatus()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
        LinkedList<Feature> list = new LinkedList<Feature>();
        for (Map.Entry entry : lines.entrySet()) {
            String line = (String)entry.getValue();
            this.parser.setLine(line);
            Region region = this.parser.getRegion();
            FileLine fileLine = this.parser.getFileLine();
            IndexKey id = (IndexKey)entry.getKey();
            LinkedHashMap<DataType, Object> valueMap = new LinkedHashMap<DataType, Object>();
            valueMap.put(DataType.ID, id);
            valueMap.put(DataType.VALUE, fileLine);
            Feature regionContent = new Feature(region, valueMap);
            list.add(regionContent);
        }
        super.createDataResult(new DataResult(request.getStatus(), list));
    }

    public LineParser getParser() {
        return this.parser;
    }

    public Index getIndex() {
        return this.index;
    }
}

