/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;

public class CigarItem {
    private CigarElement cigarElement;

    public CigarItem(CigarElement cigarElement) {
        this.cigarElement = cigarElement;
    }

    public long getLength() {
        return this.cigarElement.getLength();
    }

    public String getType() {
        return this.cigarElement.getOperator().toString();
    }

    public boolean isVisible() {
        return this.cigarElement.getOperator() == CigarOperator.M || this.cigarElement.getOperator() == CigarOperator.X || this.cigarElement.getOperator() == CigarOperator.EQ;
    }

    public boolean consumesReferenceBases() {
        return this.cigarElement.getOperator().consumesReferenceBases();
    }

    public boolean consumesReadBases() {
        return this.cigarElement.getOperator().consumesReadBases();
    }

    public CigarItemType getCigarItemType() {
        switch (this.cigarElement.getOperator()) {
            case D: {
                return CigarItemType.D;
            }
            case EQ: {
                return CigarItemType.EQ;
            }
            case H: {
                return CigarItemType.H;
            }
            case I: {
                return CigarItemType.I;
            }
            case M: {
                return CigarItemType.M;
            }
            case N: {
                return CigarItemType.N;
            }
            case P: {
                return CigarItemType.P;
            }
            case S: {
                return CigarItemType.S;
            }
            case X: {
                return CigarItemType.X;
            }
        }
        return null;
    }

    public static enum CigarItemType {
        D,
        EQ,
        H,
        I,
        M,
        N,
        P,
        S,
        X;

    }
}

