/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GenomeInfo;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.KeyAndTrustManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class AnnotationManager {
    private static final String ANNOTATIONS = "genomebrowser";
    private static final Logger logger = Logger.getLogger(AnnotationManager.class);
    public static final String CHR_LOCATION = "[CHR]";
    public static final String START_LOCATION = "[START]";
    public static final String END_LOCATION = "[END]";
    private File localAnnotationsRoot;
    private LinkedList<GenomeAnnotation> annotations = new LinkedList();
    private GBrowser browser;
    private List<URL> remoteAnnotationFiles;
    private HashMap<String, String> displaySpecies = new HashMap();
    private HashMap<String, String> displayVersions = new HashMap();
    private List<Genome> genomes = new LinkedList<Genome>();

    public AnnotationManager(GBrowser browser) {
        this.browser = browser;
    }

    public void initialize() throws Exception {
        this.remoteAnnotationFiles = this.browser.getRemoteAnnotationFiles();
        this.localAnnotationsRoot = this.browser.getLocalAnnotationDir();
        if (this.remoteAnnotationFiles != null) {
            this.interpretAnnotationFiles(this.remoteAnnotationFiles);
        } else {
            logger.info((Object)"trying to use local annotations");
            LinkedList<URL> urls = new LinkedList<URL>();
            for (File file : this.getLocalFiles(this.localAnnotationsRoot)) {
                urls.add(file.toURI().toURL());
            }
            this.interpretAnnotationFiles(urls);
        }
        if (this.genomes.isEmpty()) {
            throw new GBrowserException("Cannot access genome browser annotations from the server or from the local cache.");
        }
        this.removeUnnecessaryFiles(this.localAnnotationsRoot);
    }

    private boolean interpretAnnotationFiles(List<URL> files) throws URISyntaxException, MalformedURLException {
        boolean isSuccess = false;
        for (URL file : files) {
            String path = file.toURI().getPath();
            String[] directories = (path = path.substring(path.indexOf(ANNOTATIONS) + ANNOTATIONS.length())).split("/");
            if (directories.length != 4) continue;
            isSuccess = true;
            String species = directories[1];
            String version = directories[2];
            String fileName = directories[3];
            AnnotationType annotationType = null;
            if (fileName.endsWith(".search.tsv")) {
                annotationType = AnnotationType.SEARCH_INDEX;
            } else if (fileName.endsWith(".tabix.gtf.gz")) {
                annotationType = AnnotationType.GTF_TABIX;
            } else if (fileName.endsWith(".tabix.gtf.gz.tbi")) {
                annotationType = AnnotationType.GTF_TABIX_INDEX;
            } else if (fileName.endsWith(".gtf")) {
                annotationType = AnnotationType.GTF;
            } else if (fileName.endsWith("cytoband-chr.txt")) {
                annotationType = AnnotationType.CYTOBANDS;
            } else if (fileName.endsWith("repeat-tabix.bed.gz")) {
                annotationType = AnnotationType.REPEAT;
            } else if (fileName.endsWith("repeat-tabix.bed.gz.tbi")) {
                annotationType = AnnotationType.REPEAT_INDEX;
            } else if (fileName.endsWith(".fa")) {
                annotationType = AnnotationType.REFERENCE;
            } else if (fileName.endsWith(".fa.fai")) {
                annotationType = AnnotationType.REFERENCE_INDEX;
            } else if (fileName.endsWith(".yaml")) {
                annotationType = AnnotationType.GENOME_INFO;
                this.parseGenomeInfo(file, species, version);
            }
            if (annotationType == null) continue;
            GenomeAnnotation annotation = new GenomeAnnotation(species, version, annotationType.getId(), null, file, -1L);
            this.addAnnotation(annotation);
            Genome genome = new Genome(species, version);
            if (this.genomes.contains(genome)) continue;
            genome.sortId = "\ufffe";
            this.genomes.add(genome);
        }
        return isSuccess;
    }

    private void parseGenomeInfo(URL file, String species, String version) {
        try {
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(GenomeInfo.class));
            URLConnection connection = file.openConnection();
            KeyAndTrustManager.configureForChipsterCertificate(connection);
            GenomeInfo info = (GenomeInfo)yaml.load(connection.getInputStream());
            if (info != null) {
                if (info.getSpecies() != null) {
                    this.displaySpecies.put(species, info.getSpecies());
                }
                if (info.getVersion() != null) {
                    this.displayVersions.put(version, info.getVersion());
                }
                if (info.getEnsembl() != null) {
                    URL ensemblUrl = info.getEnsembl();
                    GenomeAnnotation ensembl = new GenomeAnnotation(species, version, AnnotationType.ENSEMBL_BROWSER_URL.getId(), null, ensemblUrl, -1L);
                    this.addAnnotation(ensembl);
                }
                if (info.getBrowserUrl() != null) {
                    URL ucscUrl = info.getBrowserUrl();
                    GenomeAnnotation ucsc = new GenomeAnnotation(species, version, AnnotationType.UCSC_BROWSER_URL.getId(), null, ucscUrl, -1L);
                    this.addAnnotation(ucsc);
                }
                if (info.getSortId() != null) {
                    Genome genome = new Genome(species, version);
                    genome.sortId = info.getSortId();
                    this.genomes.remove(genome);
                    this.genomes.add(genome);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void removeUnnecessaryFiles(File localAnnotationsRoot) throws IOException {
        List<File> allFiles = this.getLocalFiles(localAnnotationsRoot);
        for (File file : allFiles) {
            if (this.contains(file)) continue;
            this.removeFile(file);
        }
        this.removeEmptyDirectories(localAnnotationsRoot);
    }

    private void removeEmptyDirectories(File path) {
        for (File file : path.listFiles()) {
            if (!file.isDirectory()) continue;
            this.removeEmptyDirectories(file);
            if (file.listFiles().length != 0) continue;
            try {
                this.removeFile(file);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void removeFile(File fileToRemove) throws IOException {
        if (fileToRemove.getCanonicalPath().contains(".chipster")) {
            fileToRemove.delete();
        } else {
            logger.error((Object)("Attempt to remove file '" + fileToRemove + "' was prevented because " + "the file is not inside folder '.chipster'"));
        }
    }

    private boolean contains(File file) throws IOException {
        for (GenomeAnnotation annotation : this.annotations) {
            if (annotation.url == null) continue;
            String fileName = this.getLocalFileName(annotation);
            if (!file.getCanonicalPath().endsWith(fileName)) continue;
            return true;
        }
        return false;
    }

    public List<GenomeAnnotation> getAnnotations() {
        return this.annotations;
    }

    public List<GenomeAnnotation> getAnnotations(Genome genome, AnnotationType annotationType) {
        LinkedList<GenomeAnnotation> filteredAnnotations = new LinkedList<GenomeAnnotation>();
        for (GenomeAnnotation annotation : this.annotations) {
            if (!annotation.getGenome().equals(genome) || annotation.type != annotationType) continue;
            filteredAnnotations.add(annotation);
        }
        return filteredAnnotations;
    }

    public GenomeAnnotation getAnnotation(Genome genome, AnnotationType annotationType) {
        List<GenomeAnnotation> filteredList = this.getAnnotations(genome, annotationType);
        if (filteredList.size() > 0) {
            return filteredList.get(0);
        }
        return null;
    }

    public List<Genome> getGenomes() {
        for (GenomeAnnotation annotation : this.annotations) {
            int index = this.genomes.indexOf(annotation.getGenome());
            if (index < 0) {
                logger.error((Object)("All annotation genomes are not in the genome list: " + annotation.getGenome()));
                continue;
            }
            Genome genome = this.genomes.get(index);
            if (this.displaySpecies.containsKey(genome.speciesId)) {
                genome.displaySpecies = this.displaySpecies.get(genome.speciesId);
            }
            if (!this.displayVersions.containsKey(genome.versionId)) continue;
            genome.displayVersion = this.displayVersions.get(genome.versionId);
        }
        Collections.sort(this.genomes, new Comparator<Genome>(){

            @Override
            public int compare(Genome o1, Genome o2) {
                int sortIdComparison = o1.sortId.compareTo(o2.sortId);
                if (sortIdComparison != 0) {
                    return sortIdComparison;
                }
                return o1.compareTo(o2);
            }
        });
        return this.genomes;
    }

    public boolean hasLocalAnnotations(Genome genome) {
        for (AnnotationType c : AnnotationType.values()) {
            GenomeAnnotation annotation;
            if (!c.isClientCacheable() || (annotation = this.getAnnotation(genome, c)) == null || this.checkLocalFile(annotation)) continue;
            return false;
        }
        return true;
    }

    public void downloadAnnotations(final Genome genome) throws IOException {
        this.browser.runBlockingTask("downloading annotations", new Runnable(){

            @Override
            public void run() {
                for (AnnotationType c : AnnotationType.values()) {
                    GenomeAnnotation annotation;
                    if (!c.isClientCacheable() || (annotation = AnnotationManager.this.getAnnotation(genome, c)) == null || AnnotationManager.this.checkLocalFile(annotation)) continue;
                    try {
                        AnnotationManager.this.downloadAnnotationFile(annotation);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAnnotationFile(GenomeAnnotation annotation) throws IOException {
        String fileName = this.getLocalFileName(annotation);
        File localFile = new File(this.localAnnotationsRoot, fileName);
        localFile.getParentFile().mkdirs();
        InputStream in = null;
        try {
            URLConnection connection = annotation.url.openConnection();
            KeyAndTrustManager.configureForChipsterCertificate(connection);
            in = connection.getInputStream();
            IOUtils.copy(in, localFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(in);
            throw throwable;
        }
        IOUtils.closeIfPossible(in);
    }

    private String getLocalFileName(GenomeAnnotation annotation) {
        Genome genome = annotation.getGenome();
        String species = genome.speciesId;
        String version = genome.versionId;
        String fileName = IOUtils.getFilenameWithoutPath(annotation.url);
        return File.separator + species + File.separator + version + File.separator + fileName;
    }

    private boolean checkLocalFile(GenomeAnnotation annotation) {
        String fileName;
        File localFile;
        if (annotation.url != null && (localFile = new File(this.localAnnotationsRoot, fileName = this.getLocalFileName(annotation))).exists()) {
            if (annotation.getContentLength() < 0L || localFile.length() == annotation.getContentLength()) {
                return true;
            }
            try {
                this.removeFile(localFile);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void addAnnotation(GenomeAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public List<File> getLocalFiles(File path) throws IOException {
        LinkedList<File> fileList = new LinkedList<File>();
        this.addFilesRecursively(fileList, path);
        return fileList;
    }

    private void addFilesRecursively(List<File> files, File path) throws IOException {
        for (File file : path.listFiles()) {
            if (file.isDirectory()) {
                this.addFilesRecursively(files, file);
                continue;
            }
            files.add(file);
        }
    }

    public static enum AnnotationType {
        CYTOBANDS("Cytoband"),
        GTF_TABIX("Transcript"),
        GTF_TABIX_INDEX("Transcript index"),
        REPEAT("Repeat"),
        REPEAT_INDEX("Repeat index"),
        REFERENCE("Reference sequence", false),
        REFERENCE_INDEX("Reference sequence index"),
        SNP("ENSEMBL SNP"),
        SEARCH_INDEX("Search index"),
        ENSEMBL_BROWSER_URL("Ensembl", false),
        UCSC_BROWSER_URL("UCSC", false),
        GENOME_INFO("Annotation definition", true),
        GTF("Gene annotation", false);

        private String id;
        private boolean clientCacheable;

        private AnnotationType(String id) {
            this(id, true);
        }

        private AnnotationType(String id, boolean clientCacheable) {
            this.id = id;
            this.clientCacheable = clientCacheable;
        }

        public String getId() {
            return this.id;
        }

        public boolean isClientCacheable() {
            return this.clientCacheable;
        }
    }

    public static class Genome
    implements Comparable<Genome> {
        public String speciesId;
        public String versionId;
        public String displaySpecies;
        public String displayVersion;
        public String sortId;

        public Genome(String species, String version) {
            this.speciesId = species;
            this.versionId = version;
        }

        public String toString() {
            return this.getSpecies() + " " + this.getVersion();
        }

        private String getSpecies() {
            if (this.displaySpecies != null) {
                return this.displaySpecies;
            }
            return this.speciesId;
        }

        private String getVersion() {
            if (this.displayVersion != null) {
                return this.displayVersion;
            }
            return this.versionId;
        }

        public boolean equals(Object o) {
            if (o instanceof Genome) {
                Genome other = (Genome)o;
                return this.compareTo(other) == 0;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.speciesId == null ? 0 : this.speciesId.hashCode());
            result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
            return result;
        }

        @Override
        public int compareTo(Genome other) {
            int speciesComparison = this.speciesId.compareTo(other.speciesId);
            Integer ensemblVersion = this.parseEnsemblVersion(this.versionId);
            Integer otherEnsemblVersion = this.parseEnsemblVersion(other.versionId);
            int versionComparison = ensemblVersion != null && otherEnsemblVersion != null ? -ensemblVersion.compareTo(otherEnsemblVersion) : -this.versionId.compareTo(other.versionId);
            if (speciesComparison != 0) {
                return speciesComparison;
            }
            return versionComparison;
        }

        private Integer parseEnsemblVersion(String versionId) {
            int period = versionId.lastIndexOf(".");
            if (period >= 0) {
                String ensemblString = versionId.substring(period + 1);
                try {
                    return Integer.parseInt(ensemblString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public class GenomeAnnotation {
        public String species;
        public String version;
        public AnnotationType type;
        public Chromosome chr;
        private URL url;
        private long contentLength;

        public GenomeAnnotation(String species, String version, String annotationType, Chromosome chr, URL url, long contentLength) {
            this.species = species;
            this.version = version;
            this.chr = chr;
            this.contentLength = contentLength;
            this.url = url;
            for (AnnotationType aType : AnnotationType.values()) {
                if (!aType.id.equals(annotationType)) continue;
                this.type = aType;
            }
        }

        public DataUrl getUrl() {
            if (AnnotationManager.this.checkLocalFile(this)) {
                String fileName = AnnotationManager.this.getLocalFileName(this);
                File localFile = new File(AnnotationManager.this.localAnnotationsRoot, fileName);
                try {
                    return new DataUrl(localFile);
                }
                catch (MalformedURLException e) {
                    logger.warn((Object)("generating url for local file " + localFile + "failed"));
                }
            }
            return new DataUrl(this.url, this.url.getPath());
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public Genome getGenome() {
            return new Genome(this.species, this.version);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.getGenome() + " " + this.getUrl();
        }
    }
}

