/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.screen.ScreenBase;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.hyperlink.LinkModel;
import org.jdesktop.swingx.hyperlink.LinkModelAction;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.HyperlinkProvider;

public class ChipsterAnnotationsScreen
extends ScreenBase
implements ActionListener,
ListSelectionListener {
    private static Logger logger = Logger.getLogger(ChipsterAnnotationsScreen.class);
    private Dimension BUTTON_SIZE = new Dimension(120, 22);
    private JFrame frame = new JFrame("Annotations");
    private JTextArea detailsTextArea = new JTextArea();
    private JScrollPane detailsScroller;
    private JButton detailsButton;
    private JButton closeButton;
    private JLabel operationLabel = new JLabel(" ");
    private JLabel parametersLabel = new JLabel(" ");
    private JLabel statusLabel = new JLabel(" ");
    private JLabel timeLabel = new JLabel(" ");
    private JLabel infoLabel = new JLabel(" ");
    private JXTable table;
    private AnnotationsTableModel tableModel;
    private TaskExecutor taskExecutor;
    private List<Task> tasks = new LinkedList<Task>();
    private AnnotationManager annotations;

    public ChipsterAnnotationsScreen(AnnotationManager annotations) {
        SwingClientApplication.setPlastic3DLookAndFeel(this.frame);
        this.frame.setPreferredSize(new Dimension(640, 480));
        this.frame.setLocationByPlatform(true);
        this.annotations = annotations;
        this.table = this.getTable();
        this.table.setSelectionBackground(this.table.getBackground());
        this.table.setSelectionForeground(this.table.getForeground());
        JScrollPane tableScroller = new JScrollPane((Component)this.table);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.closeButton.setPreferredSize(this.BUTTON_SIZE);
        this.detailsScroller = new JScrollPane(this.detailsTextArea);
        this.detailsButton = new JButton("Show Details");
        this.detailsScroller.setMinimumSize(new Dimension(0, 200));
        this.detailsScroller.setVisible(false);
        this.detailsTextArea.setEditable(false);
        this.detailsButton.addActionListener(this);
        this.detailsButton.setPreferredSize(this.BUTTON_SIZE);
        this.detailsButton.setEnabled(false);
        this.frame.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.frame.add((Component)tableScroller, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 22;
        c.insets.bottom = 8;
        c.insets.right = 8;
        c.insets.top = 8;
        this.frame.add((Component)this.closeButton, c);
        this.frame.pack();
    }

    private JXTable getTable() {
        if (this.table == null) {
            this.tableModel = new AnnotationsTableModel();
            this.table = new JXTable(this.tableModel){

                public void updateUI() {
                    super.updateUI();
                    this.setSelectionBackground(this.getBackground());
                    this.setSelectionForeground(this.getForeground());
                }

                public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                    Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                    rowIndex = ChipsterAnnotationsScreen.this.table.convertRowIndexToModel(rowIndex);
                    return c;
                }
            };
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.table.getSelectionModel().setSelectionMode(0);
            this.table.setAutoResizeMode(2);
            this.table.getColumnModel().getColumn(Column.GENOME.ordinal()).setPreferredWidth(250);
            this.table.getColumnModel().getColumn(Column.ANNOTATIONS.ordinal()).setPreferredWidth(80);
            this.table.getColumnModel().getColumn(Column.REFERENCE.ordinal()).setPreferredWidth(80);
            this.table.setShowVerticalLines(false);
            LinkModelAction<LinkModel> linkAction = new LinkModelAction<LinkModel>(){

                public void actionPerformed(ActionEvent e) {
                    logger.debug((Object)("Canceling task: " + ChipsterAnnotationsScreen.this.tasks.get(ChipsterAnnotationsScreen.this.table.convertRowIndexToModel(ChipsterAnnotationsScreen.this.table.getSelectedRow()))));
                    ChipsterAnnotationsScreen.this.taskExecutor.kill((Task)ChipsterAnnotationsScreen.this.tasks.get(ChipsterAnnotationsScreen.this.table.convertRowIndexToModel(ChipsterAnnotationsScreen.this.table.getSelectedRow())));
                    this.setVisited(true);
                }
            };
            this.table.getColumn(Column.ANNOTATIONS.ordinal()).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((ComponentProvider)new HyperlinkProvider((AbstractHyperlinkAction)linkAction)));
        }
        return this.table;
    }

    private void refreshLabels(Task task) {
        this.detailsTextArea.setText("");
        if (task == null) {
            this.operationLabel.setText(" ");
            this.parametersLabel.setText(" ");
            this.statusLabel.setText(" ");
            this.timeLabel.setText(" ");
            this.infoLabel.setText(" ");
        } else {
            this.operationLabel.setText(task.getName());
            try {
                this.parametersLabel.setText(task.getParameters().toString());
            }
            catch (Exception e) {
                this.parametersLabel.setText("?");
            }
            this.statusLabel.setText(task.getState().toString());
            this.timeLabel.setText(new Time(task.getStartTime().getTime()).toString());
            this.infoLabel.setText(task.getStateDetail());
            this.detailsTextArea.setText(task.getScreenOutput());
            this.detailsButton.setEnabled(task.getScreenOutput() != null && !task.getScreenOutput().equals("") || this.detailsScroller.isVisible());
        }
    }

    public void refreshTasks() {
        logger.debug((Object)"Refreshing tasks in Task manager");
        for (Task task : this.taskExecutor.getTasks(true, false)) {
            if (this.tasks.contains(task)) continue;
            logger.debug((Object)("\tNew task added: " + task.getName()));
            this.tasks.add(task);
        }
        this.tableModel.notifyListeners();
        logger.debug((Object)"Refreshing done");
    }

    @Override
    public boolean hasFrame() {
        return this.frame != null;
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.detailsButton) {
            if (this.detailsScroller.isVisible()) {
                this.detailsScroller.setVisible(false);
                this.detailsButton.setText("Show details");
            } else {
                this.detailsScroller.setVisible(true);
                this.detailsButton.setText("Hide details");
            }
        } else if (e.getSource() == this.closeButton) {
            this.frame.dispose();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.table.getSelectedRow() >= 0 && this.table.getSelectedRow() < this.tasks.size()) {
            this.refreshLabels(this.tasks.get(this.table.convertRowIndexToModel(this.table.getSelectedRow())));
        } else {
            this.refreshLabels(null);
        }
    }

    public int getFailedCount() {
        int i = 0;
        for (Task task : this.tasks) {
            if (task.getState() != Task.State.FAILED && task.getState() != Task.State.TIMEOUT && task.getState() != Task.State.FAILED_USER_ERROR) continue;
            ++i;
        }
        return i;
    }

    private class AnnotationsTableModel
    implements TableModel {
        private LinkedList<TableModelListener> listeners = new LinkedList();

        private AnnotationsTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            return ChipsterAnnotationsScreen.this.annotations.getGenomes().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= this.getRowCount() || row < 0) {
                return null;
            }
            Column col = Column.values()[column];
            if (col == Column.GENOME) {
                return ((ChipsterAnnotationsScreen)ChipsterAnnotationsScreen.this).annotations.getGenomes().get((int)row).speciesId + " " + ((ChipsterAnnotationsScreen)ChipsterAnnotationsScreen.this).annotations.getGenomes().get((int)row).versionId;
            }
            if (col == Column.ANNOTATIONS) {
                if (ChipsterAnnotationsScreen.this.annotations.hasLocalAnnotations(ChipsterAnnotationsScreen.this.annotations.getGenomes().get(row))) {
                    return new LinkModel("local");
                }
                return new LinkModel("Download");
            }
            if (col == Column.REFERENCE) {
                return "local";
            }
            throw new IllegalArgumentException("illegal column " + column);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return Column.values()[columnIndex].toString();
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void notifyListeners() {
            for (TableModelListener listener : this.listeners) {
                TableModelEvent tableModelEvent = new TableModelEvent(this);
                listener.tableChanged(tableModelEvent);
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }

    private static enum Column {
        GENOME("Genome"),
        ANNOTATIONS("Annotations"),
        REFERENCE("Reference sequence");

        private String asString;

        private Column(String asString) {
            this.asString = asString;
        }

        public String toString() {
            return this.asString;
        }
    }
}

