/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.client.visualisation.ExternalVisualisationFrame;
import fi.csc.microarray.client.visualisation.InternalVisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationTaskManager;
import fi.csc.microarray.client.visualisation.VisualisationToolBar;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class VisualisationFrameManager
implements PropertyChangeListener,
DataChangeListener {
    private VisualisationTaskManager visualisationTaskManager = new VisualisationTaskManager(this);
    private InternalVisualisationFrame mainFrame = new InternalVisualisationFrame(FrameType.MAIN);
    private InternalVisualisationFrame sideFrame = new InternalVisualisationFrame(FrameType.SIDE);
    private List<ExternalVisualisationFrame> windows = new ArrayList<ExternalVisualisationFrame>();
    private JSplitPane split;
    private boolean twinView;
    private SimpleInternalFrame frameComponent;
    private VisualisationToolBar toolBar;
    private JComponent focusComponent;
    private SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();

    public VisualisationFrameManager() {
        this.toolBar = new VisualisationToolBar();
        this.application.addClientEventListener(this);
        this.application.getDataManager().addDataChangeListener(this);
    }

    public JPanel getFramesPanel() {
        if (this.frameComponent == null) {
            this.frameComponent = new SimpleInternalFrame("Visualisation");
            this.frameComponent.setToolBar(this.toolBar);
            this.split = new JSplitPane();
            this.split.setDividerLocation(0.5);
            this.split.setResizeWeight(0.5);
            this.updateInternalContent();
        }
        return this.frameComponent;
    }

    public VisualisationToolBar getVisualisationToolBar() {
        return this.toolBar;
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        if (this.focusComponent != null) {
            order.add(this.focusComponent);
        }
        order.addAll(this.toolBar.getFocusComponents());
        return order;
    }

    private void updateInternalContent() {
        int splitLocation = this.split.getWidth() / 2;
        if (this.twinView) {
            splitLocation = this.split.getDividerLocation();
            this.split.setLeftComponent(this.mainFrame.getFrameComponent());
            this.split.setRightComponent(this.sideFrame.getFrameComponent());
            this.frameComponent.setContent(this.split);
        } else {
            this.frameComponent.setContent(this.mainFrame.getFrameComponent());
        }
        if (this.split.getWidth() > 0) {
            this.split.setDividerLocation(splitLocation);
        } else {
            this.split.setDividerLocation(0.5);
        }
    }

    public void closeAllByType(FrameType type) {
        switch (type) {
            case SIDE: {
                this.twinView = false;
                this.updateInternalContent();
                break;
            }
            case WINDOW: {
                for (ExternalVisualisationFrame window : this.windows) {
                    window.getFrameComponent().dispose();
                }
                this.windows.clear();
                break;
            }
            case MAIN: {
                throw new IllegalArgumentException("Main visualisation frame can't be closed");
            }
        }
    }

    public boolean isTwinView() {
        return this.twinView;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event instanceof VisualisationMethodChangedEvent) {
            VisualisationMethodChangedEvent e = (VisualisationMethodChangedEvent)event;
            VisualisationMethod method = ((VisualisationMethodChangedEvent)event).getNewMethod();
            if (!VisualisationMethod.isDefault(method)) {
                this.showWaitPanel(e.getTarget());
            }
            if (this.toolBar.isMaximised) {
                this.toolBar.maximiseOrRestoreVisualisation();
            }
            this.visualisationTaskManager.visualise(e);
        } else if (event instanceof DatasetChoiceEvent) {
            List<DataBean> currentDatas = this.application.getSelectionManager().getSelectedDataBeans();
            List<DataBean> newDatas = this.getVisualisedDatas();
            if (currentDatas == null || newDatas == null || !currentDatas.containsAll(newDatas) || !newDatas.containsAll(currentDatas)) {
                this.application.setVisualisationMethodToDefault();
            }
        } else if (event instanceof SessionManager.SessionChangedEvent && VisualisationMethod.isDefault(this.getFrame(FrameType.MAIN).getMethod())) {
            this.application.setVisualisationMethodToDefault();
        }
    }

    private List<DataBean> getVisualisedDatas() {
        return this.getFrame(FrameType.MAIN).getDatas();
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        List<DataBean> visualizedDatas;
        if (e instanceof DataItemRemovedEvent && (visualizedDatas = this.getVisualisedDatas()) != null && visualizedDatas.contains(((DataItemRemovedEvent)e).getDataItem())) {
            this.application.setVisualisationMethodToDefault();
        }
    }

    public void showWaitPanel(FrameType frameType) {
        switch (frameType) {
            case MAIN: {
                this.mainFrame.showWaitPanel();
                this.updateInternalContent();
                break;
            }
            case SIDE: {
                this.sideFrame.showWaitPanel();
                this.twinView = true;
                this.updateInternalContent();
                break;
            }
        }
    }

    public void showVisualisationComponent(JComponent visualisation, VisualisationMethodChangedEvent e) {
        switch (e.getTarget()) {
            case MAIN: {
                this.mainFrame.showVisualisationComponent(visualisation);
                this.updateInternalContent();
                this.focusComponent = visualisation;
                this.application.updateFocusTraversal();
                break;
            }
            case SIDE: {
                this.twinView = true;
                this.sideFrame.showVisualisationComponent(visualisation);
                this.updateInternalContent();
                break;
            }
            case WINDOW: {
                e.getTargetFrameInstance().showVisualisationComponent(visualisation);
            }
        }
    }

    public JComponent createVisualisation(VisualisationMethodChangedEvent e) {
        switch (e.getTarget()) {
            case MAIN: {
                return this.mainFrame.createVisualisation(e);
            }
            case SIDE: {
                return this.sideFrame.createVisualisation(e);
            }
            case WINDOW: {
                ExternalVisualisationFrame window;
                if (e.getTargetFrameInstance() == null || !this.windows.contains(e.getTargetFrameInstance())) {
                    window = new ExternalVisualisationFrame();
                    e.setTargetFrameInstance(window);
                    this.windows.add(window);
                } else {
                    window = (ExternalVisualisationFrame)e.getTargetFrameInstance();
                }
                JComponent visualisation = window.createVisualisation(e);
                window.getFrameComponent().setDefaultCloseOperation(2);
                window.getFrameComponent().addWindowListener(new WindowListener(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        window.removeVisualisationComponent();
                        window.removeVisualiser();
                    }

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }
                });
                return visualisation;
            }
        }
        return null;
    }

    public VisualisationFrame getFrame(FrameType target) {
        switch (target) {
            case MAIN: {
                return this.mainFrame;
            }
            case SIDE: {
                return this.sideFrame;
            }
            case WINDOW: {
                return this.windows.get(0);
            }
        }
        return null;
    }

    public static enum FrameType {
        MAIN,
        SIDE,
        WINDOW;

    }
}

