/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.visualisation.NonScalableChartPanel;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.basic.BasicModule;
import java.awt.Color;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class Visualisation {
    public static final Dimension PARAMETER_SIZE = new Dimension(240, 500);
    private VisualisationFrame frame;
    public final SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();

    public abstract JComponent getVisualisation(DataBean var1) throws Exception;

    public abstract boolean canVisualise(DataBean var1) throws MicroarrayException;

    public void initialise(VisualisationFrame frame) throws Exception {
        this.frame = frame;
    }

    public VisualisationFrame getFrame() {
        return this.frame;
    }

    public JPanel getParameterPanel() {
        return null;
    }

    public JComponent getVisualisation(List<DataBean> data) throws Exception {
        throw new NotImplementedException();
    }

    protected JComponent getDefaultVisualisation() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        return panel;
    }

    public static <T> void fillComboBox(JComboBox<T> box, T[] content) {
        box.removeAllItems();
        for (T o : content) {
            box.addItem(o);
        }
    }

    public Variable[] getVariablesFor(DataBean dataBean) {
        LinkedList vars = new LinkedList();
        return vars.toArray(new Variable[0]);
    }

    public static ChartPanel makePanel(JFreeChart chart) {
        ChartPanel panel = new ChartPanel(chart);
        if (chart.getTitle() != null) {
            chart.getTitle().setFont(VisualConstants.VISUALISATION_TITLE_FONT);
        }
        return panel;
    }

    public static ChartPanel makenNonScalablePanel(JFreeChart chart) {
        NonScalableChartPanel panel = new NonScalableChartPanel(chart);
        if (chart.getTitle() != null) {
            chart.getTitle().setFont(VisualConstants.VISUALISATION_TITLE_FONT);
        }
        return panel;
    }

    public boolean canVisualise(List<DataBean> beans) throws MicroarrayException {
        throw new NotImplementedException();
    }

    public boolean isForSingleData() {
        return true;
    }

    public boolean isForMultipleDatas() {
        return false;
    }

    public void removeVisualisation() {
    }

    protected boolean isTabular(DataBean bean) {
        return bean.isContentTypeCompatitible("text/tab", "application/cel", "text/csv") && bean.hasTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES, BasicModule.TypeTags.TABLE_WITHOUT_COLUMN_NAMES);
    }

    public void visualisationShown() {
    }

    public static class PlotDescription {
        public String plotTitle;
        public String xTitle;
        public String yTitle;

        public PlotDescription(String plotTitle, String xTitle, String yTitle) {
            this.plotTitle = plotTitle;
            this.xTitle = xTitle;
            this.yTitle = yTitle;
        }
    }

    public static class Variable {
        private String name;
        private String expression;

        public Variable(String name, String expression) {
            this.name = name;
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof Variable && ((Variable)obj).name.equals(this.name) && ((Variable)obj).expression.equals(this.expression);
        }
    }
}

