/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TableAnnotationProvider {
    private static final String TABLE_COLUMN_QUERY = "/column/";
    private static final String COLUMN_ALL = "*";
    private static final String COLUMN_DESCRIPTION = "description";
    private static final List<String> COLUMN_SYMBOL = Arrays.asList("symbol", "annotations");
    private HashMap<String, String> annotatedIdentifiers = new HashMap();
    private HashMap<String, String> descriptions = new HashMap();
    private DataBean data;

    public TableAnnotationProvider(DataBean bean) throws MicroarrayException {
        try (Table table = bean.queryFeatures("/column/*").asTable();){
            String columnSymbol = null;
            for (String nameToFind : COLUMN_SYMBOL) {
                for (String col : table.getColumnNames()) {
                    if (!col.equalsIgnoreCase(nameToFind)) continue;
                    columnSymbol = col;
                    break;
                }
                if (columnSymbol == null) continue;
                break;
            }
            while (table.nextRow()) {
                String identifier = table.getStringValue(" ");
                if (identifier == null) {
                    identifier = table.getStringValue("identifier");
                }
                String symbol = table.getStringValue(columnSymbol);
                String actualDescription = table.getStringValue(COLUMN_DESCRIPTION);
                String annotatedIdentifier = symbol != null ? symbol + " (" + identifier + ")" : identifier;
                String description = actualDescription != null ? actualDescription : annotatedIdentifier;
                this.annotatedIdentifiers.put(identifier, annotatedIdentifier);
                this.descriptions.put(identifier, description);
            }
        }
    }

    public String getAnnotatedRowname(String rowIdentifier) {
        return this.annotatedIdentifiers.get(rowIdentifier);
    }

    public String getRowDescription(String rowIdentifier) {
        return this.descriptions.get(rowIdentifier);
    }

    public boolean isForData(DataBean data) {
        return this.data != null ? this.data.equals(data) : false;
    }
}

