/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.visualisation.VisualisationMethod;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;

class ComboBoxRenderer
extends JLabel
implements ListCellRenderer<VisualisationMethod> {
    public ComboBoxRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends VisualisationMethod> list, VisualisationMethod value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        ImageIcon icon = null;
        if (value instanceof VisualisationMethod) {
            icon = value.getIcon();
        }
        if (value != null) {
            if (index < 0) {
                this.setIcon(null);
                this.setBorder(null);
            } else {
                this.setIcon(icon);
                this.setBorder(new LineBorder(this.getBackground(), 5));
            }
            this.setText("  " + value.toString());
            this.setFont(list.getFont());
        }
        return this;
    }
}

