/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import fi.csc.microarray.client.NameID;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.session.NonStoppingValidationEventHandler;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.client.session.schema2.DataType;
import fi.csc.microarray.client.session.schema2.FolderType;
import fi.csc.microarray.client.session.schema2.InputType;
import fi.csc.microarray.client.session.schema2.LinkType;
import fi.csc.microarray.client.session.schema2.LocationType;
import fi.csc.microarray.client.session.schema2.NameType;
import fi.csc.microarray.client.session.schema2.ObjectFactory;
import fi.csc.microarray.client.session.schema2.OperationType;
import fi.csc.microarray.client.session.schema2.ParameterType;
import fi.csc.microarray.client.session.schema2.SessionType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.filebroker.ChecksumException;
import fi.csc.microarray.filebroker.ChecksumInputStream;
import fi.csc.microarray.filebroker.ContentLengthException;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.SwingTools;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SessionSaver {
    private static final Logger logger = Logger.getLogger(SessionSaver.class);
    private final int DATA_BLOCK_SIZE = 65536;
    private File sessionFile;
    private String sessionId;
    private HashMap<DataBean, URL> newURLs = new HashMap();
    private int sourceCodeEntryCounter = 0;
    private int itemIdCounter = 0;
    private HashMap<String, DataItem> itemIdMap = new HashMap();
    private HashMap<DataItem, String> reversedItemIdMap = new HashMap();
    private int operationIdCounter = 0;
    private HashMap<String, OperationRecord> operationRecordIdMap = new HashMap();
    private HashMap<OperationRecord, String> reversedOperationRecordIdMap = new HashMap();
    private HashMap<String, OperationType> operationRecordTypeMap = new HashMap();
    private DataManager dataManager;
    private ObjectFactory factory;
    private SessionType sessionType;
    private String validationErrors;
    private List<OperationRecord> unfinishedJobs;
    private String sessionNotes;

    public SessionSaver(File sessionFile, DataManager dataManager) {
        this.sessionFile = sessionFile;
        this.sessionId = null;
        this.dataManager = dataManager;
    }

    public SessionSaver(String sessionId, DataManager dataManager) {
        this.sessionFile = null;
        this.sessionId = sessionId;
        this.dataManager = dataManager;
    }

    public void setUnfinishedJobs(List<OperationRecord> unfinishedJobs) {
        this.unfinishedJobs = unfinishedJobs;
    }

    public boolean saveSession() throws Exception {
        this.gatherMetadata(true, true);
        boolean metadataValid = this.validateMetadata();
        this.writeSessionToFile(true);
        this.updateDataBeanURLsAndHandlers();
        return metadataValid;
    }

    public void saveLightweightSession() throws Exception {
        this.gatherMetadata(false, false);
        this.writeSessionToFile(false);
    }

    public LinkedList<String> saveFeedbackSession() throws Exception {
        return this.saveRemoteSession(FileBrokerClient.FileBrokerArea.CACHE);
    }

    public LinkedList<String> saveStorageSession() throws Exception {
        return this.saveRemoteSession(FileBrokerClient.FileBrokerArea.STORAGE);
    }

    public LinkedList<String> saveRemoteSession(FileBrokerClient.FileBrokerArea area) throws Exception {
        LinkedList<String> dataIds = new LinkedList<String>();
        for (DataBean dataBean : this.dataManager.databeans()) {
            boolean success;
            switch (area) {
                case STORAGE: {
                    success = this.dataManager.uploadToStorageIfNeeded(dataBean);
                    break;
                }
                case CACHE: {
                    success = this.dataManager.uploadToCacheIfNeeded(dataBean, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown filebroker area");
                }
            }
            if (!success) continue;
            dataIds.add(dataBean.getId());
        }
        this.gatherMetadata(false, true);
        this.writeRemoteSession(area);
        return dataIds;
    }

    private void gatherMetadata(boolean saveData, boolean skipLocalLocations) throws IOException, JAXBException {
        this.factory = new ObjectFactory();
        this.sessionType = this.factory.createSessionType();
        this.sessionType.setFormatVersion(UserSession.SESSION_VERSION);
        this.generateIdsRecursively(this.dataManager.getRootFolder());
        this.saveMetadataRecursively(this.dataManager.getRootFolder(), saveData, skipLocalLocations);
        this.sessionType.setNotes(this.sessionNotes);
        if (this.unfinishedJobs != null) {
            for (OperationRecord job : this.unfinishedJobs) {
                this.saveOperationRecord(job);
            }
        }
    }

    private boolean validateMetadata() throws JAXBException, SAXException {
        Marshaller marshaller = UserSession.getJAXBContext().createMarshaller();
        marshaller.setSchema(UserSession.getSchema());
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        NonStoppingValidationEventHandler validationEventHandler = new NonStoppingValidationEventHandler();
        marshaller.setEventHandler((ValidationEventHandler)validationEventHandler);
        marshaller.marshal(this.factory.createSession(this.sessionType), (ContentHandler)new DefaultHandler());
        if (!validationEventHandler.hasEvents()) {
            return true;
        }
        this.validationErrors = validationEventHandler.getValidationEventsAsString();
        return false;
    }

    private void writeRemoteSession(FileBrokerClient.FileBrokerArea area) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.writeSessionContents(false, buffer);
        FileBrokerClient fileBrokerClient = Session.getSession().getServiceAccessor().getFileBrokerClient();
        byte[] bytes = buffer.toByteArray();
        fileBrokerClient.addFile(this.sessionId, area, new ByteArrayInputStream(bytes), bytes.length, null);
    }

    private void writeSessionToFile(boolean saveData) throws Exception {
        File newSessionFile;
        boolean replaceOldSession = this.sessionFile.exists();
        File backupFile = null;
        if (replaceOldSession) {
            newSessionFile = new File(this.sessionFile.getAbsolutePath() + "-save-temp.zip");
            backupFile = new File(this.sessionFile.getAbsolutePath() + "-save-backup.zip");
        } else {
            newSessionFile = this.sessionFile;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(newSessionFile);
            this.writeSessionContents(saveData, out);
            IOUtils.closeIfPossible(out);
        }
        catch (Exception e) {
            IOUtils.closeIfPossible(out);
            newSessionFile.delete();
            throw e;
        }
        if (replaceOldSession) {
            this.dataManager.flushSession();
            if (!this.sessionFile.renameTo(backupFile)) {
                throw new IOException("Creating backup file " + backupFile.getAbsolutePath() + " failed.");
            }
            if (newSessionFile.renameTo(this.sessionFile)) {
                backupFile.delete();
            } else {
                if (backupFile.renameTo(this.sessionFile)) {
                    throw new IOException("Moving new session file " + newSessionFile + " -> " + this.sessionFile + " failed, " + "restored original session file.");
                }
                throw new IOException("Moving new session file " + newSessionFile + " -> " + this.sessionFile + " failed, " + "also restoring original file failed, backup of original is " + backupFile);
            }
        }
    }

    private void writeSessionContents(boolean saveData, OutputStream out) throws Exception {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(out));
            zipOutputStream.setLevel(1);
            ZipEntry sessionDataZipEntry = new ZipEntry("session.xml");
            zipOutputStream.putNextEntry(sessionDataZipEntry);
            Marshaller marshaller = UserSession.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setEventHandler((ValidationEventHandler)new NonStoppingValidationEventHandler());
            marshaller.marshal(this.factory.createSession(this.sessionType), (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
            if (saveData) {
                this.writeDataBeanContentsToZipFile(zipOutputStream);
            }
            this.writeSourceCodesToZip(zipOutputStream);
            zipOutputStream.close();
        }
        catch (Exception e) {
            IOUtils.closeIfPossible(zipOutputStream);
            throw e;
        }
    }

    private void updateDataBeanURLsAndHandlers() throws ContentLengthException, IOException {
        for (DataBean bean : this.newURLs.keySet()) {
            this.dataManager.removeContentLocationsFromDataBean(bean, DataManager.StorageMethod.LOCAL_SESSION_ZIP);
            this.dataManager.addContentLocationForDataBean(bean, DataManager.StorageMethod.LOCAL_SESSION_ZIP, this.newURLs.get(bean));
        }
    }

    private int generateIdsRecursively(DataFolder folder) throws IOException {
        int dataCount = 0;
        this.generateId(folder);
        for (DataItem data : folder.getChildren()) {
            if (data instanceof DataFolder) {
                int recDataCount = this.generateIdsRecursively((DataFolder)data);
                dataCount += recDataCount;
                continue;
            }
            this.generateId((DataBean)data);
            ++dataCount;
        }
        return dataCount;
    }

    private void generateId(DataItem data) {
        String id = String.valueOf(this.itemIdCounter);
        ++this.itemIdCounter;
        this.itemIdMap.put(id, data);
        this.reversedItemIdMap.put(data, id);
    }

    private String generateId(OperationRecord operationRecord) {
        String id = String.valueOf(this.operationIdCounter);
        ++this.operationIdCounter;
        this.operationRecordIdMap.put(id, operationRecord);
        this.reversedOperationRecordIdMap.put(operationRecord, id);
        return id.toString();
    }

    private void saveMetadataRecursively(DataFolder folder, boolean saveData, boolean skipLocalLocations) throws IOException {
        String folderId = this.reversedItemIdMap.get(folder);
        this.saveDataFolderMetadata(folder, folderId);
        for (DataItem data : folder.getChildren()) {
            if (data instanceof DataFolder) {
                this.saveMetadataRecursively((DataFolder)data, saveData, skipLocalLocations);
                continue;
            }
            DataBean bean = (DataBean)data;
            String entryName = bean.getId();
            if (entryName == null) {
                throw new IOException("unable to save session, databean's " + bean.getName() + " id is null");
            }
            URL zipEntryUrl = null;
            if (saveData) {
                zipEntryUrl = new URL(this.sessionFile.toURI().toURL(), "#" + entryName);
                this.newURLs.put(bean, zipEntryUrl);
            }
            this.saveDataBeanMetadata(bean, zipEntryUrl, folderId, skipLocalLocations);
        }
    }

    private void saveDataFolderMetadata(DataFolder folder, String folderId) {
        FolderType folderType = this.factory.createFolderType();
        folderType.setId(folderId);
        folderType.setName(folder.getName());
        if (folder.getParent() != null) {
            String parentId = this.reversedItemIdMap.get(folder.getParent());
            if (parentId != null) {
                folderType.setParent(parentId);
            } else {
                logger.warn((Object)"unknown parent");
            }
        }
        if (folder.getChildCount() > 0) {
            for (DataItem child : folder.getChildren()) {
                String childId = this.reversedItemIdMap.get(child);
                if (childId != null) {
                    folderType.getChild().add(childId);
                    continue;
                }
                logger.warn((Object)("unknown child: " + child.getName()));
            }
        }
        this.sessionType.getFolder().add(folderType);
    }

    private void saveDataBeanMetadata(DataBean bean, URL zipEntryUrl, String folderId, boolean skipLocalLocations) {
        String beanId = this.reversedItemIdMap.get(bean);
        DataType dataType = this.factory.createDataType();
        dataType.setId(beanId);
        dataType.setName(bean.getName());
        dataType.setDataId(bean.getId());
        dataType.setSize(bean.getSize());
        dataType.setChecksum(bean.getChecksum());
        dataType.setLayoutX(bean.getX());
        dataType.setLayoutY(bean.getY());
        if (bean.getParent() != null) {
            String parentId = this.reversedItemIdMap.get(bean.getParent());
            if (parentId != null) {
                dataType.setFolder(parentId);
            } else {
                logger.warn((Object)"unknown parent");
            }
        }
        dataType.setNotes(bean.getNotes());
        String versions = "";
        for (Map.Entry<String, String> entry : bean.getToolVersions().entrySet()) {
            versions = versions + entry.getKey() + ":" + entry.getValue() + ",";
        }
        if (versions.length() > 0 && versions.charAt(versions.length() - 1) == ',') {
            versions = versions.substring(0, versions.length() - 1);
        }
        dataType.setToolVersions(versions);
        if (bean.getDate() != null) {
            dataType.setCreationTime(this.dateToXMLGregorian(bean.getDate()));
        }
        for (DataManager.ContentLocation location : Session.getSession().getDataManager().getContentLocationsForDataBeanSaving(bean)) {
            if (skipLocalLocations && location.getMethod().isLocal()) continue;
            LocationType locationType = new LocationType();
            locationType.setMethod(location.getMethod().toString());
            locationType.setUrl(location.getUrl().toString());
            dataType.getLocation().add(locationType);
        }
        if (zipEntryUrl != null) {
            LocationType locationType = new LocationType();
            locationType.setMethod(DataManager.StorageMethod.LOCAL_SESSION_ZIP.name());
            locationType.setUrl("file:#" + zipEntryUrl.getRef());
            dataType.getLocation().add(locationType);
        }
        if (bean.getOperationRecord() != null) {
            OperationRecord operationRecord = bean.getOperationRecord();
            String operId = this.saveOperationRecord(operationRecord);
            this.operationRecordTypeMap.get(operId).getOutput().add(beanId);
            dataType.setResultOf(operId);
        }
        for (Iterator<Object> iterator : DataBean.Link.values()) {
            for (DataBean target : bean.getLinkTargets(new DataBean.Link[]{iterator})) {
                String targetId = this.reversedItemIdMap.get(target);
                if (targetId == null) continue;
                LinkType linkType = this.factory.createLinkType();
                linkType.setTarget(targetId);
                linkType.setType(((Enum)((Object)iterator)).name());
                dataType.getLink().add(linkType);
            }
        }
        this.sessionType.getData().add(dataType);
    }

    private String saveOperationRecord(OperationRecord operationRecord) {
        String operId;
        if (!this.operationRecordIdMap.containsValue(operationRecord)) {
            operId = this.generateId(operationRecord);
            this.saveOperationMetadata(operationRecord, operId);
        } else {
            operId = this.reversedOperationRecordIdMap.get(operationRecord).toString();
        }
        return operId;
    }

    private void saveOperationMetadata(OperationRecord operationRecord, String operationId) {
        OperationType operationType = this.factory.createOperationType();
        operationType.setId(operationId);
        operationType.setJobId(operationRecord.getJobId());
        NameType nameType = this.createNameType(operationRecord.getNameID());
        operationType.setName(nameType);
        for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
            if (parameterRecord.getValue() == null || parameterRecord.getValue().equals("")) continue;
            ParameterType parameterType = this.factory.createParameterType();
            parameterType.setName(this.createNameType(parameterRecord.getNameID()));
            parameterType.setValue(parameterRecord.getValue());
            operationType.getParameter().add(parameterType);
        }
        for (OperationRecord.InputRecord inputRecord : operationRecord.getInputRecords()) {
            String inputID;
            InputType inputType = this.factory.createInputType();
            inputType.setName(this.createNameType(inputRecord.getNameID()));
            String inputDataId = inputRecord.getDataId();
            if (inputDataId != null) {
                inputType.setDataId(inputDataId);
            }
            if ((inputID = this.reversedItemIdMap.get(inputRecord.getValue())) != null) {
                inputType.setData(inputID);
            }
            operationType.getInput().add(inputType);
        }
        operationType.setCategory(operationRecord.getCategoryName());
        if (operationRecord.getCategoryColor() != null) {
            operationType.setCategoryColor(SwingTools.colorToHexString(operationRecord.getCategoryColor()));
        }
        operationType.setModule(operationRecord.getModule());
        if (operationRecord.getSourceCode() != null) {
            String entryName = this.getNewSourceCodeEntryName(operationRecord.getNameID().getID());
            operationType.setSourceCodeFile(entryName);
        }
        if (operationRecord.getStartTime() != null) {
            operationType.setStartTime(this.dateToXMLGregorian(operationRecord.getStartTime()));
        }
        if (operationRecord.getEndTime() != null) {
            operationType.setEndTime(this.dateToXMLGregorian(operationRecord.getEndTime()));
        }
        this.sessionType.getOperation().add(operationType);
        this.operationRecordTypeMap.put(operationId, operationType);
    }

    private String getNewSourceCodeEntryName(String prefix) {
        return "source-code-" + this.sourceCodeEntryCounter++ + "-" + prefix + ".txt";
    }

    private void writeDataBeanContentsToZipFile(ZipOutputStream zipOutputStream) throws IOException {
        for (Map.Entry<DataBean, URL> entry : this.newURLs.entrySet()) {
            DataManager manager;
            DataBean bean = entry.getKey();
            URL url = entry.getValue();
            String entryName = url.getRef();
            Long streamLength = null;
            String streamChecksum = null;
            try {
                ChecksumInputStream in = Session.getSession().getDataManager().getContentStream(entry.getKey(), DataBean.DataNotAvailableHandling.EXCEPTION_ON_NA);
                Throwable throwable = null;
                try {
                    this.writeFile(zipOutputStream, entryName, in);
                    streamLength = in.getContentLength();
                    streamChecksum = in.getChecksum();
                    in.verifyContentLength(bean.getSize());
                    this.dataManager.setOrVerifyChecksum(bean, streamChecksum);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("could not access dataset for saving: " + entryName);
            }
            catch (ContentLengthException e) {
                manager = Session.getSession().getDataManager();
                String msg = "Wrong content length for dataset " + bean.getName() + ". " + "Length of input stream is " + streamLength + " bytes, " + "but DataManager expects " + manager.getContentLength(bean) + " bytes. ";
                msg = msg + "Content locations: ";
                for (DataManager.ContentLocation location : manager.getContentLocationsForDataBeanSaving(bean)) {
                    msg = msg + location.getUrl() + " " + manager.getContentLength(location) + " bytes, ";
                }
                throw new IOException(msg, e);
            }
            catch (ChecksumException e) {
                manager = Session.getSession().getDataManager();
                String msg = "Wrong checksum for dataset " + bean.getName() + ". " + "Checksum of input stream is " + streamChecksum + ". ";
                msg = msg + "Content locations: ";
                for (DataManager.ContentLocation location : manager.getContentLocationsForDataBeanSaving(bean)) {
                    msg = msg + location.getUrl() + " " + manager.getContentLength(location) + " bytes, ";
                }
                throw new IOException(msg, e);
            }
        }
    }

    private void writeSourceCodesToZip(ZipOutputStream zipOutputStream) throws IOException {
        for (Map.Entry<String, OperationType> entry : this.operationRecordTypeMap.entrySet()) {
            String sourceCodeFileName = entry.getValue().getSourceCodeFile();
            if (sourceCodeFileName == null || sourceCodeFileName.isEmpty()) continue;
            this.writeFile(zipOutputStream, sourceCodeFileName, new ByteArrayInputStream(this.operationRecordIdMap.get(entry.getKey()).getSourceCode().getBytes()));
        }
    }

    private void writeFile(ZipOutputStream out, String name, InputStream in) throws IOException {
        int byteCount;
        ZipEntry cpZipEntry = new ZipEntry(name);
        out.putNextEntry(cpZipEntry);
        byte[] b = new byte[65536];
        while ((byteCount = in.read(b, 0, 65536)) != -1) {
            out.write(b, 0, byteCount);
        }
        out.closeEntry();
    }

    private NameType createNameType(String id, String displayName, String desription) {
        NameType nameType = this.factory.createNameType();
        nameType.setId(id);
        nameType.setDisplayName(displayName);
        nameType.setDescription(desription);
        return nameType;
    }

    private NameType createNameType(NameID nameID) {
        return this.createNameType(nameID.getID(), nameID.getDisplayName(), nameID.getDescription());
    }

    public String getValidationErrors() {
        return this.validationErrors;
    }

    public static void dumpSession(DataFolder folder, StringBuffer buffer) {
        for (DataItem data : folder.getChildren()) {
            if (data instanceof DataFolder) {
                SessionSaver.dumpSession((DataFolder)data, buffer);
                continue;
            }
            DataBean bean = (DataBean)data;
            buffer.append("\nBean: " + bean.getName() + "\n");
            for (DataManager.ContentLocation locations : Session.getSession().getDataManager().getContentLocationsForDataBeanSaving(bean)) {
                buffer.append("  " + (Object)((Object)locations.getMethod()) + ": \t" + locations.getUrl() + "\n");
            }
        }
    }

    public void setSessionNotes(String sessionNotes) {
        this.sessionNotes = sessionNotes;
    }

    private XMLGregorianCalendar dateToXMLGregorian(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            logger.warn((Object)"could not convert Date to XMLGregorianCalendar when saving", (Throwable)e);
            return null;
        }
    }
}

