/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.InputFileComponent;
import fi.csc.microarray.databeans.DataBean;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class InputParameters {
    private List<InputFileComponent> inputComponents = new LinkedList<InputFileComponent>();
    private Operation operation;

    public InputParameters(Operation operation) {
        this.operation = operation;
        for (OperationDefinition.InputDefinition input : operation.getDefinition().getInputs()) {
            InputFileComponent inputComponent;
            ArrayList<DataBean> options = new ArrayList<DataBean>();
            ArrayList<DataBean> selected = new ArrayList<DataBean>();
            for (Operation.DataBinding binding : operation.getBindings()) {
                if (OperationDefinition.doBackwardsCompatibleTypeCheck(input.getType(), binding.getData())) {
                    options.add(binding.getData());
                }
                if (!input.idMatches(binding.getName())) continue;
                selected.add(binding.getData());
            }
            if (input.isMulti()) {
                inputComponent = new InputFileComponent.MultiInput(input, operation, this, options, selected);
            } else {
                DataBean singleSelected = selected.isEmpty() ? null : (DataBean)selected.get(0);
                inputComponent = new InputFileComponent.SingleInput(input, operation, this, options, singleSelected);
            }
            this.inputComponents.add(inputComponent);
        }
    }

    public List<InputFileComponent> getComponents() {
        return this.inputComponents;
    }

    public void bind(DataBean selected, Object sourceComponent) {
        for (InputFileComponent component : this.inputComponents) {
            if (!component.getSelectedItems().contains(selected) || sourceComponent == component.getComponent()) continue;
            component.removeSelected(selected);
        }
        LinkedList<Operation.DataBinding> newBindings = new LinkedList<Operation.DataBinding>();
        for (InputFileComponent component : this.inputComponents) {
            List<DataBean> selectedBeans = component.getSelectedItems();
            OperationDefinition.InputDefinition input = component.getInput();
            input.resetMulti();
            for (DataBean bean : selectedBeans) {
                newBindings.add(new Operation.DataBinding(bean, input.getID(), input.getType()));
                input.nextMulti();
            }
        }
        this.operation.setBindings(newBindings);
    }
}

