/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolFilterPanel;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.operation.ToolSelectorPanel;
import fi.csc.microarray.client.operation.parameter.ToolParameterPanel;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class ToolPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ToolPanel.class);
    private static final String OPERATION_LIST_TITLE = "Analysis tools";
    private static final String SHOW_PARAMETERS_TEXT = "Show parameters";
    private static final String HIDE_PARAMETERS_TEXT = "Hide parameters";
    private static final String TOOLS = "Tools";
    private static final String PARAMETERS = "Parameters";
    private static final String TOOLS_CATEGORIZED = "Categorized tools for module ";
    private static final String TOOLS_FILTERED = "Filtered tools";
    private static final int WHOLE_PANEL_HEIGHT = 240;
    private static final int WHOLE_PANEL_WIDTH = 660;
    private JPanel operationPanel;
    private JPanel operationCardPanel;
    private LinkedList<ToolSelectorPanel> operationChoicePanels = new LinkedList();
    private ToolFilterPanel toolFilterPanel;
    private JTextField searchField = new JTextField(18);
    private JButton clearSearchButton;
    private JPanel cardPanel;
    private JTextArea detailField = new JTextArea();
    private JLabel suitabilityLabel = new JLabel();
    private JButton sourceButton = new JButton("Show tool sourcecode");
    private JButton helpButton = new JButton("More help");
    private JButton parametersButton = new JButton();
    private JButton executeButton = new JButton();
    private JScrollPane detailFieldScroller;
    private boolean isParametersVisible = false;
    private OperationDefinition selectedOperationDefinition = null;
    private Operation currentOperation = null;
    private LinkedList<ToolModule> toolModules;
    private SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();
    private LinkedList<JButton> moduleButtons = new LinkedList();

    public ToolPanel(LinkedList<ToolModule> toolModules) throws SADLParser.ParseException {
        super(new GridBagLayout());
        this.setPreferredSize(new Dimension(660, 240));
        this.setMinimumSize(new Dimension(0, 0));
        this.toolModules = toolModules;
        LinkedList<ToolCategory> allVisibleCategories = new LinkedList<ToolCategory>();
        for (ToolModule toolModule : toolModules) {
            if (!toolModule.isVisible()) continue;
            this.operationChoicePanels.add(new ToolSelectorPanel(this, toolModule));
            allVisibleCategories.addAll(toolModule.getVisibleCategories());
        }
        this.toolFilterPanel = new ToolFilterPanel(this, allVisibleCategories);
        this.cardPanel = new JPanel(new CardLayout());
        this.detailField.setEditable(false);
        this.detailField.setLineWrap(true);
        this.detailField.setWrapStyleWord(true);
        this.detailFieldScroller = new JScrollPane(this.detailField);
        this.detailFieldScroller.setHorizontalScrollBarPolicy(31);
        this.sourceButton.setEnabled(false);
        this.sourceButton.setToolTipText("View Source Code");
        this.sourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ToolPanel.this.application.showSourceFor(ToolPanel.this.selectedOperationDefinition.getID());
                }
                catch (TaskException je) {
                    ToolPanel.this.application.reportException(je);
                }
            }
        });
        this.helpButton.setEnabled(false);
        this.helpButton.setToolTipText("More information about this tool");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolPanel.this.application.viewHelpFor(ToolPanel.this.selectedOperationDefinition);
            }
        });
        this.parametersButton.addActionListener(this);
        this.parametersButton.setEnabled(false);
        this.parametersButton.setText(SHOW_PARAMETERS_TEXT);
        int suitabilityLabelSize = VisualConstants.getIcon("/no.png").getIconHeight();
        this.suitabilityLabel.setPreferredSize(new Dimension(suitabilityLabelSize, suitabilityLabelSize));
        this.executeButton.setIcon(VisualConstants.getIcon("/forward.png"));
        this.executeButton.setDisabledIcon(VisualConstants.getIcon("/forward_bw.png"));
        this.executeButton.setText("<html><b>Run</b></html>");
        this.executeButton.setHorizontalAlignment(0);
        this.executeButton.setHorizontalTextPosition(2);
        this.executeButton.setToolTipText("Run selected tool for selected datasets");
        this.executeButton.addActionListener(this);
        this.executeButton.setName("executeButton");
        this.executeButton.setEnabled(false);
        this.detailFieldScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, VisualConstants.TOOL_LIST_BORDER_COLOR));
        this.searchField.setMinimumSize(this.searchField.getPreferredSize());
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                ToolPanel.this.searchFieldChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ToolPanel.this.searchFieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ToolPanel.this.searchFieldChanged();
            }
        });
        this.clearSearchButton = new JButton(VisualConstants.getIcon(VisualConstants.CLOSE_FILE_ICON));
        this.clearSearchButton.setFocusPainted(false);
        this.clearSearchButton.setContentAreaFilled(false);
        this.clearSearchButton.setCursor(new Cursor(12));
        this.clearSearchButton.setBorder(null);
        this.clearSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ToolPanel.this.clearSearchField();
                ToolPanel.this.returnFromSearch();
            }
        });
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 27) {
                    ToolPanel.this.searchField.setText("");
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        JToolBar searchPanel = new JToolBar();
        searchPanel.setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 13;
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 0.0;
        g.insets = new Insets(0, 0, 0, 0);
        g.fill = 0;
        searchPanel.add((Component)new JLabel(VisualConstants.getIcon(VisualConstants.MAGNIFIER_ICON)), g);
        ++g.gridx;
        searchPanel.add((Component)this.searchField, g);
        ++g.gridx;
        this.searchField.setLayout(new FlowLayout(2, 0, 0));
        this.searchField.setPreferredSize(new Dimension(100, 22));
        searchPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.TOOL_LIST_BORDER_COLOR));
        for (ToolModule toolModule : toolModules) {
            if (!toolModule.isVisible()) continue;
            String buttonText = Session.getSession().getPrimaryModule().getModuleLongName(toolModule.getModuleName());
            JButton button = new JButton(buttonText);
            button.setName(toolModule.getModuleName());
            button.setPreferredSize(new Dimension((int)((double)button.getMinimumSize().width * 1.2), 22));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof JButton) {
                        JButton currentButton = (JButton)e.getSource();
                        ToolPanel.this.clearSearchField();
                        ToolPanel.this.selectModule(currentButton.getName());
                    }
                }
            });
            this.moduleButtons.add(button);
        }
        JPanel moduleButtonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mc = new GridBagConstraints();
        mc.anchor = 17;
        mc.gridx = 0;
        mc.gridy = 0;
        mc.weightx = 0.0;
        mc.insets = new Insets(0, 0, 0, 0);
        mc.fill = 0;
        for (JButton moduleButton : this.moduleButtons) {
            moduleButtonPanel.add((Component)moduleButton, mc);
            ++mc.gridx;
        }
        this.operationPanel = new JPanel(new GridBagLayout());
        this.operationPanel.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.insets.set(0, 0, 0, 0);
        c.fill = 0;
        c.anchor = 17;
        this.operationPanel.add((Component)moduleButtonPanel, c);
        searchPanel.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        JToolBar fillPanel = new JToolBar();
        fillPanel.setBorder(BorderFactory.createEmptyBorder());
        fillPanel.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        ++c.gridx;
        c.weightx = 2.0;
        c.fill = 1;
        c.anchor = 17;
        this.operationPanel.add((Component)fillPanel, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.operationPanel.add((Component)searchPanel, c);
        this.operationCardPanel = new JPanel(new CardLayout());
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets.set(0, 0, 0, 0);
        c.anchor = 17;
        this.operationPanel.add((Component)this.operationCardPanel, c);
        for (ToolSelectorPanel panel : this.operationChoicePanels) {
            this.operationCardPanel.add((Component)panel, TOOLS_CATEGORIZED + panel.getModuleName());
        }
        this.operationCardPanel.add((Component)this.toolFilterPanel, TOOLS_FILTERED);
        this.operationCardPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, VisualConstants.TOOL_LIST_BORDER_COLOR));
        this.cardPanel.add((Component)this.operationPanel, TOOLS);
        this.cardPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.TOOL_LIST_BORDER_COLOR));
        JPanel topLeftPanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets.set(0, 10, 0, 10);
        topLeftPanel.add((Component)this.suitabilityLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets.set(0, 0, 0, 0);
        topLeftPanel.add((Component)this.parametersButton, c);
        JPanel topPanel = new JPanel(new GridLayout(1, 2));
        topPanel.add(topLeftPanel);
        topPanel.add(this.executeButton);
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2));
        bottomPanel.add(this.helpButton);
        bottomPanel.add(this.sourceButton);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets.set(0, 0, 0, 0);
        this.add((Component)this.cardPanel, c);
        c.gridy = 0;
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)topPanel, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.add((Component)this.detailFieldScroller, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)bottomPanel, c);
        ToolModule selected = toolModules.getLast();
        for (ToolModule module : toolModules) {
            if (!module.isVisible()) continue;
            selected = module;
            if (!"ngs".equals(module.getModuleName())) continue;
            break;
        }
        this.selectModule(selected.getModuleName());
        Session.getSession().getApplication().addClientEventListener(this);
    }

    private void selectModule(String moduleName) {
        this.highlightTab(moduleName);
        this.clearOperationSelection();
        this.showOperationCard(TOOLS_CATEGORIZED + moduleName);
    }

    public void highlightTab(String moduleName) {
        for (JButton moduleButton : this.moduleButtons) {
            String longName = "";
            longName = moduleButton.getName().equals(moduleName) ? "<html><strong>" + Session.getSession().getPrimaryModule().getModuleLongName(moduleName) + "</strong></html>" : Session.getSession().getPrimaryModule().getModuleLongName(moduleButton.getName());
            moduleButton.setText(longName);
        }
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        for (ToolSelectorPanel panel : this.operationChoicePanels) {
            order.addAll(panel.getFocusComponents());
        }
        order.add(this.executeButton);
        return order;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.parametersButton) {
            this.parametersButtonClicked();
        } else if (e.getSource() == this.executeButton) {
            this.executeCurrentOperation(false);
        }
    }

    public void executeCurrentOperation(boolean failSilently) {
        Runnability runnability = this.evaluateRunnability();
        if (!runnability.isRunnable()) {
            if (!failSilently) {
                this.application.showDialog("Check parameters and input datasets ", "- All non-optional parameters must have valid value\n- All selected datasets must be assigned\n", runnability.toString(), DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
            }
            return;
        }
        try {
            if (runnability == Runnability.RUNNABLE_AS_BATCH) {
                List<DataBean> datas = this.application.getSelectionManager().getSelectedDataBeans();
                for (DataBean data : datas) {
                    Operation clonedOperation = new Operation(this.currentOperation);
                    clonedOperation.bindInputs(new DataBean[]{data});
                    this.application.executeOperation(clonedOperation);
                }
            } else {
                Operation clonedOperation = new Operation(this.currentOperation);
                this.application.executeOperation(clonedOperation);
            }
        }
        catch (MicroarrayException me) {
            throw new RuntimeException(me);
        }
    }

    private void parametersButtonClicked() {
        if (!this.isParametersVisible) {
            this.showParameterPanel();
        } else {
            this.showOperationsPanel();
        }
    }

    private void showCard(String card) {
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, card);
    }

    private void showOperationCard(String card) {
        CardLayout cl = (CardLayout)this.operationCardPanel.getLayout();
        cl.show(this.operationCardPanel, card);
    }

    private void showParameterPanel() {
        this.showParametersTitle(true);
        this.parametersButton.setText(HIDE_PARAMETERS_TEXT);
        try {
            this.cardPanel.add((Component)new ToolParameterPanel(this.currentOperation, this), PARAMETERS);
            this.showCard(PARAMETERS);
            this.isParametersVisible = true;
        }
        catch (MicroarrayException e) {
            this.application.reportException(e);
        }
    }

    private void showOperationsPanel() {
        this.showParametersTitle(false);
        this.parametersButton.setText(SHOW_PARAMETERS_TEXT);
        this.isParametersVisible = false;
        this.showCard(TOOLS);
    }

    private void showParametersTitle(boolean showParametersTitle) {
        String title = showParametersTitle ? "Analysis tools - " + this.currentOperation.getCategoryName() + " - " + this.currentOperation.getDisplayName() : OPERATION_LIST_TITLE;
        ((SimpleInternalFrame)this.getParent()).setTitle(title);
        this.repaint();
    }

    public void selectTool(ExecutionItem newSelectedOperationDefinition) {
        if (newSelectedOperationDefinition == null) {
            this.clearOperationSelection();
        } else {
            this.selectedOperationDefinition = (OperationDefinition)newSelectedOperationDefinition;
            try {
                this.currentOperation = new Operation(this.selectedOperationDefinition, this.application.getSelectionManager().getSelectedDatasAsArray());
            }
            catch (MicroarrayException e) {
                logger.error((Object)("could not create operation for " + this.selectedOperationDefinition.getDisplayName()), (Throwable)e);
                this.clearOperationSelection();
                return;
            }
            this.showParametersTitle(false);
            this.showToolInfoText();
            this.parametersButton.setEnabled(true);
            this.updateSuitability();
        }
    }

    public void updateSuitability() {
        Runnability runnability = this.evaluateRunnability();
        if (runnability == Runnability.RUNNABLE) {
            this.suitabilityLabel.setIcon(VisualConstants.getIcon("/yes.png"));
            this.executeButton.setText("<html><b>Run</b></html>");
            this.executeButton.setEnabled(true);
        } else if (runnability == Runnability.RUNNABLE_AS_BATCH) {
            this.suitabilityLabel.setIcon(VisualConstants.getIcon("/yes.png"));
            this.executeButton.setText("<html><b>Run for each</b></html>");
            this.executeButton.setEnabled(true);
        } else {
            this.suitabilityLabel.setIcon(VisualConstants.getIcon("/no.png"));
            this.executeButton.setText("<html><b>Run</b></html>");
            this.executeButton.setEnabled(false);
        }
        this.suitabilityLabel.setToolTipText(" " + runnability.toString());
    }

    private void clearOperationSelection() {
        this.selectedOperationDefinition = null;
        this.currentOperation = null;
        for (ToolSelectorPanel panel : this.operationChoicePanels) {
            panel.deselectTool();
        }
        this.executeButton.setEnabled(false);
        this.parametersButton.setEnabled(false);
        this.showToolInfoText();
        this.suitabilityLabel.setIcon(null);
        this.suitabilityLabel.setToolTipText("");
    }

    public void setInfoText(String text, Color color, boolean enable) {
        this.detailField.setForeground(color);
        this.detailField.setText(text);
        this.detailField.setCaretPosition(0);
        this.updateDetailFieldMargin();
    }

    public void showToolInfoText() {
        if (this.currentOperation != null) {
            this.setInfoText(this.currentOperation.getDescription(), Color.BLACK, true);
            this.sourceButton.setEnabled(true);
            this.helpButton.setEnabled(true);
        } else {
            this.setInfoText("", Color.BLACK, false);
            this.sourceButton.setEnabled(false);
            this.helpButton.setEnabled(false);
        }
    }

    private void updateDetailFieldMargin() {
        if (this.detailFieldScroller.getVerticalScrollBar().isVisible()) {
            logger.debug((Object)"vertical scrollbar is visible");
            this.detailField.setMargin(new Insets(2, 2, 2, 2 + this.detailFieldScroller.getVerticalScrollBar().getWidth()));
        } else {
            logger.debug((Object)"vertical scrollbar is not visible");
            this.detailField.setMargin(new Insets(2, 2, 2, 2));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent dataEvent) {
        if (dataEvent instanceof DatasetChoiceEvent) {
            logger.debug((Object)("chosen data " + this.application.getSelectionManager().getSelectedDataBean() + " (possible one among many)"));
            this.selectTool(this.selectedOperationDefinition);
            this.showOperationsPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnability evaluateRunnability() {
        if (this.currentOperation == null) {
            return Runnability.NOT_RUNNABLE;
        }
        List<DataBean> selectedDatas = this.application.getSelectionManager().getSelectedDataBeans();
        OperationDefinition.Suitability suitability = this.currentOperation.evaluateSuitabilityFor(selectedDatas, this.currentOperation.getBindings());
        if (suitability.isOk()) {
            return Runnability.RUNNABLE;
        }
        if (this.currentOperation.getDefinition().isBatchable() && selectedDatas.size() > 1) {
            List<DataBean> datas = selectedDatas;
            List<Operation.DataBinding> currentBindings = this.currentOperation.getBindings();
            try {
                for (DataBean data : datas) {
                    this.currentOperation.bindInputs(new DataBean[]{data});
                    if (this.currentOperation.evaluateSuitabilityFor(Arrays.asList(data), this.currentOperation.getBindings()).isOk()) continue;
                    Runnability runnability = Runnability.NOT_RUNNABLE;
                    return runnability;
                }
            }
            catch (MicroarrayException e) {
                logger.error((Object)"evaluation of batch runnability encountered an error", (Throwable)e);
                Runnability runnability = Runnability.NOT_RUNNABLE;
                return runnability;
            }
            finally {
                this.currentOperation.setBindings(currentBindings);
            }
            return Runnability.RUNNABLE_AS_BATCH;
        }
        return Runnability.NOT_RUNNABLE;
    }

    private void clearSearchField() {
        this.searchField.setText("");
        this.searchField.setBackground(Color.WHITE);
        this.searchField.remove(this.clearSearchButton);
    }

    private void returnFromSearch() {
        OperationDefinition tool = (OperationDefinition)this.toolFilterPanel.getSelectedTool();
        if (tool != null) {
            ToolCategory category = tool.getCategory();
            ToolModule module = category.getModule();
            this.selectModule(module.getModuleName());
            this.getToolSelectorPanel(module.getModuleName()).selectCategory(category);
            this.getToolSelectorPanel(module.getModuleName()).selectTool(tool);
        } else {
            this.selectModule(this.toolModules.getFirst().getModuleName());
        }
    }

    private ToolSelectorPanel getToolSelectorPanel(String moduleName) {
        for (ToolSelectorPanel toolSelectorPanel : this.operationChoicePanels) {
            if (!toolSelectorPanel.getModuleName().equals(moduleName)) continue;
            return toolSelectorPanel;
        }
        return null;
    }

    private void searchFieldChanged() {
        if (this.searchField.getText().trim().length() > 0) {
            this.searchField.setBackground(VisualConstants.COLOR_BLUE_LIGHT);
            if (!this.clearSearchButton.isAncestorOf(this.searchField)) {
                this.searchField.add(this.clearSearchButton);
            }
            this.toolFilterPanel.loadFilteredOperations(this.searchField.getText());
            this.showOperationCard(TOOLS_FILTERED);
        } else {
            this.searchField.setBackground(Color.WHITE);
            this.searchField.remove(this.clearSearchButton);
            this.returnFromSearch();
        }
    }

    public void focusSearchField() {
        this.searchField.requestFocusInWindow();
    }

    public void setSearchFieldToolTipText(String text) {
        this.searchField.setToolTipText(text);
    }

    public static enum Runnability {
        RUNNABLE,
        RUNNABLE_AS_BATCH,
        NOT_RUNNABLE;


        public boolean isRunnable() {
            return this != NOT_RUNNABLE;
        }
    }
}

