/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ClipboardImportDialog
extends JDialog
implements ActionListener,
CaretListener {
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private JCheckBox skipCheckBox;
    private JLabel label;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameField;
    private JComboBox folderNameCombo;
    private ClientApplication client;

    public ClipboardImportDialog(ClientApplication client) {
        super((Frame)Session.getSession().getFrames().getMainFrame(), true);
        this.client = client;
        this.setTitle("Import data from clipboard");
        this.setModal(true);
        this.label = new JLabel("Filename");
        this.nameField = new JTextField(30);
        this.nameField.setText("clipboard.txt");
        this.nameField.addCaretListener(this);
        this.skipCheckBox = new JCheckBox(VisualConstants.getImportDirectlyText());
        if (!Session.getSession().getApplication().isStandalone()) {
            this.skipCheckBox.setSelected(true);
        } else {
            this.skipCheckBox.setSelected(false);
        }
        this.folderNameCombo = new JComboBox<Object>(ImportUtils.getFolderNames(true).toArray());
        this.folderNameCombo.setEditable(true);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.anchor = 17;
        c.insets.set(10, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.label, c);
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.nameField, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Insert in folder"), c);
        c.fill = 2;
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.folderNameCombo, c);
        c.insets.set(10, 10, 10, 10);
        c.anchor = 13;
        ++c.gridy;
        this.add((Component)this.skipCheckBox, c);
        c.fill = 0;
        c.insets.set(10, 10, 10, 10);
        c.anchor = 13;
        ++c.gridy;
        JPanel keepButtonsRightPanel = new JPanel();
        keepButtonsRightPanel.add(this.okButton);
        keepButtonsRightPanel.add(this.cancelButton);
        this.add((Component)keepButtonsRightPanel, c);
        if (this.isDataAvailable()) {
            this.pack();
            Session.getSession().getFrames().setLocationRelativeToMainFrame(this);
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "There is no text content on the clipboard");
            this.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            try {
                File file;
                if (this.getFileName().length() < 3) {
                    this.nameField.setText("clipboard_" + this.getFileName());
                }
                if (ClipboardImportDialog.pasteToFile(file = ImportUtils.createTempFile(this.getFileName(), ImportUtils.getExtension(this.getFileName())), this)) {
                    ImportSession importSession = new ImportSession(ImportSession.Source.CLIPBOARD, new File[]{file}, this.folderNameCombo.getSelectedItem().toString(), true);
                    ImportUtils.executeImport(importSession);
                    this.dispose();
                }
            }
            catch (IOException ioe) {
                IOException newException = new IOException("Can't create a temporary file for the clipboard paste (reason: " + ioe.getMessage() + ").");
                this.client.reportException(newException);
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public String getSelectedFolderName() {
        return this.folderNameCombo.getSelectedItem().toString();
    }

    public String getFileName() {
        return this.nameField.getText();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.updateEnabledStatus();
    }

    private void updateEnabledStatus() {
        String dataSetName = this.nameField.getText();
        if (dataSetName.length() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private boolean isDataAvailable() {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            return true;
        }
        catch (HeadlessException headlessException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean pasteToFile(File file, Component parentComponent) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.append((String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor));
            writer.close();
            return true;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(parentComponent, "Error occured while retrieving data from clipboard", "Clipboard error", 0);
            return false;
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog(parentComponent, "Requested data is not available", "Clipboard error", 0);
            return false;
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(parentComponent, "Clipboard is currently unavailable", "Clipboard error", 0);
            return false;
        }
    }
}

