/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataview;

import fi.csc.microarray.client.dataview.MicroarrayGraph;
import fi.csc.microarray.client.dataviews.vertexes.AbstractGraphVertex;
import fi.csc.microarray.client.dataviews.vertexes.GraphVertex;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LayoutManager {
    private MicroarrayGraph graph;
    private static final Logger logger = Logger.getLogger(LayoutManager.class);

    public LayoutManager(MicroarrayGraph graph) {
        this.graph = graph;
    }

    public void updateLayout(AbstractGraphVertex inserted, DataBean bean) {
        if (inserted.getAllowsAutolayout()) {
            if (!(inserted instanceof GraphVertex)) {
                throw new IllegalArgumentException("vertex of type " + ((Object)((Object)inserted)).getClass().getSimpleName() + " not supported");
            }
            GraphVertex vertex = (GraphVertex)inserted;
            logger.debug((Object)(vertex.getData().getName() + " is root: " + vertex.isRoot()));
            if (vertex.isRoot()) {
                vertex.setPosition(this.getNewRootPosition());
            } else {
                Point preferredPlace = this.getPreferredPlace(vertex);
                vertex.setPosition(preferredPlace);
            }
            logger.debug((Object)(vertex.getData().getName() + " got bounds: " + vertex.getBounds()));
        }
    }

    public Point getNewRootPosition() {
        Dimension dim = this.graph.getGraphSize();
        int x = (int)dim.getWidth();
        if (x < 60) {
            x = 10;
        }
        return new Point(x, 10);
    }

    private Point getPreferredPlace(GraphVertex vertex) {
        Object source;
        int leftSourceX = Integer.MAX_VALUE;
        int bottomSourceY = 0;
        ArrayList<Integer> sourceXs = new ArrayList<Integer>();
        for (DataBean sourceBean : vertex.getData().getLinkTargets(DataBean.Link.derivationalTypes())) {
            source = this.graph.getVertexMap().get(sourceBean);
            if (source.getX() < leftSourceX) {
                leftSourceX = source.getX();
            }
            sourceXs.add(source.getX());
            if (source.getY() <= bottomSourceY) continue;
            bottomSourceY = source.getY();
        }
        int sourceY = bottomSourceY + vertex.getMarginY() + vertex.getDefaultHeight();
        Point potentialPosition = new Point(leftSourceX, sourceY);
        if (this.getIntersectingVertex(potentialPosition, vertex) == null) {
            return potentialPosition;
        }
        source = sourceXs.iterator();
        while (source.hasNext()) {
            int sourceX = (Integer)source.next();
            Point point = new Point(sourceX, sourceY);
            if (this.getIntersectingVertex(point, vertex) != null) continue;
            return point;
        }
        boolean done = false;
        while (!done) {
            AbstractGraphVertex intersectingCell = this.getIntersectingVertex(potentialPosition, vertex);
            if (intersectingCell != null && intersectingCell instanceof GraphVertex) {
                potentialPosition = new Point((int)(potentialPosition.getX() + (double)vertex.getDefaultWidth() + (double)vertex.getMarginX()), (int)potentialPosition.getY());
                continue;
            }
            done = true;
        }
        return potentialPosition;
    }

    private AbstractGraphVertex getIntersectingVertex(Point newPoint, GraphVertex vertex) {
        Dimension dim = new Dimension(40, 21);
        Rectangle newPlace = new Rectangle(newPoint, dim);
        for (AbstractGraphVertex cell : this.graph.getVisibleVertexes()) {
            logger.debug((Object)("does " + (Object)((Object)cell) + " intersect " + vertex.getData().getName() + ": " + (cell.getBounds().intersects(newPlace) && cell != vertex)));
            if (!cell.getBounds().intersects(newPlace) || cell == vertex) continue;
            return cell;
        }
        return null;
    }
}

