/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.cli;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.auth.ClientLoginListener;
import fi.csc.microarray.messaging.auth.SimpleAuthenticationRequestListener;
import java.io.File;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class CliClientApplication
extends ClientApplication {
    private boolean verbose;
    private boolean quiet;
    private DateTime lastLogin;
    long lastInitMsgTime = System.currentTimeMillis();

    public CliClientApplication(SimpleAuthenticationRequestListener auth, boolean verbose, boolean quiet) {
        super(auth);
        this.verbose = verbose;
        this.quiet = quiet;
    }

    @Override
    public void reportExceptionThreadSafely(Exception e) {
        e.printStackTrace();
        System.exit(1);
    }

    @Override
    public void reportException(Exception e) {
        e.printStackTrace();
        System.exit(1);
    }

    @Override
    public void reportTaskError(Task job) throws MicroarrayException {
        System.err.println("\nTask error: " + job.getErrorMessage());
    }

    @Override
    public void reportInitialisationThreadSafely(String report, boolean newline) {
        if (this.verbose) {
            if (newline) {
                System.out.println(report);
            } else {
                System.out.print(report);
            }
        }
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal) {
        System.out.println(title);
        System.out.println(message);
        System.out.println(details);
        System.exit(1);
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button) {
        this.showDialog(title, message, details, severity, modal);
    }

    @Override
    public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility, ChipsterDialog.PluginButton button, boolean feedBackEnabled) {
        this.showDialog(title, message, details, severity, modal);
    }

    @Override
    public void runBlockingTask(String taskName, Runnable runnable) {
        if (!this.quiet) {
            System.out.println("Please wait while " + taskName);
        }
        new Thread(runnable).start();
    }

    @Override
    public void initialiseGUIThreadSafely(File mostRecentDeadTempDirectory) throws MicroarrayException, IOException {
    }

    @Override
    protected AuthenticationRequestListener getAuthenticationRequestListener() {
        AuthenticationRequestListener authenticator = super.getAuthenticationRequestListener();
        authenticator.setLoginListener(new ClientLoginListener(){

            @Override
            public void firstLogin() {
                if (CliClientApplication.this.lastLogin != null && CliClientApplication.this.lastLogin.isAfter((ReadableInstant)DateTime.now().minus(10000L))) {
                    System.err.println("login failed");
                    System.exit(1);
                }
                CliClientApplication.this.lastLogin = DateTime.now();
            }

            @Override
            public void loginCancelled() {
                System.exit(1);
            }
        });
        return authenticator;
    }
}

