/***************************************/
/*      Weeder 1.3
   see LICENSE.txt file for
  terms and conditions of use
*/

#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>



char *expandorgname (char *org);

main (int argc, char *argv[])
{
  int multiflag = 0;
  int parallelmode = 0;
  FILE *F, *HF;
  int i;
  char inputfile[200] = "";
  char organism[8];
  char ofile[200];
  char filetosend[800] = "";
  char outfile[800] = "";
  char htmlfile[800] = "";
  char mixfile[800] = "";
  char orgfullname[80];
  char frasetta1[80] = "";
  char frasetta2[80] = "";
  int reverseflag = 0;
  char analysis[80];
  char *params[20];
  int allflag = 0;
  int excflag;
  int toreport = 10;
  pid_t pid;

/*
 LA LENGTH E' IL TIPO DI ANALISI  
  
  IL 15 E' IL REVERSED (TRUE / FALSE)

  IL 17 E' IL TITOLO
 
*/

  for (i = 0; i < 20; i++)
    params[i] = (char *) malloc (80 * sizeof (char));

  for (i = 0; i < 20; i++)
    bzero (params[i], 80);

  if ((argc < 4) || (strcmp (argv[1], "-h") == 0)
      || (strcmp (argv[1], "--help") == 0))
    {
      fprintf (stderr,
	       "\nUsage : weederlauncher.out inputfilename speciescode analysistype <options>\n");
      fprintf (stderr,
	       "\nspeciescode: two-letter species code (e.g. HS, MM, RN, SC, and so on)\n");
      fprintf (stderr, "analysistype: small|medium|large|extra\n");
      fprintf (stderr, "options (not required):\n");
      fprintf (stderr,
	       "A: all sequences must contain the motif (default: half)\n");
      fprintf (stderr,
	       "S: process both strands of input sequences (default: single strand)\n");
      fprintf (stderr,
	       "M: multiple motif occurrences in each sequence (default: expect zero or one occurrences per sequence)\n");
      fprintf (stderr, "T<number>: report top <number> motifs of each run\n");
      exit (1);
    }



  strcpy (inputfile, argv[1]);
  strcpy (organism, argv[2]);
  strcpy (analysis, argv[3]);
  sprintf (ofile, "./FreqFiles/%s.8.freq", organism);

  F = fopen (ofile, "r");

  if (F == NULL)
    {
      fprintf (stderr, "\nMissing frequency file : %s\n", ofile);
      exit (1);
    }
  fclose (F);
  sprintf (ofile, "./FreqFiles/%s.6.freq", organism);

  F = fopen (ofile, "r");

  if (F == NULL)
    {
      fprintf (stderr, "\nMissing frequency file : %s\n", ofile);
      exit (1);
    }
  fclose (F);
  F = fopen (inputfile, "r");

  if (F == NULL)
    {
      fprintf (stderr, "\nNo such file : %s\n", inputfile);
      exit (1);
    }
  else
    fclose (F);

  //expandorgname (organism);



  sprintf (mixfile, "%s.mix", inputfile);
  sprintf (outfile, "%s.wee", inputfile);
  sprintf (htmlfile, "%s.html", inputfile);

  F = fopen (mixfile, "w");
  fclose (F);


  if (argc >= 5)
    {
      if (strcmp (argv[4], "A") == 0)
	allflag = 1;
      if (strcmp (argv[4], "S") == 0)
	reverseflag = 1;
      if (strcmp (argv[4], "M") == 0)
	multiflag = 1;

      if (argv[4][0] == 'T')
	{
	  argv[4]++;
	  toreport = atoi (argv[4]);
	}
    }

  if (argc >= 6)
    {
      if (strcmp (argv[5], "A") == 0)
	allflag = 1;
      if (strcmp (argv[5], "S") == 0)
	reverseflag = 1;
      if (strcmp (argv[5], "M") == 0)
	multiflag = 1;
      if (argv[5][0] == 'T')
	{
	  argv[5]++;
	  toreport = atoi (argv[5]);
	}
    }
  if (argc >= 7)
    {
      if (strcmp (argv[6], "A") == 0)
	allflag = 1;
      if (strcmp (argv[6], "S") == 0)
	reverseflag = 1;
      if (strcmp (argv[6], "M") == 0)
	multiflag = 1;
      if (argv[6][0] == 'T')
	{
	  argv[6]++;
	  toreport = atoi (argv[6]);
	}
    }
  if (argc >= 8)
    {
      if (strcmp (argv[7], "A") == 0)
	allflag = 1;
      if (strcmp (argv[7], "S") == 0)
	reverseflag = 1;
      if (strcmp (argv[7], "M") == 0)
	multiflag = 1;
      if (argv[7][0] == 'T')
	{
	  argv[7]++;
	  toreport = atoi (argv[7]);
	}
    }

  if (toreport <= 0)
    {

      fprintf (stderr, "\nI need to report at least one motif per run!\n");
      exit (1);
    }

  strcpy (params[0], "./weederTFBS.out");

  strcpy (params[1], "-f");
  sprintf (params[2], "%s", inputfile);

  strcpy (params[3], "-R");
  if (allflag == 1)
    strcpy (params[4], "100");
  else
    strcpy (params[4], "50");

  strcpy (params[5], "-O");
  sprintf (params[6], "%s", organism);


  strcpy (params[13], "-T");
  sprintf (params[14], "%d", toreport);

  HF = fopen (htmlfile, "a");

  fprintf (HF,
	   "<html><body bgcolor = silver font = garamond><head><title>Your Weeder Web Results</title></head>");
  fprintf (HF, "<tt>");


  if (strcmp (analysis, "small") == 0)
    {
      F = fopen (outfile, "a");

      fprintf (F, "\n\nNEW: Starting a %s job\n", analysis);
      fprintf (HF,
	       "<br><br><b>NEW: Starting a %s job on file %s</b><br><br><b>",
	       analysis, inputfile);

      fprintf (F, "\nOrganism code: %s\n", organism);
      fprintf (HF, "<br>Organism code: %s<br>", organism);

      if (reverseflag == 1)
	fprintf (F, "\nProcessing *both* strands\n");
      if (reverseflag == 1)
	fprintf (HF, "</b><br>Processing <b>both</b> strands<br><br><b>");

      for (i = 0; i < argc; i++)
	fprintf (F, "%s ", argv[i]);

      for (i = 0; i < argc; i++)
	fprintf (HF, "%s ", argv[i]);

      fprintf (F, "\n\n");
      fprintf (HF, "</b><br><br>");

      fclose (F);
      fclose (HF);
      pid = fork ();

      if (pid == 0)
	{
	  strcpy (params[7], "-W");
	  strcpy (params[8], "6");
	  strcpy (params[9], "-e");
	  strcpy (params[10], "1");

	  if (multiflag == 1)
	    strcpy (params[11], "-M");
	  else
	    strcpy (params[11], "-N");

	  if (reverseflag == 1)
	    strcpy (params[12], "-S");
	  else
	    strcpy (params[12], "-N");

	  //strcpy(params[8],"2> pappa ");
	  params[15] = NULL;


	  //for (i = 0; i < 14; i++)
	  //fprintf (stderr, "%s", params[i]);

	  //getchar();

	  excflag = execvp ("./weederTFBS.out", params);

	  if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
	}
      else
	{
	  if (parallelmode == 0)
	    wait (NULL);

	  pid = fork ();

	  if (pid == 0)
	    {
	      strcpy (params[7], "-W");
	      strcpy (params[8], "8");
	      strcpy (params[9], "-e");
	      strcpy (params[10], "2");
	      if (multiflag == 1)
		strcpy (params[11], "-M");
	      else
		strcpy (params[11], "-N");

	      if (reverseflag == 1)
		strcpy (params[12], "-S");
	      else
		strcpy (params[12], "-N");

	      //strcpy(params[8],"2> pappa ");
	      params[15] = NULL;
	      //strcpy(params[8],"2> pappa ");

	      //for (i = 0; i < 20; i++)
	      //fprintf (stderr, "%s", params[i]);

	      //getchar();

	      excflag = execvp ("./weederTFBS.out", params);

	      if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
	    }
	  else
	    {
	      wait (NULL);

	      pid = fork ();

	      if (pid == 0)
		{
		  strcpy (params[0], "./adviser.out");

		  strcpy (params[1], inputfile);

		  if (reverseflag == 0)
		    strcpy (params[2], "N");
		  else
		    strcpy (params[2], "S");;

		  params[3] = NULL;

		  fprintf (stderr, "\nRunning adviser....\n");
		  excflag = execvp ("./adviser.out", params);

		  if (excflag == -1)
	    fprintf (stderr, "\nCould not start the adviser. Make sure it is located in the same directory of weederlauncher. %d\n", errno);

		}
	      else
		exit (0);

	    }

	}

    }
  else
    {
      if (strcmp (analysis, "medium") == 0)
	{
	  F = fopen (outfile, "a");

	  fprintf (F, "\n\nNEW: Starting a %s job\n", analysis);
	  fprintf (HF, "<br><br>NEW: Starting a %s job on file %s<br>",
		   analysis, inputfile);
          
	  fprintf (F, "\nOrganism code: %s\n", organism);
	  fprintf (HF, "<br>Organism code: %s<br>", organism);

           if (reverseflag == 1)
        fprintf (F, "\nProcessing *both* strands\n");
      if (reverseflag == 1)
        fprintf (HF, "</b><br>Processing <b>both</b> strands<br><br><b>");


	  for (i = 0; i < argc; i++)
	    fprintf (F, "%s ", argv[i]);

	  for (i = 0; i < argc; i++)
	    fprintf (HF, "%s ", argv[i]);

	  fprintf (F, "\n\n");
	  fprintf (HF, "<br><br>");

	  fclose (F);
	  fclose (HF);
	  pid = fork ();

	  if (pid == 0)
	    {
	      strcpy (params[7], "-W");
	      strcpy (params[8], "6");
	      strcpy (params[9], "-e");
	      strcpy (params[10], "1");
	      if (multiflag == 1)
		strcpy (params[11], "-M");
	      else
		strcpy (params[11], "-N");

	      if (reverseflag == 1)
		strcpy (params[12], "-S");
	      else
		strcpy (params[12], "-N");

	      //strcpy(params[8],"2> pappa ");
	      params[15] = NULL;

	      //for (i = 0; i < 14; i++)
	      //fprintf (stderr, "%s", params[i]);

	      //getchar();

	      excflag = execvp ("./weederTFBS.out", params);

	      if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
	    }
	  else
	    {
	      if (parallelmode == 0)
		wait (NULL);

	      pid = fork ();

	      if (pid == 0)
		{
		  strcpy (params[7], "-W");
		  strcpy (params[8], "8");
		  strcpy (params[9], "-e");
		  strcpy (params[10], "2");
		  if (multiflag == 1)
		    strcpy (params[11], "-M");
		  else
		    strcpy (params[11], "-N");

		  if (reverseflag == 1)
		    strcpy (params[12], "-S");
		  else
		    strcpy (params[12], "-N");

		  //strcpy(params[8],"2> pappa ");
		  params[15] = NULL;
		  //strcpy(params[8],"2> pappa ");

		  //for (i = 0; i < 20; i++)
		  //fprintf (stderr, "%s", params[i]);

		  //getchar();

		  excflag = execvp ("./weederTFBS.out", params);

		  if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
		}
	      else
		{
		  if (parallelmode == 0)
		    wait (NULL);

		  pid = fork ();

		  if (pid == 0)
		    {
		      strcpy (params[7], "-W");
		      strcpy (params[8], "10");
		      strcpy (params[9], "-e");
		      strcpy (params[10], "3");
		      if (multiflag == 1)
			strcpy (params[11], "-M");
		      else
			strcpy (params[11], "-N");

		      if (reverseflag == 1)
			strcpy (params[12], "-S");
		      else
			strcpy (params[12], "-N");

		      //strcpy(params[8],"2> pappa ");
		      params[15] = NULL;
		      //strcpy(params[8],"2> pappa ");

		      //for (i = 0; i < 20; i++)
		      //fprintf (stderr, "%s", params[i]);

		      //getchar();

		      excflag = execvp ("./weederTFBS.out", params);

		      if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
		    }
		  else
		    {
		      wait (NULL);

		      pid = fork ();

		      if (pid == 0)
			{
			  strcpy (params[0], "./adviser.out");

			  strcpy (params[1], inputfile);

			  if (reverseflag == 0)
			    strcpy (params[2], "N");
			  else
			    strcpy (params[2], "S");;

			  params[3] = NULL;

			  fprintf (stderr, "\nRunning adviser....\n");
			  excflag = execvp ("./adviser.out", params);

			  if (excflag == -1)
	    fprintf (stderr, "\nCould not start the adviser. Make sure it is located in the same directory of weederlauncher. %d\n", errno);

			}
		      else
			exit (0);
		    }
		}

	    }




	}
      else
	{
	  if ((strcmp (analysis, "large") == 0)
	      || (strcmp (analysis, "extra") == 0))
	    {
	      F = fopen (outfile, "a");

	      fprintf (F, "\n\nNEW: Starting a %s job\n", analysis);
	      fprintf (HF, "<br><br>NEW: Starting a %s job on file %s<br>",
		       analysis, inputfile);
	      fprintf (F, "\nOrganism code: %s\n", organism);
	      fprintf (HF, "<br>Organism code: %s<br>", organism);
 if (reverseflag == 1)
        fprintf (F, "\nProcessing *both* strands\n");
      if (reverseflag == 1)
        fprintf (HF, "</b><br>Processing <b>both</b> strands<br><br><b>");


	      for (i = 0; i < argc; i++)
		fprintf (F, "%s ", argv[i]);

	      for (i = 0; i < argc; i++)
		fprintf (HF, "%s ", argv[i]);

	      fprintf (F, "\n\n");
	      fprintf (HF, "<br><br>");

	      fclose (F);
	      fclose (HF);
	      pid = fork ();

	      if (pid == 0)
		{
		  strcpy (params[7], "-W");
		  strcpy (params[8], "6");
		  strcpy (params[9], "-e");
		  strcpy (params[10], "1");
		  if (multiflag == 1)
		    strcpy (params[11], "-M");
		  else
		    strcpy (params[11], "-N");

		  if (reverseflag == 1)
		    strcpy (params[12], "-S");
		  else
		    strcpy (params[12], "-N");

		  //strcpy(params[8],"2> pappa ");
		  params[15] = NULL;

		  //for (i = 0; i < 14; i++)
		  //fprintf (stderr, "%s", params[i]);

		  //getchar();

		  excflag = execvp ("./weederTFBS.out", params);

		  if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
		}
	      else
		{
		  if (parallelmode == 0)
		    wait (NULL);

		  pid = fork ();

		  if (pid == 0)
		    {
		      strcpy (params[7], "-W");
		      strcpy (params[8], "8");
		      strcpy (params[9], "-e");
		      if (strcmp (analysis, "large") == 0)
			strcpy (params[10], "2");
		      else
			strcpy (params[10], "3");


		      if (multiflag == 1)
			strcpy (params[11], "-M");
		      else
			strcpy (params[11], "-N");

		      if (reverseflag == 1)
			strcpy (params[12], "-S");
		      else
			strcpy (params[12], "-N");

		      //strcpy(params[8],"2> pappa ");
		      params[15] = NULL;
		      //strcpy(params[8],"2> pappa ");

		      //for (i = 0; i < 20; i++)
		      //fprintf (stderr, "%s", params[i]);

		      //getchar();

		      excflag = execvp ("./weederTFBS.out", params);

		      if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
		    }
		  else
		    {
		      if (parallelmode == 0)
			wait (NULL);

		      pid = fork ();

		      if (pid == 0)
			{
			  strcpy (params[7], "-W");
			  strcpy (params[8], "10");
			  strcpy (params[9], "-e");
			  if (strcmp (analysis, "large") == 0)
			    strcpy (params[10], "3");
			  else
			    strcpy (params[10], "4");

			  if (multiflag == 1)
			    strcpy (params[11], "-M");
			  else
			    strcpy (params[11], "-N");

			  if (reverseflag == 1)
			    strcpy (params[12], "-S");
			  else
			    strcpy (params[12], "-N");

			  //strcpy(params[8],"2> pappa ");
			  params[15] = NULL;
			  //strcpy(params[8],"2> pappa ");

			  //for (i = 0; i < 20; i++)
			  //fprintf (stderr, "%s", params[i]);

			  //getchar();

			  excflag = execvp ("./weederTFBS.out", params);

			  if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);
			}
		      else
			{
			  if (parallelmode == 0)
			    wait (NULL);

			  pid = fork ();

			  if (pid == 0)
			    {
			      strcpy (params[7], "-W");
			      strcpy (params[8], "12");
			      strcpy (params[9], "-e");
			      strcpy (params[10], "4");
			      if (multiflag == 1)
				strcpy (params[11], "-M");
			      else
				strcpy (params[11], "-N");

			      if (reverseflag == 1)
				strcpy (params[12], "-S");
			      else
				strcpy (params[12], "-N");

			      //strcpy(params[8],"2> pappa ");
			      params[15] = NULL;
			      //strcpy(params[8],"2> pappa ");

			      //for (i = 0; i < 20; i++)
			      //fprintf (stderr, "%s", params[i]);

			      //getchar();

			      excflag = execvp ("./weederTFBS.out", params);

			      if (excflag == -1)
	    fprintf (stderr, "\nCould not start weederTFBS. Make sure it is located in the same directory of weederlauncher. %d\n", errno);

			    }
			  else
			    {
			      wait (NULL);

			      pid = fork ();

			      if (pid == 0)
				{
				  strcpy (params[0], "./adviser.out");

				  strcpy (params[1], inputfile);

				  if (reverseflag == 0)
				    strcpy (params[2], "N");
				  else
				    strcpy (params[2], "S");;

				  params[3] = NULL;

				  fprintf (stderr, "\nRunning adviser....\n");
				  excflag = execvp ("./adviser.out", params);

				  if (excflag == -1)
	    fprintf (stderr, "\nCould not start the adviser. Make sure it is located in the same directory of weederlauncher. %d\n", errno);

				}
			      else
				exit (0);
			    }
			}

		    }

		}


	    }
	  else
	    {
	      fprintf (stderr,
		       "\nUnknown type of analysis %s (please choose small, medium, large or extra)\n",
		       analysis);
	      exit (1);
	    }
	}
    }
}


char *
expandorgname (char *org)
{
  char *fullname;

  fullname = (char *) malloc (80 * sizeof (char));

  strcpy (fullname, "none");

  if (strcmp (org, "HS") == 0)
    strcpy (fullname, "H. sapiens");
  if (strcmp (org, "HSI") == 0)
    strcpy (fullname, "H. sapiens Intergenic");
  if (strcmp (org, "DM") == 0)
    strcpy (fullname, "D. melanogaster");

  if (strcmp (org, "SC") == 0)
    strcpy (fullname, "S. cerevisiae");

  if (strcmp (org, "RN") == 0)
    strcpy (fullname, "R. norvegicus");

  if (strcmp (org, "MM") == 0)
    strcpy (fullname, "M. musculus");
  if (strcmp (org, "MMI") == 0)
    strcpy (fullname, "M. musculus");

  if (strcmp (org, "AT") == 0)
    strcpy (fullname, "A. thaliana");
  if (strcmp (org, "CE") == 0)
    strcpy (fullname, "C. elegans");
  if (strcmp (org, "PF") == 0)
    strcpy (fullname, "P. falciparum");
  if (strcmp (org, "GG") == 0)
    strcpy (fullname, "G. gallus");
  if (strcmp (org, "AG") == 0)
    strcpy (fullname, "A. gambiae");
  if (strcmp (org, "DR") == 0)
    strcpy (fullname, "D. rerio");
  if (strcmp (org, "FR") == 0)
    strcpy (fullname, "F. rubripes");
  if (strcmp (org, "BEC") == 0)
    strcpy (fullname, "E. coli");
  if (strcmp (org, "BBS") == 0)
    strcpy (fullname, "B. subtilis");

  if (strcmp (fullname, "none") == 0)
    {
      fprintf (stderr, "\nUnknown organism identifier : %s\n", org);
      exit (1);
    }


  return fullname;
}
