/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.BrownianMotionPCA;
import umontreal.iro.lecuyer.stochprocess.GammaProcess;

public class GammaProcessPCA
extends GammaProcess {
    double[] arrayTime;
    BrownianMotionPCA BMPCA;

    public GammaProcessPCA(double s0, double mu, double nu, RandomStream stream) {
        super(s0, mu, nu, new GammaGen(stream, new GammaDist(1.0)));
        this.BMPCA = new BrownianMotionPCA(0.0, 0.0, Math.sqrt(nu), stream);
    }

    public GammaProcessPCA(double s0, double mu, double nu, GammaGen Ggen) {
        super(s0, mu, nu, Ggen);
        this.BMPCA = new BrownianMotionPCA(0.0, 0.0, Math.sqrt(nu), Ggen.getStream());
    }

    public double[] generatePath() {
        int i;
        double[] uniformsV = new double[this.d];
        this.arrayTime = this.BMPCA.getObservationTimes();
        double[] BMpath = this.BMPCA.generatePath();
        for (i = 0; i < this.d; ++i) {
            double sigma = this.BMPCA.getSigma() * Math.sqrt(this.arrayTime[i + 1] - this.arrayTime[i]);
            uniformsV[i] = NormalDist.cdf01((BMpath[i + 1] - BMpath[i]) / sigma);
        }
        this.path[0] = this.x0;
        for (i = 0; i < this.d; ++i) {
            this.path[i + 1] = this.path[i] + GammaDist.inverseF(this.mu2dtOverNu[i], this.muOverNu, 15, uniformsV[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        int i;
        double[] uniformsV = new double[this.d];
        this.arrayTime = this.BMPCA.getObservationTimes();
        double[] BMpath = this.BMPCA.generatePath(uniform01);
        for (i = 0; i < this.d; ++i) {
            double sigma = this.BMPCA.getSigma() * Math.sqrt(this.arrayTime[i + 1] - this.arrayTime[i]);
            uniformsV[i] = NormalDist.cdf01((BMpath[i + 1] - BMpath[i]) / sigma);
        }
        this.path[0] = this.x0;
        for (i = 0; i < this.d; ++i) {
            this.path[i + 1] = this.path[i] + GammaDist.inverseF(this.mu2dtOverNu[i], this.muOverNu, 15, uniformsV[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double nextObservation() {
        throw new UnsupportedOperationException("nextObservation is not implemented in GammaProcessPCA");
    }

    public double nextObservation(double nextT) {
        throw new UnsupportedOperationException("nextObservation is not implemented in GammaProcessPCA");
    }

    public BrownianMotionPCA getBMPCA() {
        return this.BMPCA;
    }

    public void setObservationTimes(double[] t, int d) {
        super.setObservationTimes(t, d);
        this.BMPCA.setObservationTimes(t, d);
    }

    public void setParams(double s0, double mu, double nu) {
        super.setParams(s0, mu, nu);
        this.BMPCA.setParams(0.0, 0.0, Math.sqrt(nu));
    }

    public void setStream(RandomStream stream) {
        super.setStream(stream);
        this.BMPCA.setStream(stream);
    }
}

