/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class GammaDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;
    private double logFactor;

    public GammaDist(double alpha) {
        this.setParams(alpha, 1.0, this.decPrec);
    }

    public GammaDist(double alpha, double lambda) {
        this.setParams(alpha, lambda, this.decPrec);
    }

    public GammaDist(double alpha, double lambda, int d) {
        this.setParams(alpha, lambda, d);
    }

    static double belog(double x) {
        double term;
        if (x > 1.0) {
            return -GammaDist.belog(1.0 / x);
        }
        if (x < 1.0E-20) {
            return 1.0;
        }
        if (x < 0.9) {
            return (1.0 - x * x + 2.0 * x * Math.log(x)) / ((1.0 - x) * (1.0 - x));
        }
        if (x == 1.0) {
            return 0.0;
        }
        double EPS = 1.0E-12;
        double Y = 1.0 - x;
        double ypow = 1.0;
        double sum = 0.0;
        int j = 2;
        do {
            term = (ypow *= Y) / (double)(j * (j + 1));
            ++j;
        } while (Math.abs(term / (sum += term)) > 1.0E-12);
        return 2.0 * sum;
    }

    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double z = this.logFactor + (this.alpha - 1.0) * Math.log(x) - this.lambda * x;
        if (z > -1000.0) {
            return Math.exp(z);
        }
        return 0.0;
    }

    public double cdf(double x) {
        return GammaDist.cdf(this.alpha, this.lambda, this.decPrec, x);
    }

    public double inverseF(double u) {
        return GammaDist.inverseF(this.alpha, this.decPrec, u) / this.lambda;
    }

    public double getMean() {
        return GammaDist.getMean(this.alpha, this.lambda);
    }

    public double getVariance() {
        return GammaDist.getVariance(this.alpha, this.lambda);
    }

    public double getStandardDeviation() {
        return GammaDist.getStandardDeviation(this.alpha, this.lambda);
    }

    public static double density(double alpha, double lambda, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        double z = alpha * Math.log(lambda * x) - lambda * x - Num.lnGamma(alpha);
        if (z > -1000.0) {
            return Math.exp(z) / x;
        }
        return 0.0;
    }

    public static double cdf(double alpha, double lambda, int d, double x) {
        return GammaDist.cdf(alpha, d, lambda * x);
    }

    public static double cdf(double alpha, int d, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (1.0 == alpha) {
            return ExponentialDist.cdf(1.0, x);
        }
        double PLIM = 100000.0;
        if (alpha >= 100000.0) {
            double d2 = x + 0.3333333333333333 - alpha - 0.02 / alpha;
            double S = alpha - 0.5;
            double z = d2 * Math.sqrt((1.0 + GammaDist.belog(S / x)) / x);
            return NormalDist.cdf01(z);
        }
        if (x <= 1.0 || x < alpha) {
            double factor = Math.exp(alpha * Math.log(x) - x - Num.lnGamma(alpha));
            double ACU = EPSARRAY[d];
            double GIN = 1.0;
            double TERM = 1.0;
            double RN = alpha;
            while ((TERM *= x / (RN += 1.0)) >= ACU * (GIN += TERM)) {
            }
            return GIN * factor / alpha;
        }
        return 1.0 - GammaDist.barF(alpha, d, x);
    }

    public static double barF(double alpha, double lambda, int d, double x) {
        return GammaDist.barF(alpha, d, lambda * x);
    }

    /*
     * Unable to fully structure code
     */
    public static double barF(double alpha, int d, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        if (1.0 == alpha) {
            return ExponentialDist.barF(1.0, x);
        }
        if (alpha >= 70.0 ? x >= alpha * 100.0 : x >= 1000.0) {
            return 0.0;
        }
        PLIM = 100000.0;
        if (alpha >= 100000.0) {
            d2 = x + 0.3333333333333333 - alpha - 0.02 / alpha;
            S = alpha - 0.5;
            z = d2 * Math.sqrt((1.0 + GammaDist.belog(S / x)) / x);
            return NormalDist.barF01(z);
        }
        if (x <= 1.0 || x < alpha) {
            return 1.0 - GammaDist.cdf(alpha, d, x);
        }
        V = new double[6];
        EPS = GammaDist.EPSARRAY[d];
        RENORM = 1.0E30;
        factor = Math.exp(alpha * Math.log(x) - x - Num.lnGamma(alpha));
        A = 1.0 - alpha;
        B = A + x + 1.0;
        term = 0.0;
        V[0] = 1.0;
        V[1] = x;
        V[2] = x + 1.0;
        V[3] = x * B;
        res = V[2] / V[3];
        block0: while (true) {
            V[4] = (B += 2.0) * V[2] - (A += 1.0) * (term += 1.0) * V[0];
            V[5] = B * V[3] - A * term * V[1];
            if (V[5] != 0.0) {
                R = V[4] / V[5];
                dif = Math.abs(res - R);
                if (dif <= EPS * R) {
                    return factor * res;
                }
                res = R;
            }
            for (i = 0; i < 4; ++i) {
                V[i] = V[i + 2];
            }
            if (!(Math.abs(V[4]) >= 1.0E30)) continue;
            i = 0;
            while (true) {
                if (i < 4) ** break;
                continue block0;
                v0 = i++;
                V[v0] = V[v0] / 1.0E30;
            }
            break;
        }
    }

    public static double inverseF(double alpha, double lambda, int d, double u) {
        return GammaDist.inverseF(alpha, d, u) / lambda;
    }

    public static double inverseF(double alpha, int d, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        u = 1.0 - u;
        double MACHEP = 1.110223E-16f;
        double MAXLOG = 709.782712893384;
        double MINLOG = -708.3964185322641;
        double MAXNUM = Double.MAX_VALUE;
        double x0 = Double.MAX_VALUE;
        double yl = 0.0;
        double x1 = 0.0;
        double yh = 1.0;
        double dithresh = 5.551115123125783E-16;
        double z = 1.0 / (9.0 * alpha);
        double y = 1.0 - z - NormalDist.inverseF01(u) * Math.sqrt(z);
        double x = alpha * y * y * y;
        double lgm = Num.lnGamma(alpha);
        boolean ihalve = false;
        block0: while (true) {
            int i;
            if (ihalve) {
                ihalve = false;
                z = 0.0625;
                if (x0 == Double.MAX_VALUE) {
                    if (x <= 0.0) {
                        x = 1.0;
                    }
                    while (x0 == Double.MAX_VALUE) {
                        y = GammaDist.barF(alpha, d, x = (1.0 + z) * x);
                        if (y < u) {
                            x0 = x;
                            yl = y;
                            break;
                        }
                        z += z;
                    }
                }
                z = 0.5;
                int dir = 0;
                for (i = 0; i < 400; ++i) {
                    x = x1 + z * (x0 - x1);
                    y = GammaDist.barF(alpha, d, x);
                    lgm = (x0 - x1) / (x1 + x0);
                    if (Math.abs(lgm) < dithresh || Math.abs(lgm = (y - u) / u) < dithresh || x <= 0.0) break;
                    if (y >= u) {
                        x1 = x;
                        yh = y;
                        if (dir < 0) {
                            dir = 0;
                            z = 0.5;
                        } else {
                            z = dir > 1 ? 0.5 * z + 0.5 : (u - yl) / (yh - yl);
                        }
                        ++dir;
                        continue;
                    }
                    x0 = x;
                    yl = y;
                    if (dir > 0) {
                        dir = 0;
                        z = 0.5;
                    } else {
                        z = dir < -1 ? 0.5 * z : (u - yl) / (yh - yl);
                    }
                    --dir;
                }
                return x;
            }
            for (i = 0; i < 13; ++i) {
                if (x > x0 || x < x1) {
                    ihalve = true;
                    continue block0;
                }
                y = GammaDist.barF(alpha, d, x);
                if (y < yl || y > yh) {
                    ihalve = true;
                    continue block0;
                }
                if (y < u) {
                    x0 = x;
                    yl = y;
                } else {
                    x1 = x;
                    yh = y;
                }
                z = (alpha - 1.0) * Math.log(x) - x - lgm;
                if (z < -709.782712893384) {
                    ihalve = true;
                    continue block0;
                }
                z = -Math.exp(z);
                if (Math.abs((z = (y - u) / z) / x) < (double)1.110223E-16f) {
                    return x;
                }
                x -= z;
            }
            break;
        }
        return x;
    }

    public static double[] getMLE(double[] x, int n) {
        double d;
        int i;
        double sum = 0.0;
        double sumLn = 0.0;
        double LN_EPS = -709.089565712824;
        double[] parameters = new double[2];
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        for (i = 0; i < n; ++i) {
            sum += x[i];
            if (x[i] <= 0.0) {
                sumLn += -709.089565712824;
                continue;
            }
            sumLn += Math.log(x[i]);
        }
        double empiricalMean = sum / (double)n;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += (x[i] - empiricalMean) * (x[i] - empiricalMean);
        }
        double alphaMME = empiricalMean * empiricalMean * (double)n / sum;
        double a = alphaMME - 1.0;
        if (d <= 0.0) {
            a = 1.0E-5;
        }
        Function f = new Function(n, empiricalMean, sumLn);
        parameters[0] = RootFinder.brentDekker(a, alphaMME + 1.0, f, 1.0E-7);
        parameters[1] = parameters[0] / empiricalMean;
        return parameters;
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int n) {
        return GammaDist.getMLE(x, n);
    }

    public static GammaDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = GammaDist.getMaximumLikelihoodEstimate(x, n);
        return new GammaDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double lambda) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return alpha / lambda;
    }

    public static double getVariance(double alpha, double lambda) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return alpha / (lambda * lambda);
    }

    public static double getStandardDeviation(double alpha, double lambda) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(alpha) / lambda;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double alpha, double lambda, int d) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = alpha;
        this.lambda = lambda;
        this.decPrec = d;
        this.logFactor = alpha * Math.log(lambda) - Num.lnGamma(alpha);
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", lambda = " + this.lambda;
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double empiricalMean;
        private double sumLn;

        public Function(int n, double empiricalMean, double sumLn) {
            this.n = n;
            this.empiricalMean = empiricalMean;
            this.sumLn = sumLn;
        }

        public double evaluate(double x) {
            if (x <= 0.0) {
                return 1.0E200;
            }
            return (double)this.n * Math.log(this.empiricalMean / x) + (double)this.n * Num.digamma(x) - this.sumLn;
        }
    }
}

