/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPString;

public class REXPWrapper {
    private static Class byte_ARRAY;
    private static Class short_ARRAY;
    private static Class int_ARRAY;
    private static Class long_ARRAY;
    private static Class float_ARRAY;
    private static Class double_ARRAY;
    private static Class boolean_ARRAY;
    private static Class String_ARRAY;
    private static Class Byte_ARRAY;
    private static Class Short_ARRAY;
    private static Class Integer_ARRAY;
    private static Class Long_ARRAY;
    private static Class Float_ARRAY;
    private static Class Double_ARRAY;
    private static Class Boolean_ARRAY;

    static {
        try {
            byte_ARRAY = Class.forName("[B");
            short_ARRAY = Class.forName("[S");
            int_ARRAY = Class.forName("[I");
            long_ARRAY = new long[1].getClass();
            float_ARRAY = Class.forName("[F");
            double_ARRAY = Class.forName("[D");
            boolean_ARRAY = Class.forName("[Z");
            String_ARRAY = Class.forName("[Ljava.lang.String;");
            Byte_ARRAY = Class.forName("[Ljava.lang.Byte;");
            Short_ARRAY = Class.forName("[Ljava.lang.Short;");
            Integer_ARRAY = Class.forName("[Ljava.lang.Integer;");
            Long_ARRAY = Class.forName("[Ljava.lang.Long;");
            Float_ARRAY = Class.forName("[Ljava.lang.Float;");
            Double_ARRAY = Class.forName("[Ljava.lang.Double;");
            Boolean_ARRAY = Class.forName("[Ljava.lang.Boolean;");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("problem while initiating the classes");
        }
    }

    public static REXP wrap(Object o) {
        if (o instanceof REXP) {
            return (REXP)o;
        }
        Class<?> clazz = o.getClass();
        if (clazz == Byte.class) {
            byte[] load = new byte[]{(Byte)o};
            return new REXPRaw(load);
        }
        if (clazz == Short.class) {
            return new REXPInteger(((Short)o).intValue());
        }
        if (clazz == Integer.class) {
            return new REXPInteger((Integer)o);
        }
        if (clazz == Long.class) {
            return new REXPInteger(((Long)o).intValue());
        }
        if (clazz == Float.class) {
            return new REXPDouble(((Float)o).doubleValue());
        }
        if (clazz == Double.class) {
            return new REXPDouble((Double)o);
        }
        if (clazz == Boolean.class) {
            return new REXPLogical((Boolean)o);
        }
        if (clazz == String.class) {
            return new REXPString((String)o);
        }
        if (clazz == String_ARRAY) {
            return new REXPString((String[])o);
        }
        if (clazz == byte_ARRAY) {
            return new REXPRaw((byte[])o);
        }
        if (clazz == Byte_ARRAY) {
            Byte[] b = (Byte[])o;
            int n = b.length;
            byte[] bytes = new byte[b.length];
            int i = 0;
            while (i < n) {
                bytes[i] = b[i];
                ++i;
            }
            return new REXPRaw(bytes);
        }
        if (clazz == short_ARRAY) {
            short[] shorts = (short[])o;
            int[] ints = new int[shorts.length];
            int n = ints.length;
            int i = 0;
            while (i < n) {
                ints[i] = shorts[i];
                ++i;
            }
            return new REXPInteger(ints);
        }
        if (clazz == Short_ARRAY) {
            Short[] shorts = (Short[])o;
            int n = shorts.length;
            int[] ints = new int[shorts.length];
            int i = 0;
            while (i < n) {
                ints[i] = shorts[i].intValue();
                ++i;
            }
            return new REXPInteger(ints);
        }
        if (clazz == int_ARRAY) {
            return new REXPInteger((int[])o);
        }
        if (clazz == Integer_ARRAY) {
            Integer[] integers = (Integer[])o;
            int n = integers.length;
            int[] ints = new int[integers.length];
            int i = 0;
            while (i < n) {
                ints[i] = integers[i];
                ++i;
            }
            return new REXPInteger(ints);
        }
        if (clazz == long_ARRAY) {
            long[] longs = (long[])o;
            int n = longs.length;
            int[] ints = new int[longs.length];
            int i = 0;
            while (i < n) {
                ints[i] = (int)longs[i];
                ++i;
            }
            return new REXPInteger(ints);
        }
        if (clazz == Long_ARRAY) {
            Long[] longs = (Long[])o;
            int n = longs.length;
            int[] ints = new int[longs.length];
            int i = 0;
            while (i < n) {
                ints[i] = longs[i].intValue();
                ++i;
            }
            return new REXPInteger(ints);
        }
        if (clazz == float_ARRAY) {
            float[] floats = (float[])o;
            int n = floats.length;
            double[] doubles = new double[floats.length];
            int i = 0;
            while (i < n) {
                doubles[i] = floats[i];
                ++i;
            }
            return new REXPDouble(doubles);
        }
        if (clazz == Float_ARRAY) {
            Float[] floats = (Float[])o;
            int n = floats.length;
            double[] doubles = new double[floats.length];
            int i = 0;
            while (i < n) {
                doubles[i] = floats[i].doubleValue();
                ++i;
            }
            return new REXPDouble(doubles);
        }
        if (clazz == double_ARRAY) {
            return new REXPDouble((double[])o);
        }
        if (clazz == Double_ARRAY) {
            Double[] doubles = (Double[])o;
            double n = doubles.length;
            double[] d = new double[doubles.length];
            int i = 0;
            while ((double)i < n) {
                d[i] = doubles[i];
                ++i;
            }
            return new REXPDouble(d);
        }
        if (clazz == boolean_ARRAY) {
            return new REXPLogical((boolean[])o);
        }
        if (clazz == Boolean_ARRAY) {
            Boolean[] booleans = (Boolean[])o;
            int n = booleans.length;
            boolean[] b = new boolean[booleans.length];
            int i = 0;
            while (i < n) {
                b[i] = booleans[i];
                ++i;
            }
            return new REXPLogical(b);
        }
        return null;
    }
}

