/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.util;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.ConjugateGradient;
import java.io.Serializable;

public class AngleOptimization2D
implements RealFunctionOfSeveralVariablesWithGradient,
Serializable {
    double[] length;
    double[] cosAngle;
    double[] edge;
    boolean[] pointIsFix;
    int[] index;
    int numOfElements;
    int numOfPoints;
    double cosMinAngle = 0.5;
    int numOfEvaluations = 0;

    public AngleOptimization2D(int[] nArray, boolean[] blArray) {
        this.index = nArray;
        this.pointIsFix = blArray;
        this.numOfPoints = blArray.length / 2;
        this.numOfElements = nArray.length / 3;
    }

    public static boolean[] pointIsFix(int[] nArray, int[] nArray2, int n) {
        boolean[] blArray = new boolean[n];
        int n2 = nArray.length / 3;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            for (int i = 0; i < 3; ++i) {
                if (nArray2[n4 + i] != -1) continue;
                blArray[nArray[n4 + (i + 1) % 3]] = true;
                blArray[nArray[n4 + (i + 2) % 3]] = true;
            }
            ++n3;
            n4 += 3;
        }
        return blArray;
    }

    public AngleOptimization2D(int[] nArray, int[] nArray2, int n) {
        this(nArray, AngleOptimization2D.pointIsFix(nArray, nArray2, n));
    }

    public final double edge(int n, int n2, int n3) {
        return this.edge[(n * 3 + n2) * 2 + n3];
    }

    public void updateEdge(double[] dArray) {
        if (this.edge == null || this.edge.length != 6 * this.numOfElements) {
            this.edge = new double[6 * this.numOfElements];
        }
        int n = 0;
        for (int i = 0; i < this.numOfElements; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.edge[n++] = dArray[this.index[i * 3 + (j + 2) % 3] * 2 + k] - dArray[this.index[i * 3 + (j + 1) % 3] * 2 + k];
                }
            }
        }
    }

    public final double length(int n, int n2) {
        return this.length[n * 3 + n2];
    }

    public void updateLength() {
        if (this.length == null || this.length.length != 3 * this.numOfElements) {
            this.length = new double[3 * this.numOfElements];
        }
        int n = 0;
        for (int i = 0; i < this.numOfElements; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.length[n++] = Math.sqrt(this.edge(i, j, 0) * this.edge(i, j, 0) + this.edge(i, j, 1) * this.edge(i, j, 1));
            }
        }
    }

    public double cosAngle(int n, int n2) {
        return this.cosAngle[n * 3 + n2];
    }

    public void updateCosAngle() {
        if (this.cosAngle == null || this.cosAngle.length != 3 * this.numOfElements) {
            this.cosAngle = new double[3 * this.numOfElements];
        }
        boolean bl = false;
        for (int i = 0; i < this.numOfElements; ++i) {
            for (int j = 0; j < 3; ++j) {
                double d = this.length(i, (j + 2) % 3);
                double d2 = this.length(i, (j + 1) % 3);
                double d3 = this.length(i, j);
                this.cosAngle[i * 3 + j] = (d * d + d2 * d2 - d3 * d3) / (2.0 * d * d2);
            }
        }
    }

    public int getNumberOfVariables() {
        return this.numOfPoints * 2;
    }

    public double eval(double[] dArray, double[] dArray2) {
        this.setDoubleArrayParameter(dArray, 0);
        this.getDoubleArrayValue(dArray2, 0);
        return this.getDoubleValue();
    }

    public double eval(double[] dArray) {
        this.setDoubleArrayParameter(dArray, 0);
        return this.getDoubleValue();
    }

    public double getDoubleValue() {
        ++this.numOfEvaluations;
        double d = 0.0;
        for (int i = 0; i < this.numOfElements; ++i) {
            for (int j = 0; j < 3; ++j) {
                double d2 = this.cosAngle(i, j) - this.cosMinAngle;
                if (!(d2 > 0.0)) continue;
                d += d2 * d2;
            }
        }
        return d / 2.0;
    }

    public int getDoubleArrayParameterLength() {
        return this.numOfPoints * 2;
    }

    public void setDoubleArrayParameter(double[] dArray, int n) {
        if (n != 0) {
            throw new RuntimeException("offset is not supported");
        }
        this.updateEdge(dArray);
        this.updateLength();
        this.updateCosAngle();
    }

    public int getDoubleArrayValueLength() {
        return this.numOfPoints * 2;
    }

    public void getDoubleArrayValue(double[] dArray, int n) {
        int n2;
        int n3 = n + this.numOfPoints * 2;
        for (n2 = n; n2 < n3; ++n2) {
            dArray[n2] = 0.0;
        }
        n2 = this.index.length / 3;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 3; ++j) {
                double d = this.cosAngle(i, j) - this.cosMinAngle;
                if (!(d > 0.0)) continue;
                int n4 = this.index[3 * i + j];
                int n5 = this.index[3 * i + (j + 1) % 3];
                int n6 = this.index[3 * i + (j + 2) % 3];
                double d2 = this.length(i, (j + 2) % 3);
                double d3 = this.length(i, (j + 1) % 3);
                double d4 = d / (d2 * d3);
                double d5 = (1.0 - this.cosAngle(i, j) * d3 / d2) * d4;
                double d6 = (1.0 - this.cosAngle(i, j) * d2 / d3) * d4;
                for (int k = 0; k < 2; ++k) {
                    int n7 = n + n5 * 2 + k;
                    dArray[n7] = dArray[n7] + this.edge(i, (j + 2) % 3, k) * d5;
                    int n8 = n + n4 * 2 + k;
                    dArray[n8] = dArray[n8] - this.edge(i, (j + 2) % 3, k) * d5;
                    int n9 = n + n4 * 2 + k;
                    dArray[n9] = dArray[n9] + this.edge(i, (j + 1) % 3, k) * d6;
                    int n10 = n + n6 * 2 + k;
                    dArray[n10] = dArray[n10] - this.edge(i, (j + 1) % 3, k) * d6;
                    int n11 = n + n6 * 2 + k;
                    dArray[n11] = dArray[n11] - this.edge(i, j, k) * d4;
                    int n12 = n + n5 * 2 + k;
                    dArray[n12] = dArray[n12] + this.edge(i, j, k) * d4;
                }
            }
        }
        this.nilFixedPoints(dArray);
    }

    void nilFixedPoints(double[] dArray) {
        int n = 0;
        int n2 = 0;
        while (n < this.numOfPoints) {
            if (this.pointIsFix[n]) {
                dArray[n2 + 1] = 0.0;
                dArray[n2] = 0.0;
            }
            ++n;
            n2 += 2;
        }
    }

    public double getMinAngle(double[] dArray) {
        this.setDoubleArrayParameter(dArray, 0);
        double d = -1.0;
        int n = 0;
        for (int i = 0; i < this.numOfElements; ++i) {
            int n2 = 0;
            while (n2 < 3) {
                if (this.cosAngle[n] > d) {
                    d = this.cosAngle[n];
                }
                ++n2;
                ++n;
            }
        }
        return Math.acos(d);
    }

    public static void minimize(double[] dArray, int[] nArray, int[] nArray2, double d, int n, double d2) {
        AngleOptimization2D angleOptimization2D = new AngleOptimization2D(nArray, nArray2, dArray.length);
        angleOptimization2D.cosMinAngle = Math.cos(d / 180.0 * Math.PI);
        System.out.println("minimal angle before minimizing: " + angleOptimization2D.getMinAngle(dArray) / Math.PI * 180.0);
        ConjugateGradient.search(dArray, d2, angleOptimization2D, n, false, null);
        System.out.println("number of evaluations : " + angleOptimization2D.numOfEvaluations);
        System.out.println("minimal angle after minimizing:  " + angleOptimization2D.getMinAngle(dArray) / Math.PI * 180.0);
    }

    public static boolean minimize(double[] dArray, int[] nArray, int[] nArray2, int n, double d) {
        AngleOptimization2D angleOptimization2D = new AngleOptimization2D(nArray, nArray2, dArray.length);
        angleOptimization2D.cosMinAngle = Math.cos(angleOptimization2D.getMinAngle(dArray) + Math.PI / 180);
        double d2 = angleOptimization2D.getMinAngle(dArray) / Math.PI * 180.0;
        System.out.println("minimal angle before minimizing: " + d2);
        ConjugateGradient.search(dArray, d, angleOptimization2D, n, false, null);
        double d3 = angleOptimization2D.getMinAngle(dArray) / Math.PI * 180.0;
        System.out.println("minimal angle after minimizing:  " + d3);
        return d3 - 0.1 > d2;
    }

    public static void minimize(double[] dArray, int[] nArray, int[] nArray2, int n, int n2, double d) {
        for (int i = 0; i < n2 && AngleOptimization2D.minimize(dArray, nArray, nArray2, n, d); ++i) {
        }
    }
}

