/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.Line;
import java.io.Serializable;

class RealDerivativeOnLine
implements RealFunctionOfOneVariable,
Serializable {
    private static final long serialVersionUID = 1L;
    final RealFunctionOfSeveralVariablesWithGradient f;
    final Line line;
    final double[] gradAtX;

    RealDerivativeOnLine(Line line, RealFunctionOfSeveralVariablesWithGradient realFunctionOfSeveralVariablesWithGradient) {
        this.line = line;
        this.f = realFunctionOfSeveralVariablesWithGradient;
        this.gradAtX = new double[line.n];
    }

    RealDerivativeOnLine(double[] dArray, double[] dArray2, RealFunctionOfSeveralVariablesWithGradient realFunctionOfSeveralVariablesWithGradient) {
        this(new Line(dArray, dArray2), realFunctionOfSeveralVariablesWithGradient);
    }

    public final double eval(double d) {
        this.line.getPoint(d, this.line.otherPoint);
        this.f.eval(this.line.otherPoint, this.gradAtX);
        double d2 = 0.0;
        for (int i = 0; i < this.line.n; ++i) {
            d2 += this.gradAtX[i] * this.line.direction[i];
        }
        return d2;
    }
}

