/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.BrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.DBrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import de.jtem.numericalMethods.calculus.minimizing.MinimizingOnLine;
import java.io.Serializable;

public final class ConjugateGradient
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double CGOLD = 0.381966;
    static int ITMAX = 100;
    static final double EPS = 1.0E-10;
    private static boolean useDBrent = false;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int n) {
        ITMAX = n;
    }

    public static boolean getUseDBrent() {
        return useDBrent;
    }

    public static void setUseDBrent(boolean bl) {
        useDBrent = bl;
    }

    public static double search(double[] dArray, double d, RealFunctionOfSeveralVariablesWithGradient realFunctionOfSeveralVariablesWithGradient) {
        return ConjugateGradient.search(dArray, d, realFunctionOfSeveralVariablesWithGradient, ITMAX, useDBrent, null);
    }

    public static double search(double[] dArray, double d, RealFunctionOfSeveralVariablesWithGradient realFunctionOfSeveralVariablesWithGradient, int n, boolean bl, Info info) {
        int n2;
        double d2;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        MinimizingOnLine minimizingOnLine = bl ? new DBrentOnLine(dArray, dArray4, realFunctionOfSeveralVariablesWithGradient) : new BrentOnLine(dArray, dArray4, realFunctionOfSeveralVariablesWithGradient);
        double d3 = d2 = realFunctionOfSeveralVariablesWithGradient.eval(dArray, dArray4);
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n2] = -dArray4[n2];
            dArray4[n2] = dArray2[n2] = dArray3[n2];
        }
        if (info != null) {
            info.setMaxIter(n);
        }
        for (n2 = 0; n2 < n; ++n2) {
            d3 = minimizingOnLine.search(2.0E-8);
            if (2.0 * Math.abs(d3 - d2) <= d * (Math.abs(d3) + Math.abs(d2) + 1.0E-10)) {
                if (info != null) {
                    info.setMessage("ConjugateGradient " + n2 + ": " + 2.0 * Math.abs(d3 - d2) + " (" + d * (Math.abs(d3) + Math.abs(d2) + 1.0E-10) + ")");
                    info.setCurrentIter(n2);
                    info.printDebug();
                }
                return d3;
            }
            d2 = realFunctionOfSeveralVariablesWithGradient.eval(dArray, dArray4);
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < n3; ++i) {
                d5 += dArray3[i] * dArray3[i];
                d4 += (dArray4[i] + dArray3[i]) * dArray4[i];
            }
            if (d5 == 0.0) {
                if (info != null) {
                    info.setCurrentIter(n2);
                    info.printDebug();
                }
                return d3;
            }
            double d6 = d4 / d5;
            for (int i = 0; i < n3; ++i) {
                dArray3[i] = -dArray4[i];
                dArray4[i] = dArray2[i] = dArray3[i] + d6 * dArray2[i];
            }
        }
        if (info != null) {
            info.setCurrentIter(n);
            info.setMessage(info.getMessage() + "\n" + "Too many iterations in ConjugateGradient\n");
        }
        return d3;
    }
}

