/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public abstract class PositionDiffSM
extends AbstractDifferentiableStatisticalModel {
    protected int[] internal;

    protected PositionDiffSM(AlphabetContainer con, int length) {
        super(con, length);
        this.internal = new int[length];
        this.reset();
    }

    protected PositionDiffSM(int min, int max) {
        this(new AlphabetContainer((Alphabet)new DiscreteAlphabet(min, max)), 1);
    }

    protected PositionDiffSM(StringBuffer source) throws NonParsableException {
        super(source);
    }

    @Override
    public PositionDiffSM clone() throws CloneNotSupportedException {
        PositionDiffSM clone = (PositionDiffSM)super.clone();
        clone.internal = (int[])this.internal.clone();
        return clone;
    }

    public abstract void reset();

    public abstract boolean next();

    public void getInternalPosition(int[] positions) {
        int i = 0;
        while (i < this.length) {
            positions[i] = this.internal[i];
            ++i;
        }
    }

    public double getLogScoreForInternal() {
        return this.getLogScore(this.internal);
    }

    public double getLogScoreAndPartialDerivationForInternal(IntList indices, DoubleList partialDer) {
        return this.getLogScoreAndPartialDerivation(indices, partialDer, this.internal);
    }

    public abstract double getLogScore(int ... var1);

    public abstract double getLogScoreAndPartialDerivation(IntList var1, DoubleList var2, int ... var3);

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        return this.getLogScore(this.getValuesFromSequence(seq, start));
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        return this.getLogScoreAndPartialDerivation(indices, partialDer, this.getValuesFromSequence(seq, start));
    }

    protected int[] getValuesFromSequence(Sequence seq, int start) {
        int[] res = new int[this.length];
        int i = 0;
        while (i < this.length) {
            res[i] = seq.discreteVal(start + i);
            ++i;
        }
        return res;
    }

    public abstract boolean isPossible(int ... var1);

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(10000);
        XMLParser.appendObjectWithTags(xml, this.alphabets, "AlphabetContainer");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.internal, "internal");
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "AlphabetContainer");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.internal = XMLParser.extractObjectForTags(xml, "internal", int[].class);
    }
}

