/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class StudentGen
extends RandomVariateGen {
    protected int n = -1;

    public StudentGen(RandomStream s, int n) {
        super(s, new StudentDist(n));
        this.setN(n);
    }

    public StudentGen(RandomStream s, StudentDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setN(dist.getN());
        }
    }

    public static double nextDouble(RandomStream s, int n) {
        double t;
        double limit = 1.0E-20;
        double pi = Math.PI;
        double u = s.nextDouble();
        double e = n;
        double p = u > 0.5 ? 2.0 * (1.0 - u) : 2.0 * u;
        if (p <= 2.0E-20) {
            throw new IllegalArgumentException("Calling InvStudentDist with u < E-20 or u > 1 - E-20");
        }
        if (n == 1) {
            t = Math.abs(Math.cos(Math.PI * p / 2.0) / Math.sin(Math.PI * p / 2.0));
        } else if (n == 2) {
            t = Math.sqrt(2.0 / (p * (2.0 - p)) - 2.0);
        } else {
            double a = 1.0 / (e - 0.5);
            double b = 48.0 / (a * a);
            double c = ((20700.0 / b * a - 98.0) * a - 16.0) * a + 96.36;
            double d = e * Math.sqrt(a * Math.PI / 2.0) * ((94.5 / (b + c) - 3.0) / b + 1.0);
            double y = Math.pow(d * p, 2.0 / e);
            if (y > a + 0.05) {
                double x = p == 1.0 ? 0.0 : NormalDist.inverseF01(p * 0.5);
                y = x * x;
                if (n < 5) {
                    c += 0.3 * (e - 4.5) * (x + 0.6);
                }
                c = (((0.05 * d * x - 5.0) * x - 7.0) * x - 2.0) * x + b + c;
                y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
                y = (y = a * (y * y)) > 0.002 ? Math.exp(y) - 1.0 : 0.5 * y * y + y;
            } else {
                y = ((1.0 / (((e + 6.0) / (e * y) - 0.089 * d - 0.822) * (e + 2.0) * 3.0) + 0.5 / (e + 4.0)) * y - 1.0) * (e + 1.0) / (e + 2.0) + 1.0 / y;
            }
            t = Math.sqrt(e * y);
        }
        if (u < 0.5) {
            return -t;
        }
        return t;
    }

    public int getN() {
        return this.n;
    }

    protected void setN(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = nu;
    }
}

