/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.utils.StringTools;

public class UniProtLocationParser {
    private static Pattern sp = Pattern.compile("^(<|>)?(\\d+)(<|>)?$");

    private UniProtLocationParser() {
    }

    public static RichLocation parseLocation(String loc) throws ParseException {
        try {
            String[] parts = loc.trim().split("\\s+");
            Position startPos = UniProtLocationParser.parsePosition(parts[0].trim());
            Position endPos = UniProtLocationParser.parsePosition(parts[1].trim());
            return new SimpleRichLocation(startPos, endPos, 1, RichLocation.Strand.POSITIVE_STRAND, null);
        }
        catch (RuntimeException ex) {
            throw new ParseException(ex, "Cannot parse location: " + loc);
        }
    }

    private static Position parsePosition(String position) throws ParseException {
        Matcher sm = sp.matcher(position);
        if (!sm.matches()) {
            throw new ParseException("Could not understand position: " + position);
        }
        String startfuzz = sm.group(1);
        String point = sm.group(2);
        String endfuzz = sm.group(3);
        boolean startsFuzzy = startfuzz != null && startfuzz.equals("<") || endfuzz != null && endfuzz.equals("<");
        boolean endsFuzzy = endfuzz != null && endfuzz.equals(">") || startfuzz != null && startfuzz.equals(">");
        return new SimplePosition(startsFuzzy, endsFuzzy, Integer.parseInt(point));
    }

    public static String writeLocation(RichLocation l) {
        return UniProtLocationParser._writeSingleLocation(l);
    }

    private static String _writePosition(Position p, boolean useMax) {
        StringBuffer sb = new StringBuffer();
        int s = p.getStart();
        int e = p.getEnd();
        boolean fs = p.getFuzzyStart();
        boolean fe = p.getFuzzyEnd();
        int a = s != e ? (useMax ? RichObjectFactory.getDefaultPositionResolver().getMax(p) : RichObjectFactory.getDefaultPositionResolver().getMin(p)) : s;
        if (fs) {
            sb.append("<");
        }
        sb.append(a);
        if (fe) {
            sb.append(">");
        }
        return sb.toString();
    }

    private static String _writeSingleLocation(RichLocation l) {
        StringBuffer loc = new StringBuffer();
        loc.append(StringTools.leftPad(UniProtLocationParser._writePosition(l.getMinPosition(), false), 6));
        loc.append(" ");
        loc.append(StringTools.leftPad(UniProtLocationParser._writePosition(l.getMaxPosition(), true), 6));
        return loc.toString();
    }
}

