/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlockListener;

public interface NexusBlockParser {
    public static final String UNKNOWN_BLOCK = "__UNKNOWN";

    public void startBlock(String var1);

    public void endBlock();

    public void parseToken(String var1) throws ParseException;

    public void beginComment();

    public void endComment();

    public void endTokenGroup();

    public void commentText(String var1) throws ParseException;

    public NexusBlockListener getBlockListener();

    public boolean wantsBracketsAndBraces();

    public static abstract class Abstract
    implements NexusBlockParser {
        private NexusBlockListener blockListener;
        private String blockName;

        public Abstract(NexusBlockListener blockListener) {
            this.blockListener = blockListener;
            this.blockName = null;
        }

        public NexusBlockListener getBlockListener() {
            return this.blockListener;
        }

        public void startBlock(String blockName) {
            this.resetStatus();
            this.blockName = blockName;
            this.blockListener.startBlock(blockName);
        }

        protected abstract void resetStatus();

        protected String getBlockName() {
            return this.blockName;
        }

        public void endBlock() {
            this.blockName = null;
            this.blockListener.endBlock();
        }

        public void beginComment() {
            this.blockListener.beginComment();
        }

        public void endComment() {
            this.blockListener.endComment();
        }

        public void endTokenGroup() {
            this.blockListener.endTokenGroup();
        }

        public void commentText(String comment) throws ParseException {
            this.blockListener.commentText(comment);
        }

        public abstract void parseToken(String var1) throws ParseException;

        public boolean wantsBracketsAndBraces() {
            return false;
        }
    }
}

