/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.List;
import org.biojava.bio.gui.sequence.GUITools;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.symbol.Location;

public class RulerRenderer
implements SequenceRenderer {
    public static final int TICKS_UP = 0;
    public static final int TICKS_DOWN = 1;
    private Line2D line = new Line2D.Double();
    private double depth;
    private AffineTransform antiQuarter = AffineTransform.getRotateInstance(Math.toRadians(-90.0));
    private int tickDirection;
    private float tickHeight;
    private float horizLabelOffset;
    private float vertLabelOffset;

    public RulerRenderer() throws IllegalArgumentException {
        this(1);
    }

    public RulerRenderer(int tickDirection) throws IllegalArgumentException {
        if (tickDirection != 0 && tickDirection != 1) {
            throw new IllegalArgumentException("Tick direction may only be set to RulerRenderer.TICKS_UP or RulerRenderer.TICKS_DOWN");
        }
        this.tickDirection = tickDirection;
        this.depth = 20.0;
        this.tickHeight = 4.0f;
        this.horizLabelOffset = (float)this.depth - this.tickHeight - 2.0f;
        this.vertLabelOffset = (float)this.depth - (this.tickHeight + 2.0f) * 2.0f;
    }

    public double getMinimumLeader(SequenceRenderContext context) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext context) {
        return 0.0;
    }

    public double getDepth(SequenceRenderContext src) {
        return this.depth + 1.0;
    }

    public void paint(Graphics2D g2, SequenceRenderContext context) {
        int minP;
        AffineTransform prevTransform = g2.getTransform();
        g2.setPaint(Color.black);
        Location visible = GUITools.getVisibleRange(context, g2);
        if (visible == Location.empty) {
            return;
        }
        int min = visible.getMin();
        int max = visible.getMax();
        double minX = context.sequenceToGraphics(min);
        double maxX = context.sequenceToGraphics(max);
        double scale = context.getScale();
        double halfScale = scale * 0.5;
        if (context.getDirection() == 0) {
            if (this.tickDirection == 0) {
                this.line.setLine(minX - halfScale, this.depth, maxX + halfScale, this.depth);
            } else {
                this.line.setLine(minX - halfScale, 0.0, maxX + halfScale, 0.0);
            }
        } else if (this.tickDirection == 0) {
            this.line.setLine(this.depth, minX - halfScale, this.depth, maxX + halfScale);
        } else {
            this.line.setLine(0.0, minX - halfScale, 0.0, maxX + halfScale);
        }
        g2.draw(this.line);
        FontMetrics fMetrics = g2.getFontMetrics();
        int coordWidth = fMetrics.stringWidth(Integer.toString(max));
        double minGap = Math.max(coordWidth, 40);
        int realSymsPerGap = (int)Math.ceil((minGap + 5.0) / context.getScale());
        double exponent = Math.floor(Math.log(realSymsPerGap) / Math.log(10.0));
        double characteristic = (double)realSymsPerGap / Math.pow(10.0, exponent);
        int snapSymsPerGap = characteristic > 5.0 ? (int)Math.pow(10.0, exponent + 1.0) : (characteristic > 2.0 ? (int)(5.0 * Math.pow(10.0, exponent)) : (int)(2.0 * Math.pow(10.0, exponent)));
        for (int index = minP = min + (snapSymsPerGap - min) % snapSymsPerGap; index <= max; index += snapSymsPerGap) {
            double offset = context.sequenceToGraphics(index);
            String labelString = String.valueOf(index);
            float halfLabelWidth = fMetrics.stringWidth(labelString) / 2;
            if (context.getDirection() == 0) {
                if (this.tickDirection == 0) {
                    this.line.setLine(offset + halfScale, this.depth - (double)this.tickHeight, offset + halfScale, this.depth);
                    g2.drawString(String.valueOf(index), (float)(offset + halfScale - (double)halfLabelWidth), this.horizLabelOffset);
                } else {
                    this.line.setLine(offset + halfScale, 0.0, offset + halfScale, this.tickHeight);
                    g2.drawString(String.valueOf(index), (float)(offset + halfScale - (double)halfLabelWidth), this.horizLabelOffset);
                }
            } else if (this.tickDirection == 0) {
                this.line.setLine(this.depth, offset + halfScale, this.depth - (double)this.tickHeight, offset + halfScale);
                g2.translate(this.vertLabelOffset, offset + halfScale + (double)halfLabelWidth);
                g2.transform(this.antiQuarter);
                g2.drawString(String.valueOf(index), 0.0f, 0.0f);
                g2.setTransform(prevTransform);
            } else {
                this.line.setLine(0.0, offset + halfScale, this.tickHeight, offset + halfScale);
                g2.translate(this.vertLabelOffset, offset + halfScale + (double)halfLabelWidth);
                g2.transform(this.antiQuarter);
                g2.drawString(String.valueOf(index), 0.0f, 0.0f);
                g2.setTransform(prevTransform);
            }
            g2.draw(this.line);
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext context, MouseEvent me, List path) {
        path.add(this);
        int sPos = context.graphicsToSequence(me.getPoint());
        return new SequenceViewerEvent(this, null, sPos, me, path);
    }
}

