/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.ruppert;

import de.jtem.numericalMethods.geometry.meshGeneration.ruppert.Initializer;
import de.jtem.numericalMethods.geometry.meshGeneration.ruppert.Ruppert;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;

public class DelaunayViewer
implements Serializable {
    private static final long serialVersionUID = 1L;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    int FX_SIZE = 500;
    int FY_SIZE = 500;
    int X_SIZE = 500;
    int Y_SIZE;
    double[] point;
    int[] face;
    int nof;
    int[] xx = new int[3];
    int[] yy = new int[3];

    public DelaunayViewer(Ruppert ruppert) {
        this.setTriangle(ruppert);
        this.init(ruppert);
    }

    public DelaunayViewer(int n, Ruppert ruppert) {
        this.X_SIZE = n;
        this.setTriangle(ruppert);
        this.init(ruppert);
    }

    public void setTriangle(Ruppert ruppert) {
        this.point = ruppert.getPoints();
        this.face = ruppert.getIndices();
        this.nof = this.face.length / 3;
        int n = this.point.length;
        this.xmin = this.xmax = this.point[0];
        this.ymin = this.ymax = this.point[1];
        int n2 = 2;
        while (n2 < n) {
            int n3 = n2++;
            double d = this.point[n3];
            if (d < this.xmin) {
                this.xmin = d;
            }
            if (d > this.xmax) {
                this.xmax = d;
            }
            int n4 = n2++;
            double d2 = this.point[n4];
            if (d2 < this.ymin) {
                this.ymin = d2;
            }
            if (!(d2 > this.ymax)) continue;
            this.ymax = d2;
        }
        this.Y_SIZE = (int)((double)this.X_SIZE * (this.ymax - this.ymin) / (this.xmax - this.xmin));
    }

    final void init(Ruppert ruppert) {
        Frame frame = new Frame("Triangulation");
        frame.setSize(this.FX_SIZE, this.FY_SIZE);
        DrawingPanel drawingPanel = new DrawingPanel();
        frame.add(drawingPanel);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Frame frame2 = new Frame("Ruppertment constraints");
        DelaunayPanel delaunayPanel = new DelaunayPanel(ruppert, this, drawingPanel);
        frame2.add(delaunayPanel);
        frame2.setSize(this.X_SIZE, this.X_SIZE / 3);
        frame2.setVisible(true);
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{-2.0, 0.0, 1.0, 2.0, 0.0, 1.0};
        int[] nArray = new int[]{20, 20};
        new DelaunayViewer(Initializer.init(-4.0, -2.0, 4.0, 2.0, 2, 2, dArray, nArray));
    }

    class DelaunayPanel
    extends Panel {
        int area;
        int angle;
        Scrollbar angleS;
        Scrollbar areaS;
        TextField angleT;
        TextField areaT;
        Button quitB;
        Button refineB;

        DelaunayPanel(Ruppert ruppert, DelaunayViewer delaunayViewer2, DrawingPanel drawingPanel) {
            this.angle = (int)ruppert.getAngleConstraint();
            this.area = (int)(100.0 * ruppert.getAreaConstraint());
            this.setLayout(new GridLayout(3, 3));
            this.angleS = new Scrollbar(0, 0, 1, 0, 35);
            this.angleS.addAdjustmentListener(new AdjustmentListener(this){
                private final /* synthetic */ DelaunayPanel this$1;
                {
                    this.this$1 = delaunayPanel;
                }

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    this.this$1.angle = adjustmentEvent.getValue();
                    this.this$1.repaint();
                }
            });
            this.angleT = new TextField();
            this.angleT.addActionListener(new ActionListener(this){
                private final /* synthetic */ DelaunayPanel this$1;
                {
                    this.this$1 = delaunayPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.angle = Integer.valueOf(this.this$1.angleT.getText());
                    this.this$1.repaint();
                }
            });
            this.areaS = new Scrollbar(0, 0, 10, 0, 1000);
            this.areaS.addAdjustmentListener(new AdjustmentListener(this){
                private final /* synthetic */ DelaunayPanel this$1;
                {
                    this.this$1 = delaunayPanel;
                }

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    this.this$1.area = 1 + adjustmentEvent.getValue();
                    this.this$1.repaint();
                }
            });
            this.areaT = new TextField();
            this.areaT.addActionListener(new ActionListener(this){
                private final /* synthetic */ DelaunayPanel this$1;
                {
                    this.this$1 = delaunayPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.area = (int)(100.0 * Double.valueOf(this.this$1.areaT.getText()));
                    this.this$1.repaint();
                }
            });
            this.quitB = new Button("quit");
            this.quitB.addActionListener(new ActionListener(this){
                private final /* synthetic */ DelaunayPanel this$1;
                {
                    this.this$1 = delaunayPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            this.refineB = new Button("refine");
            this.refineB.addActionListener(new ActionListener(this, ruppert, delaunayViewer2, drawingPanel){
                private final /* synthetic */ Ruppert val$d;
                private final /* synthetic */ DelaunayViewer val$dv;
                private final /* synthetic */ DrawingPanel val$dp;
                private final /* synthetic */ DelaunayPanel this$1;
                {
                    this.this$1 = delaunayPanel;
                    this.val$d = ruppert;
                    this.val$dv = delaunayViewer;
                    this.val$dp = drawingPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$d.setAngleConstraint(this.this$1.angle);
                    this.val$d.setAreaConstraint(0.01 * (double)this.this$1.area);
                    this.val$d.refine();
                    this.val$dv.setTriangle(this.val$d);
                    this.val$dp.repaint();
                }
            });
            this.add(new Label("angle"));
            this.add(this.angleS);
            this.add(this.angleT);
            this.add(new Label("area "));
            this.add(this.areaS);
            this.add(this.areaT);
            this.add(new Label(""));
            this.add(this.quitB);
            this.add(this.refineB);
        }

        public void paint(Graphics graphics) {
            if (this.angle < 0) {
                this.angle = 0;
            }
            if (this.angle > 34) {
                this.angle = 34;
            }
            if (this.area < 1) {
                this.area = 1;
            }
            if (this.area > 1000) {
                this.area = 1000;
            }
            this.angleT.setText(Integer.toString(this.angle));
            this.angleS.setValue(this.angle);
            this.areaT.setText(Double.toString(0.01 * (double)this.area));
            this.areaS.setValue(this.area - 1);
        }
    }

    class DrawingPanel
    extends Panel {
        DrawingPanel() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, DelaunayViewer.this.X_SIZE, DelaunayViewer.this.Y_SIZE);
            double d = (double)(4 * DelaunayViewer.this.X_SIZE) / (5.0 * (DelaunayViewer.this.xmax - DelaunayViewer.this.xmin));
            double d2 = (double)(4 * DelaunayViewer.this.Y_SIZE) / (5.0 * (DelaunayViewer.this.ymax - DelaunayViewer.this.ymin));
            int n = DelaunayViewer.this.X_SIZE / 10;
            int n2 = DelaunayViewer.this.Y_SIZE / 10;
            int n3 = 0;
            for (int i = 0; i < DelaunayViewer.this.nof; ++i) {
                int n4 = 0;
                while (n4 < 3) {
                    DelaunayViewer.this.xx[n4] = n + (int)((DelaunayViewer.this.point[2 * DelaunayViewer.this.face[n3]] - DelaunayViewer.this.xmin) * d);
                    DelaunayViewer.this.yy[n4] = DelaunayViewer.this.Y_SIZE - n2 - (int)((DelaunayViewer.this.point[2 * DelaunayViewer.this.face[n3] + 1] - DelaunayViewer.this.ymin) * d2);
                    ++n4;
                    ++n3;
                }
                graphics.setColor(Color.green);
                graphics.fillPolygon(DelaunayViewer.this.xx, DelaunayViewer.this.yy, 3);
                graphics.setColor(Color.blue);
                graphics.drawPolygon(DelaunayViewer.this.xx, DelaunayViewer.this.yy, 3);
            }
        }
    }
}

