/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.OdeSolverBasedIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.RungeKuttaFehlberg;

public final class RungeKuttaFehlbergIntegrator
extends OdeSolverBasedIntegrator {
    private static final long serialVersionUID = 1L;
    double initialStepSize = 0.1;
    double eps = 1.0E-7;

    public RungeKuttaFehlbergIntegrator(RealFunctionOfOneVariable realFunctionOfOneVariable) {
        super(new RungeKuttaFehlberg(1));
        this.setFunction(realFunctionOfOneVariable);
    }

    public RungeKuttaFehlbergIntegrator(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable) {
        super(new RungeKuttaFehlberg(realVectorValuedFunctionOfOneVariable.getDimensionOfTargetSpace()));
        this.setFunction(realVectorValuedFunctionOfOneVariable);
    }

    public RungeKuttaFehlbergIntegrator() {
        super(new RungeKuttaFehlberg());
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setInitialStepSize(double d) {
        if (this.initialStepSize == d) {
            return;
        }
        this.initialStepSize = d;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double d) {
        ((RungeKuttaFehlberg)this.odeSolver).setEps(d);
        if (this.eps == d) {
            return;
        }
        this.eps = d;
    }

    public static double integrate(RealFunctionOfOneVariable realFunctionOfOneVariable, double d, double d2) {
        return RungeKuttaFehlbergIntegrator.integrate(realFunctionOfOneVariable, d, d2, 1.0E-12);
    }

    public static double integrate(RealFunctionOfOneVariable realFunctionOfOneVariable, double d, double d2, double d3) {
        RungeKuttaFehlbergIntegrator rungeKuttaFehlbergIntegrator = new RungeKuttaFehlbergIntegrator(realFunctionOfOneVariable);
        rungeKuttaFehlbergIntegrator.setEps(d3);
        return rungeKuttaFehlbergIntegrator.integrate(d, d2);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable, double[] dArray, double d, double d2) {
        RungeKuttaFehlbergIntegrator.integrate(realVectorValuedFunctionOfOneVariable, d, d2, dArray, 1.0E-12);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable, double d, double d2, double[] dArray, double d3) {
        RungeKuttaFehlbergIntegrator rungeKuttaFehlbergIntegrator = new RungeKuttaFehlbergIntegrator(realVectorValuedFunctionOfOneVariable);
        rungeKuttaFehlbergIntegrator.setEps(d3);
        rungeKuttaFehlbergIntegrator.integrate(d, d2, dArray);
    }
}

