/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.BasisFunction;
import java.util.Arrays;

public class Monomial
implements BasisFunction {
    final int[] index;
    final int order;
    final int numberOfVariables;
    final double coeff;

    Monomial(int[] nArray, int n) {
        this(nArray, n, 1.0);
    }

    Monomial(int[] nArray, int n, double d) {
        this.index = (int[])nArray.clone();
        Arrays.sort(this.index);
        this.order = nArray.length;
        this.numberOfVariables = n;
        this.coeff = d;
    }

    private static int[] index(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = 0;
            while (n3 < nArray[i]) {
                nArray2[n2] = i;
                ++n3;
                ++n2;
            }
        }
        return nArray2;
    }

    private static int order(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public int order(int n) {
        int n2 = 0;
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public BasisFunction getPartialDerivative(int n) {
        int n2 = this.order(n);
        if (n2 == 0) {
            return new Monomial(new int[0], this.numberOfVariables, 0.0);
        }
        int[] nArray = new int[this.index.length - 1];
        int n3 = 0;
        while (this.index[n3] != n) {
            nArray[n3] = this.index[n3];
            ++n3;
        }
        ++n3;
        while (n3 < this.index.length) {
            nArray[n3 - 1] = this.index[n3];
            ++n3;
        }
        return new Monomial(nArray, this.numberOfVariables, this.coeff * (double)n2);
    }

    public String toString() {
        if (this.order == 0) {
            return new Double(this.coeff).toString();
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (this.coeff != 1.0) {
            stringBuffer.append(" " + this.coeff + " *");
        }
        stringBuffer.append(" x[" + this.index[0] + "]");
        for (int i = 1; i < this.index.length; ++i) {
            stringBuffer.append(" * x[" + this.index[i] + "]");
        }
        return stringBuffer.toString();
    }

    public double eval(double[] dArray) {
        double d = this.coeff;
        for (int i = 0; i < this.order; ++i) {
            d *= dArray[i];
        }
        return d;
    }

    public int getNumberOfVariables() {
        return this.numberOfVariables;
    }

    public boolean equals(Monomial monomial) {
        if (this.numberOfVariables != monomial.numberOfVariables || this.order != monomial.order) {
            return false;
        }
        for (int i = 0; i < this.order; ++i) {
            if (this.index[i] == monomial.index[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((Monomial)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static Monomial create(int[] nArray) {
        return new Monomial(Monomial.index(nArray), nArray.length);
    }

    public boolean isZero() {
        return this.coeff == 0.0;
    }

    public static class Cubic
    extends Monomial {
        final int i0;
        final int i1;
        final int i2;

        public Cubic(int n, int n2, int n3, int n4) {
            super(new int[]{n, n2, n3}, n4);
            this.i0 = n;
            this.i1 = n2;
            this.i2 = n3;
        }

        public double eval(double[] dArray) {
            return dArray[this.i0] * dArray[this.i1] * dArray[this.i2];
        }
    }

    public static class Quadratic
    extends Monomial {
        final int i0;
        final int i1;

        public Quadratic(int n, int n2, int n3) {
            super(new int[]{n, n2}, n3);
            this.i0 = n;
            this.i1 = n2;
        }

        public double eval(double[] dArray) {
            return dArray[this.i0] * dArray[this.i1];
        }
    }

    public static class Linear
    extends Monomial {
        final int i0;

        public Linear(int n, int n2) {
            super(new int[]{n}, n2);
            this.i0 = n;
        }

        public double eval(double[] dArray) {
            return dArray[this.i0];
        }
    }

    public static class Constant
    extends Monomial {
        public Constant(int n) {
            super(new int[0], n);
        }

        public double eval(double[] dArray) {
            return 1.0;
        }
    }
}

