/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class QR {
    public static double decompose(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (int j = 0; j < i; ++j) {
                int n3;
                dArray2[i][j] = 0.0;
                double d2 = 0.0;
                for (n3 = 0; n3 < n; ++n3) {
                    d2 += dArray[n3][j] * dArray[n3][i];
                }
                dArray2[j][i] = d2;
                for (n3 = 0; n3 < n; ++n3) {
                    double[] dArray3 = dArray[n3];
                    int n4 = i;
                    dArray3[n4] = dArray3[n4] - d2 * dArray[n3][j];
                }
            }
            double d3 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d3 += dArray[n2][i] * dArray[n2][i];
            }
            d3 = Math.sqrt(d3);
            d *= d3;
            dArray2[i][i] = d3;
            if (d3 != 0.0) {
                for (n2 = 0; n2 < n; ++n2) {
                    double[] dArray4 = dArray[n2];
                    int n5 = i;
                    dArray4[n5] = dArray4[n5] / d3;
                }
                continue;
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2][i] = 0.0;
            }
        }
        return d;
    }

    public static double decompose(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return QR.decompose(dArray2, dArray3);
    }

    public static double[] decompose(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        int n = dArray.length;
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (int j = 0; j < i; ++j) {
                double d2;
                double d3;
                int n3;
                dArray3[i][j] = 0.0;
                dArray4[i][j] = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                for (n3 = 0; n3 < n; ++n3) {
                    d3 = dArray[n3][j];
                    d2 = -dArray2[n3][j];
                    double d6 = dArray[n3][i];
                    double d7 = dArray2[n3][i];
                    d4 += d3 * d6 - d2 * d7;
                    d5 += d2 * d6 + d3 * d7;
                }
                dArray3[j][i] = d4;
                dArray4[j][i] = d5;
                for (n3 = 0; n3 < n; ++n3) {
                    d3 = dArray[n3][j];
                    d2 = dArray2[n3][j];
                    double[] dArray5 = dArray[n3];
                    int n4 = i;
                    dArray5[n4] = dArray5[n4] - (d4 * d3 - d5 * d2);
                    double[] dArray6 = dArray2[n3];
                    int n5 = i;
                    dArray6[n5] = dArray6[n5] - (d5 * d3 + d4 * d2);
                }
            }
            double d8 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d8 += dArray[n2][i] * dArray[n2][i] + dArray2[n2][i] * dArray2[n2][i];
            }
            d8 = Math.sqrt(d8);
            d *= d8;
            dArray3[i][i] = d8;
            dArray4[i][i] = 0.0;
            if (d8 != 0.0) {
                for (n2 = 0; n2 < n; ++n2) {
                    double[] dArray7 = dArray[n2];
                    int n6 = i;
                    dArray7[n6] = dArray7[n6] / d8;
                    double[] dArray8 = dArray2[n2];
                    int n7 = i;
                    dArray8[n7] = dArray8[n7] / d8;
                }
                continue;
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2][i] = 0.0;
                dArray2[n2][i] = 0.0;
            }
        }
        return new double[]{d, 0.0};
    }

    public static double[] decompose(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = dArray[i][j];
                dArray4[i][j] = dArray2[i][j];
            }
        }
        return QR.decompose(dArray3, dArray4, dArray5, dArray6);
    }
}

