/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.NotTrainedException;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.ConstraintManager;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhCondProb;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhomogeneousDGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.IDGTrainSMParameterSet;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public abstract class DAGTrainSM
extends InhomogeneousDGTrainSM {
    protected InhCondProb[] constraints;

    protected DAGTrainSM(IDGTrainSMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    protected DAGTrainSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public DAGTrainSM clone() throws CloneNotSupportedException {
        DAGTrainSM clone = (DAGTrainSM)super.clone();
        if (this.constraints != null) {
            clone.constraints = (InhCondProb[])ArrayHandler.clone((Cloneable[])this.constraints);
        }
        return clone;
    }

    @Override
    public DataSet emitDataSet(int n, int ... lengths) throws NotTrainedException, Exception {
        int counter2;
        if (lengths != null && lengths.length != 0) {
            throw new Exception("This is an inhomogeneous model. Please check parameter lengths.");
        }
        if (!this.trained) {
            throw new NotTrainedException();
        }
        boolean[] visited = new boolean[this.length];
        int[] order = new int[this.length];
        int counter1 = 0;
        int index = 0;
        Arrays.fill(visited, false);
        counter1 = 0;
        while (counter1 < this.length) {
            if (this.constraints[counter1].getMarginalOrder() == 1) {
                visited[counter1] = true;
                order[index++] = counter1;
            }
            ++counter1;
        }
        while (index < this.length) {
            counter1 = 0;
            while (counter1 < this.length) {
                if (!visited[counter1]) {
                    int l = this.constraints[counter1].getMarginalOrder() - 1;
                    counter2 = 0;
                    while (counter2 < l && visited[this.constraints[counter1].getPosition(counter2)]) {
                        ++counter2;
                    }
                    if (counter2 == l) {
                        order[index++] = counter1;
                        visited[counter1] = true;
                    }
                }
                ++counter1;
            }
        }
        byte[] content = new byte[this.length];
        Sequence[] s = new Sequence[n];
        Random r = new Random();
        counter1 = 0;
        while (counter1 < n) {
            counter2 = 0;
            while (counter2 < this.length) {
                this.constraints[order[counter2]].getOutput(content, r.nextDouble());
                ++counter2;
            }
            s[counter1] = new ByteSequence(this.alphabets, content);
            ++counter1;
        }
        return new DataSet("sampled from " + this.getInstanceName(), s);
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        double p = 0.0;
        double ess = this.getESS();
        if (ess > 0.0) {
            if (!this.trained) {
                throw new NotTrainedException();
            }
            int counter1 = 0;
            while (counter1 < this.length) {
                int anz1 = this.constraints[counter1].getNumberOfSpecificConstraints();
                double pot = ess / (double)anz1;
                double anz2 = this.alphabetLength[this.constraints[counter1].getPosition(this.constraints[counter1].getMarginalOrder() - 1)];
                p += (double)anz1 / anz2 * Gamma.logOfGamma(anz2 * pot) - (double)anz1 * Gamma.logOfGamma(pot);
                int counter2 = 0;
                while (counter2 < anz1) {
                    p += pot * this.constraints[counter1].getLnFreq(counter2);
                    ++counter2;
                }
                ++counter1;
            }
            return p;
        }
        return 0.0;
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        this.check(sequence, startpos, endpos);
        double erg = this.constraints[0].getLnFreq(sequence, startpos);
        int i = 1;
        while (i < this.length) {
            erg += this.constraints[i].getLnFreq(sequence, startpos);
            ++i;
        }
        return erg;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() {
        return null;
    }

    @Override
    public String getStructure() throws NotTrainedException {
        if (this.trained) {
            StringBuffer all = new StringBuffer(500);
            int counter1 = 0;
            while (counter1 < this.constraints.length) {
                all.append(String.valueOf(this.constraints[counter1].toString()) + "\n");
                ++counter1;
            }
            return all.toString();
        }
        throw new NotTrainedException();
    }

    @Override
    public String toString(NumberFormat nf) {
        String erg = "description: " + this.getDescription();
        if (this.trained) {
            try {
                erg = String.valueOf(erg) + "\n\nstructure:\n" + this.getStructure();
                StringBuffer all = new StringBuffer();
                int counter1 = 0;
                while (counter1 < this.constraints.length) {
                    all.append(String.valueOf(this.constraints[counter1].getFreqInfo(this.alphabets, nf)) + "\n");
                    ++counter1;
                }
                erg = String.valueOf(erg) + "\nprobabilities:\n" + all.toString();
            }
            catch (NotTrainedException impossible) {
                System.exit(1);
            }
        }
        return erg;
    }

    protected static boolean checkAcyclic(int length, int[][] graph) {
        ArrayList<int[]> edges = new ArrayList<int[]>(length);
        int counter1 = 0;
        boolean[] used = new boolean[length];
        boolean changed = false;
        Arrays.fill(used, false);
        while (counter1 < length) {
            if (graph[counter1].length > 1) {
                edges.add(graph[counter1++]);
                continue;
            }
            used[counter1++] = true;
            changed = true;
        }
        while (edges.size() > 0 && changed) {
            changed = false;
            counter1 = 0;
            while (counter1 < edges.size()) {
                int[] help = (int[])edges.get(counter1);
                int counter2 = 0;
                while (counter2 < help.length - 1 && used[help[counter2]]) {
                    ++counter2;
                }
                if (counter2 == help.length - 1) {
                    used[help[help.length - 1]] = true;
                    changed = true;
                    edges.remove(counter1);
                    continue;
                }
                ++counter1;
            }
        }
        return edges.size() == 0;
    }

    protected void createConstraints(int[][] structure) {
        this.constraints = new InhCondProb[this.length];
        int i = 0;
        while (i < this.length) {
            this.constraints[i] = new InhCondProb(structure[i], this.alphabetLength, structure[i].length > 1);
            ++i;
        }
    }

    protected void drawParameters(DataSet data, double[] weights) throws Exception {
        if (data != null) {
            ConstraintManager.countInhomogeneous(this.alphabets, this.length, data, weights, true, this.constraints);
        }
        ConstraintManager.drawFreqs(this.getESS(), this.constraints);
        this.trained = true;
    }

    protected void estimateParameters(DataSet data, double[] weights) throws Exception {
        ConstraintManager.countInhomogeneous(this.alphabets, this.length, data, weights, true, this.constraints);
        ConstraintManager.computeFreqs(this.getESS(), this.constraints);
        this.trained = true;
    }

    @Override
    protected StringBuffer getFurtherModelInfos() {
        if (this.trained) {
            StringBuffer xml = new StringBuffer(10000);
            XMLParser.appendObjectWithTags(xml, this.constraints, "conditionalProb");
            return xml;
        }
        return null;
    }

    @Override
    protected void setFurtherModelInfos(StringBuffer xml) throws NonParsableException {
        if (this.trained) {
            this.constraints = XMLParser.extractObjectForTags(xml, "conditionalProb", InhCondProb[].class);
        }
    }
}

