/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.StringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;

public class DataSetResult
extends Result {
    private DataSet data;
    private SequenceAnnotationParser parser;

    public DataSetResult(String name, String comment, DataSet data) {
        super(name, comment, DataType.DATASET);
        this.data = data;
    }

    public DataSetResult(StringBuffer source) throws NonParsableException {
        super(source);
    }

    @Override
    protected void extractFurtherInfos(StringBuffer rep) throws NonParsableException {
        AlphabetContainer cont = (AlphabetContainer)XMLParser.extractObjectForTags(rep, "alphabet");
        String sampleAnn = XMLParser.extractObjectForTags(rep, "dataSetAnnotation", String.class);
        String seqs = XMLParser.extractObjectForTags(rep, "data", String.class);
        StringExtractor ex = new StringExtractor(seqs, 100, "");
        try {
            DataSet data = new DataSet(cont, ex);
            Sequence[] seq = data.getAllElements();
            Storable[][] annotation = XMLParser.extractObjectForTags(rep, "annotation", Storable[][].class);
            int i = 0;
            while (i < seq.length) {
                if (annotation[i].length > 0) {
                    seq[i] = seq[i].annotate(false, ArrayHandler.cast(SequenceAnnotation.class, annotation[i]));
                }
                ++i;
            }
            this.data = new DataSet(sampleAnn, seq);
        }
        catch (Exception e) {
            NonParsableException np = new NonParsableException(e.getCause().getMessage());
            np.setStackTrace(e.getStackTrace());
            throw np;
        }
    }

    @Override
    public DataSet getValue() {
        return this.data;
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        AlphabetContainer cont = this.data.getAlphabetContainer();
        XMLParser.appendObjectWithTags(buf, cont, "alphabet");
        StringBuffer seqs = new StringBuffer();
        Storable[][] annotation = new Storable[this.data.getNumberOfElements()][];
        DataSet.ElementEnumerator it = new DataSet.ElementEnumerator(this.data);
        int i = 0;
        while (it.hasMoreElements()) {
            Sequence seq = it.nextElement();
            buf.append(seq.toString());
            buf.append("\n");
            SequenceAnnotation[] ann = seq.getAnnotation();
            annotation[i] = ann == null ? new Storable[0] : ann;
            ++i;
        }
        XMLParser.appendObjectWithTags(buf, this.data.getAnnotation(), "dataSetAnnotation");
        XMLParser.appendObjectWithTags(buf, seqs.toString(), "data");
        XMLParser.appendObjectWithTags(buf, annotation, "annotation");
    }

    @Override
    public String getXMLTag() {
        return "DataSetResult";
    }

    public SequenceAnnotationParser getParser() {
        return this.parser;
    }

    public void setParser(SequenceAnnotationParser parser) {
        this.parser = parser;
    }
}

