/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateFileFilter
implements FileFilter {
    private long time;
    private String desc;

    public DateFileFilter(int year, int month, int dayOfMonth, int hrs, int min, int sec) {
        this(new GregorianCalendar(year, month, dayOfMonth, hrs, min, sec).getTime());
    }

    public DateFileFilter(Date d) {
        this.time = d.getTime();
        this.desc = String.valueOf(d.toString()) + " (" + this.time + ")";
    }

    @Override
    public boolean accept(File f) {
        return f.isDirectory() || f.lastModified() >= this.time;
    }

    public String toString() {
        return this.desc;
    }
}

