/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.hierachical;

import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.utils.SeqLogoPlotter;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import projects.motifComp.PWMSupplier;

public class TreeDrawer {
    private int elementHeight = pwmHeight *= this.gScale;
    private int margin;
    private int totalHeight;
    private int externalHeight = totalHeight *= this.gScale;
    private boolean hang;
    private Coordinates coords;
    private int gScale = 100;

    public TreeDrawer(int pwmHeight, int margin, int totalHeight, ClusterTree tree) {
        this.totalHeight = totalHeight - (margin *= this.gScale) / 2 - this.elementHeight - this.elementHeight / 2;
        this.margin = margin;
        this.coords = new Coordinates(tree, (double)(this.totalHeight - margin / 2) / tree.getMaximumDistance());
        this.coords.setX(0);
    }

    public Dimension getDimension() {
        return new Dimension(this.coords.width / this.gScale, this.externalHeight / this.gScale);
    }

    private int[] getLeafDimensions(ClusterTree leaf) {
        Object element = leaf.getClusterElements()[0];
        if (element instanceof PWMSupplier) {
            double[][] pwm = ((PWMSupplier)element).getPWM();
            int width = SeqLogoPlotter.getWidth(this.elementHeight, pwm);
            return new int[]{width + this.margin, this.elementHeight};
        }
        return new int[]{this.elementHeight * element.toString().length(), this.elementHeight};
    }

    private void plotLeaf(Graphics2D graphics, ClusterTree leaf, int xoff, int yoff) {
        Object element = leaf.getClusterElements()[0];
        if (element instanceof PWMSupplier) {
            double[][] pwm = ((PWMSupplier)element).getPWM();
            int width = SeqLogoPlotter.getWidth(this.elementHeight, pwm);
            graphics.drawRect(xoff, yoff, width, this.elementHeight);
            SeqLogoPlotter.plotLogo(graphics, xoff + this.margin / 4, yoff + this.elementHeight - this.margin / 4 - this.margin, width - this.margin / 2, this.elementHeight - this.margin / 2 - this.margin, pwm, null, "Position", "bits");
            Font font = new Font(graphics.getFont().getName(), 1, (this.elementHeight - this.margin / 2 - this.margin) / 10);
            graphics.setFont(font);
            String name = ((PWMSupplier)element).getName();
            Rectangle2D rect = graphics.getFontMetrics().getStringBounds(name, graphics);
            graphics.drawString(name, (float)((double)(xoff + this.margin / 4 + width / 2) - rect.getCenterX()), (float)(yoff + this.elementHeight - this.margin / 4));
        }
    }

    public void plotTree(Graphics2D graphics, boolean hang) {
        this.hang = hang;
        graphics = (Graphics2D)graphics.create();
        graphics.scale(1.0 / (double)this.gScale, 1.0 / (double)this.gScale);
        graphics.setStroke(new BasicStroke((float)this.elementHeight / 100.0f));
        this.plotTree(graphics, null, this.coords);
    }

    private void plotTree(Graphics2D graphics, Coordinates parent, Coordinates coords) {
        if (coords.children == null) {
            if (parent != null && this.hang) {
                this.plotLeaf(graphics, coords.tree, coords.x, this.totalHeight - parent.height + this.elementHeight / 2);
            } else {
                this.plotLeaf(graphics, coords.tree, coords.x, this.totalHeight - coords.height);
            }
        } else {
            int i = 0;
            while (i < coords.children.length) {
                if (i > 0) {
                    graphics.drawLine(coords.children[i - 1].x + coords.children[i - 1].width / 2, this.totalHeight - coords.height, coords.children[i].x + coords.children[i].width / 2, this.totalHeight - coords.height);
                }
                if (coords.children[i].children == null && this.hang) {
                    graphics.drawLine(coords.children[i].x + coords.children[i].width / 2, this.totalHeight - coords.height, coords.children[i].x + coords.children[i].width / 2, this.totalHeight - coords.height + this.elementHeight / 2);
                } else {
                    graphics.drawLine(coords.children[i].x + coords.children[i].width / 2, this.totalHeight - coords.height, coords.children[i].x + coords.children[i].width / 2, this.totalHeight - coords.children[i].height);
                }
                this.plotTree(graphics, coords, coords.children[i]);
                ++i;
            }
        }
    }

    private class Coordinates {
        private Coordinates[] children;
        private ClusterTree tree;
        private int x;
        private int width;
        private int height;
        private int[] xoffs;

        public Coordinates(ClusterTree tree, double scale) {
            if (tree.getNumberOfElements() == 1) {
                this.children = null;
                this.tree = tree;
                int[] dim = TreeDrawer.this.getLeafDimensions(tree);
                this.width = dim[0];
                this.height = dim[1];
            } else {
                ClusterTree<T>[] subs = tree.getSubTrees();
                this.children = new Coordinates[subs.length];
                this.xoffs = new int[subs.length];
                this.width = TreeDrawer.this.margin / 2;
                int i = 0;
                while (i < subs.length) {
                    this.children[i] = new Coordinates(subs[i], scale);
                    this.xoffs[i] = this.width;
                    int width = this.children[i].width;
                    this.width += width;
                    ++i;
                }
                this.height = (int)(tree.getDistance() * scale);
            }
        }

        public void setX(int x) {
            if (this.children == null) {
                this.x = x;
                System.out.println("leaf: " + x + ", " + this.height);
            } else {
                int i = 0;
                while (i < this.children.length) {
                    this.x = x;
                    System.out.println("this: " + x + ", " + this.height);
                    System.out.println("child " + i + " start");
                    this.children[i].setX(x + this.xoffs[i]);
                    System.out.println("child " + i + " end");
                    ++i;
                }
            }
        }
    }
}

