/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.hierachical;

import de.jstacs.Storable;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import java.util.Arrays;

public class ClusterTree<T>
implements Storable {
    private double distance;
    private T[] elements;
    private ClusterTree<T>[] subTrees;

    public ClusterTree(T leaf) {
        this.elements = ArrayHandler.cast(new Object[]{leaf});
        this.distance = 0.0;
    }

    public ClusterTree(double distance, ClusterTree<T> ... subTrees) {
        this.distance = distance;
        this.subTrees = (ClusterTree[])subTrees.clone();
        this.setElements();
    }

    public ClusterTree(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "ClusterTree");
        this.distance = (Double)XMLParser.extractObjectForTags(xml, "distance");
        this.subTrees = (ClusterTree[])XMLParser.extractObjectForTags(xml, "subTrees");
        if (this.subTrees == null) {
            this.elements = (Object[])XMLParser.extractObjectForTags(xml, "elements");
        } else {
            this.setElements();
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.distance, "distance");
        XMLParser.appendObjectWithTags(sb, this.subTrees, "subTrees");
        if (this.subTrees == null) {
            XMLParser.appendObjectWithTags(sb, this.elements, "elements");
        }
        XMLParser.addTags(sb, "ClusterTree");
        return sb;
    }

    private void setElements() {
        int num = 0;
        int i = 0;
        while (i < this.subTrees.length) {
            num += this.subTrees[i].elements.length;
            ++i;
        }
        Object[] elements = new Object[num];
        int i2 = 0;
        int k = 0;
        while (i2 < this.subTrees.length) {
            int j = 0;
            while (j < this.subTrees[i2].elements.length) {
                elements[k] = this.subTrees[i2].elements[j];
                ++j;
                ++k;
            }
            ++i2;
        }
        this.elements = ArrayHandler.cast(elements);
    }

    public ClusterTree<T>[] getSubTrees() {
        return this.subTrees;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getMaximumDistance() {
        return this.distance;
    }

    public double getMinimumDistance() {
        if (this.getNumberOfElements() == 1) {
            return this.distance;
        }
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.subTrees.length) {
            double temp = this.subTrees[i].getDistance();
            if (temp < min) {
                min = temp;
            }
            ++i;
        }
        return min;
    }

    public T[] getClusterElements() {
        return this.elements;
    }

    public int getNumberOfElements() {
        return this.elements.length;
    }

    public String toString() {
        if (this.subTrees == null) {
            return Arrays.toString(this.elements);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("dist: " + this.distance + "\n");
        int i = 0;
        while (i < this.subTrees.length) {
            sb.append(String.valueOf(i) + "(\n");
            sb.append(String.valueOf(this.subTrees[i].toString()) + "\n");
            sb.append(String.valueOf(i) + ")\n");
            ++i;
        }
        return sb.toString();
    }
}

