/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.igsp.gkde.format;

import edu.duke.igsp.gkde.format.DensityWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;

public class NpfDensityWriter
implements DensityWriter {
    private BufferedWriter bw;
    private final long chromPos;
    private final int step;
    private final String chr;
    private float _threshold = 0.0f;
    private long _currentPos;
    private long _counter = 1L;
    private long _startPeakPos = 0L;
    private boolean _aboveThreshold = false;
    private float _currentMax = 0.0f;
    private long _currentMaxPos = 0L;
    private NumberFormat nf;

    public NpfDensityWriter(File f, String chr, long chromStart, int step) throws IOException {
        this.bw = new BufferedWriter(new FileWriter(f));
        this.chromPos = chromStart;
        this.chr = chr;
        this.step = step;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(4);
        this.nf.setMinimumFractionDigits(4);
        this._currentPos = this.chromPos;
    }

    public void setThreshold(float threshold) {
        this._threshold = threshold;
    }

    public void close() throws IOException {
        if (this._aboveThreshold) {
            this.doWrite();
        }
        this.bw.close();
    }

    public void writeDensity(float[] batch, int start, int length) throws IOException {
        int end = start + length;
        int i = start;
        while (i < end) {
            if (!this._aboveThreshold) {
                if (batch[i] > this._threshold) {
                    this._aboveThreshold = true;
                    this._startPeakPos = this._currentPos;
                    this._currentMax = batch[i];
                    this._currentMaxPos = this._currentPos;
                }
            } else if (batch[i] > this._threshold) {
                this._currentMax = Math.max(this._currentMax, batch[i]);
                if (this._currentMax == batch[i]) {
                    this._currentMaxPos = this._currentPos;
                }
            } else {
                this._aboveThreshold = false;
                this.doWrite();
            }
            ++i;
            ++this._currentPos;
        }
    }

    private void doWrite() throws IOException {
        long centerPos = this._currentMaxPos - this._startPeakPos;
        this.bw.write(this.chr + "\t" + this._startPeakPos + "\t" + (this._currentPos - 1L) + "\t" + this.chr + "." + this._counter++ + "\t" + "0" + "\t" + "." + "\t" + this.nf.format(this._currentMax) + "\t" + "-1" + "\t" + "-1" + "\t" + centerPos + "\n");
        this._currentMax = 0.0f;
        this._currentMaxPos = 0L;
        this._startPeakPos = 0L;
    }
}

