/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext.writer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2Writer;
import org.broadinstitute.sting.utils.variantcontext.writer.Options;
import org.broadinstitute.sting.utils.variantcontext.writer.SortingVariantContextWriter;
import org.broadinstitute.sting.utils.variantcontext.writer.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.writer.VariantContextWriter;

public class VariantContextWriterFactory {
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.INDEX_ON_THE_FLY);
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);

    private VariantContextWriterFactory() {
    }

    public static VariantContextWriter create(File location, SAMSequenceDictionary refDict) {
        return VariantContextWriterFactory.create(location, VariantContextWriterFactory.openOutputStream(location), refDict, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(File location, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        return VariantContextWriterFactory.create(location, VariantContextWriterFactory.openOutputStream(location), refDict, options);
    }

    public static VariantContextWriter create(File location, OutputStream output, SAMSequenceDictionary refDict) {
        return VariantContextWriterFactory.create(location, output, refDict, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(OutputStream output, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        return VariantContextWriterFactory.create(null, output, refDict, options);
    }

    public static VariantContextWriter create(File location, OutputStream output, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        boolean enableBCF = VariantContextWriterFactory.isBCFOutput(location, options);
        if (enableBCF) {
            return new BCF2Writer(location, output, refDict, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES));
        }
        return new VCFWriter(location, output, refDict, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER));
    }

    public static boolean isBCFOutput(File location) {
        return VariantContextWriterFactory.isBCFOutput(location, EnumSet.noneOf(Options.class));
    }

    public static boolean isBCFOutput(File location, EnumSet<Options> options) {
        return options.contains((Object)Options.FORCE_BCF) || location != null && location.getName().contains(".bcf");
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter innerWriter, int maxCachingStartDistance) {
        return VariantContextWriterFactory.sortOnTheFly(innerWriter, maxCachingStartDistance, false);
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter innerWriter, int maxCachingStartDistance, boolean takeOwnershipOfInner) {
        return new SortingVariantContextWriter(innerWriter, maxCachingStartDistance, takeOwnershipOfInner);
    }

    protected static OutputStream openOutputStream(File location) {
        try {
            return new FileOutputStream(location);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(location, "Unable to create VCF writer", (Exception)e);
        }
    }
}

