/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.Random;
import org.broadinstitute.sting.utils.QualityUtils;

@Invariant(value={"estimatedQReported >= 0.0", "! Double.isNaN(estimatedQReported)", "! Double.isInfinite(estimatedQReported)", "empiricalQuality >= 0.0 || empiricalQuality == UNINITIALIZED", "! Double.isNaN(empiricalQuality)", "! Double.isInfinite(empiricalQuality)", "numObservations >= 0", "numMismatches >= 0", "numMismatches <= numObservations"})
public class RecalDatum {
    private static final double UNINITIALIZED = -1.0;
    private double estimatedQReported;
    private double empiricalQuality;
    private long numObservations;
    private long numMismatches;
    private static final int SMOOTHING_CONSTANT = 1;

    public RecalDatum(long _numObservations, long _numMismatches, byte reportedQuality) {
        if (_numObservations < 0L) {
            throw new IllegalArgumentException("numObservations < 0");
        }
        if (_numMismatches < 0L) {
            throw new IllegalArgumentException("numMismatches < 0");
        }
        if (reportedQuality < 0) {
            throw new IllegalArgumentException("reportedQuality < 0");
        }
        this.numObservations = _numObservations;
        this.numMismatches = _numMismatches;
        this.estimatedQReported = reportedQuality;
        this.empiricalQuality = -1.0;
    }

    public RecalDatum(RecalDatum copy) {
        this.numObservations = copy.getNumObservations();
        this.numMismatches = copy.getNumMismatches();
        this.estimatedQReported = copy.estimatedQReported;
        this.empiricalQuality = copy.empiricalQuality;
    }

    public synchronized void combine(RecalDatum other) {
        double sumErrors = this.calcExpectedErrors() + other.calcExpectedErrors();
        this.increment(other.getNumObservations(), other.getNumMismatches());
        this.estimatedQReported = -10.0 * Math.log10(sumErrors / (double)this.getNumObservations());
        this.empiricalQuality = -1.0;
    }

    public synchronized void setEstimatedQReported(double estimatedQReported) {
        if (estimatedQReported < 0.0) {
            throw new IllegalArgumentException("estimatedQReported < 0");
        }
        if (Double.isInfinite(estimatedQReported)) {
            throw new IllegalArgumentException("estimatedQReported is infinite");
        }
        if (Double.isNaN(estimatedQReported)) {
            throw new IllegalArgumentException("estimatedQReported is NaN");
        }
        this.estimatedQReported = estimatedQReported;
    }

    public static RecalDatum createRandomRecalDatum(int maxObservations, int maxErrors) {
        Random random = new Random();
        int nObservations = random.nextInt(maxObservations);
        int nErrors = random.nextInt(maxErrors);
        int qual = random.nextInt(93);
        return new RecalDatum(nObservations, nErrors, (byte)qual);
    }

    public final double getEstimatedQReported() {
        return this.estimatedQReported;
    }

    public final byte getEstimatedQReportedAsByte() {
        return (byte)Math.round(this.getEstimatedQReported());
    }

    @Ensures(value={"result >= 0.0"})
    public double getEmpiricalErrorRate() {
        if (this.numObservations == 0L) {
            return 0.0;
        }
        double doubleMismatches = this.numMismatches + 1L;
        double doubleObservations = this.numObservations + 1L + 1L;
        return doubleMismatches / doubleObservations;
    }

    public synchronized void setEmpiricalQuality(double empiricalQuality) {
        if (empiricalQuality < 0.0) {
            throw new IllegalArgumentException("empiricalQuality < 0");
        }
        if (Double.isInfinite(empiricalQuality)) {
            throw new IllegalArgumentException("empiricalQuality is infinite");
        }
        if (Double.isNaN(empiricalQuality)) {
            throw new IllegalArgumentException("empiricalQuality is NaN");
        }
        this.empiricalQuality = empiricalQuality;
    }

    public final double getEmpiricalQuality() {
        if (this.empiricalQuality == -1.0) {
            this.calcEmpiricalQuality();
        }
        return this.empiricalQuality;
    }

    public final byte getEmpiricalQualityAsByte() {
        return (byte)Math.round(this.getEmpiricalQuality());
    }

    public String toString() {
        return String.format("%d,%d,%d", this.getNumObservations(), this.getNumMismatches(), (byte)Math.floor(this.getEmpiricalQuality()));
    }

    public String stringForCSV() {
        return String.format("%s,%d,%.2f", this.toString(), (byte)Math.floor(this.getEstimatedQReported()), this.getEmpiricalQuality() - this.getEstimatedQReported());
    }

    public long getNumObservations() {
        return this.numObservations;
    }

    public synchronized void setNumObservations(long numObservations) {
        if (numObservations < 0L) {
            throw new IllegalArgumentException("numObservations < 0");
        }
        this.numObservations = numObservations;
        this.empiricalQuality = -1.0;
    }

    public long getNumMismatches() {
        return this.numMismatches;
    }

    @Requires(value={"numMismatches >= 0"})
    public synchronized void setNumMismatches(long numMismatches) {
        if (numMismatches < 0L) {
            throw new IllegalArgumentException("numMismatches < 0");
        }
        this.numMismatches = numMismatches;
        this.empiricalQuality = -1.0;
    }

    @Requires(value={"by >= 0"})
    public synchronized void incrementNumObservations(long by) {
        this.numObservations += by;
        this.empiricalQuality = -1.0;
    }

    @Requires(value={"by >= 0"})
    public synchronized void incrementNumMismatches(long by) {
        this.numMismatches += by;
        this.empiricalQuality = -1.0;
    }

    @Requires(value={"incObservations >= 0", "incMismatches >= 0"})
    @Ensures(value={"numObservations == old(numObservations) + incObservations", "numMismatches == old(numMismatches) + incMismatches"})
    public synchronized void increment(long incObservations, long incMismatches) {
        this.incrementNumObservations(incObservations);
        this.incrementNumMismatches(incMismatches);
    }

    @Ensures(value={"numObservations == old(numObservations) + 1", "numMismatches >= old(numMismatches)"})
    public synchronized void increment(boolean isError) {
        this.incrementNumObservations(1L);
        if (isError) {
            this.incrementNumMismatches(1L);
        }
    }

    @Requires(value={"empiricalQuality == UNINITIALIZED"})
    @Ensures(value={"empiricalQuality != UNINITIALIZED"})
    private final synchronized void calcEmpiricalQuality() {
        double empiricalQual = -10.0 * Math.log10(this.getEmpiricalErrorRate());
        this.empiricalQuality = Math.min(empiricalQual, 93.0);
    }

    @Ensures(value={"result >= 0.0"})
    private double calcExpectedErrors() {
        return (double)this.getNumObservations() * QualityUtils.qualToErrorProb(this.estimatedQReported);
    }
}

