/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.baq;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Iterator;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BAQSamIterator
implements StingSAMIterator {
    private final StingSAMIterator it;
    private final BAQ baqHMM = new BAQ();
    private final IndexedFastaSequenceFile refReader;
    private final BAQ.CalculationMode cmode;
    private final BAQ.QualityMode qmode;

    @Requires(value={"refReader != null", "it != null", "cmode != null", "qmode != null"})
    public BAQSamIterator(IndexedFastaSequenceFile refReader, StingSAMIterator it, BAQ.CalculationMode cmode, BAQ.QualityMode qmode) {
        if (cmode == BAQ.CalculationMode.OFF) {
            throw new ReviewedStingException("BUG: shouldn't create BAQSamIterator with calculation mode OFF");
        }
        if (qmode == BAQ.QualityMode.DONT_MODIFY) {
            throw new ReviewedStingException("BUG: shouldn't create BAQSamIterator with quailty mode DONT_MODIFY");
        }
        this.refReader = refReader;
        this.it = it;
        this.cmode = cmode;
        this.qmode = qmode;
    }

    @Override
    @Requires(value={"hasNext()"})
    @Ensures(value={"result != null"})
    public SAMRecord next() {
        SAMRecord read = (SAMRecord)this.it.next();
        this.baqHMM.baqRead(read, this.refReader, this.cmode, this.qmode);
        return read;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    @Override
    public void close() {
        this.it.close();
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

