/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeType;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class MendelianViolation {
    private List<String> violationFamilies;
    private int nocall = 0;
    private int familyCalled = 0;
    private int varFamilyCalled = 0;
    private int lowQual = 0;
    private boolean allCalledOnly = true;
    private EnumMap<GenotypeType, EnumMap<GenotypeType, EnumMap<GenotypeType, Integer>>> inheritance;
    private int violations_total = 0;
    private double minGenotypeQuality;
    private boolean abortOnSampleNotFound;
    static final int[] mvOffsets = new int[]{1, 2, 5, 6, 8, 11, 15, 18, 20, 21, 24, 25};
    static final int[] nonMVOffsets = new int[]{0, 3, 4, 7, 9, 10, 12, 13, 14, 16, 17, 19, 22, 23, 26};

    public int getFamilyCalledCount() {
        return this.familyCalled;
    }

    public int getVarFamilyCalledCount() {
        return this.varFamilyCalled;
    }

    public int getFamilyNoCallCount() {
        return this.nocall;
    }

    public int getFamilyLowQualsCount() {
        return this.lowQual;
    }

    public int getViolationsCount() {
        return this.violations_total;
    }

    public int getParentHetInheritedVar() {
        return this.getParentsHetHetInheritedVar() + this.getParentsRefHetInheritedVar() + this.getParentsVarHetInheritedVar();
    }

    public int getParentHetInheritedRef() {
        return this.getParentsHetHetInheritedRef() + this.getParentsRefHetInheritedRef() + this.getParentsVarHetInheritedRef();
    }

    public int getRefRefRef() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_REF);
    }

    public int getVarVarVar() {
        return this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_VAR);
    }

    public int getRefVarHet() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HET) + this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HET);
    }

    public int getHetHetHet() {
        return this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HET).get((Object)GenotypeType.HET);
    }

    public int getHetHetHomRef() {
        return this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_REF);
    }

    public int getHetHetHomVar() {
        return this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_VAR);
    }

    public int getParentsHetHetInheritedRef() {
        return this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HET).get((Object)GenotypeType.HET) + 2 * this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_REF);
    }

    public int getParentsHetHetInheritedVar() {
        return this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HET).get((Object)GenotypeType.HET) + 2 * this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_VAR);
    }

    public int getParentsRefHetInheritedRef() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_REF) + this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_REF);
    }

    public int getParentsRefHetInheritedVar() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HET).get((Object)GenotypeType.HET) + this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HET);
    }

    public int getParentsVarHetInheritedRef() {
        return this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HET).get((Object)GenotypeType.HET) + this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HET);
    }

    public int getParentsVarHetInheritedVar() {
        return this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_VAR) + this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_VAR);
    }

    public int getParentsRefRefChildVar() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_VAR);
    }

    public int getParentsRefRefChildHet() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HET);
    }

    public int getParentsRefHetChildVar() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_VAR) + this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_VAR);
    }

    public int getParentsRefVarChildVar() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_VAR) + this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_VAR);
    }

    public int getParentsRefVarChildRef() {
        return this.inheritance.get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_REF) + this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_REF).get((Object)GenotypeType.HOM_REF);
    }

    public int getParentsVarHetChildRef() {
        return this.inheritance.get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_REF) + this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HET).get((Object)GenotypeType.HOM_REF);
    }

    public int getParentsVarVarChildRef() {
        return this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_REF);
    }

    public int getParentsVarVarChildHet() {
        return this.inheritance.get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HOM_VAR).get((Object)GenotypeType.HET);
    }

    public int getParentVarChildRef() {
        return this.getParentsRefVarChildRef() + this.getParentsVarHetChildRef() + this.getParentsVarVarChildRef();
    }

    public int getParentRefChildVar() {
        return this.getParentsRefVarChildVar() + this.getParentsRefHetChildVar() + this.getParentsRefRefChildVar();
    }

    public String getViolationFamiliesString() {
        if (this.violationFamilies.isEmpty()) {
            return "";
        }
        Iterator<String> it = this.violationFamilies.iterator();
        String violationFams = it.next();
        while (it.hasNext()) {
            violationFams = violationFams + "," + it.next();
        }
        return violationFams;
    }

    public List<String> getViolationFamilies() {
        return this.violationFamilies;
    }

    public double getMinGenotypeQuality() {
        return this.minGenotypeQuality;
    }

    public MendelianViolation(double minGenotypeQualityP) {
        this(minGenotypeQualityP, true);
    }

    public MendelianViolation(double minGenotypeQualityP, boolean abortOnSampleNotFound) {
        this.minGenotypeQuality = minGenotypeQualityP;
        this.abortOnSampleNotFound = abortOnSampleNotFound;
        this.violationFamilies = new ArrayList<String>();
        this.createInheritanceMap();
    }

    public MendelianViolation(double minGenotypeQualityP, boolean abortOnSampleNotFound, boolean completeTriosOnly) {
        this.minGenotypeQuality = minGenotypeQualityP;
        this.abortOnSampleNotFound = abortOnSampleNotFound;
        this.violationFamilies = new ArrayList<String>();
        this.createInheritanceMap();
        this.allCalledOnly = completeTriosOnly;
    }

    public int countViolations(Map<String, Set<Sample>> families, VariantContext vc) {
        this.nocall = 0;
        this.lowQual = 0;
        this.familyCalled = 0;
        this.varFamilyCalled = 0;
        this.violations_total = 0;
        this.violationFamilies.clear();
        this.clearInheritanceMap();
        for (Set<Sample> family : families.values()) {
            for (Sample sample : family) {
                if (sample.getParents().size() <= 0) continue;
                this.updateViolations(sample.getFamilyID(), sample.getMaternalID(), sample.getPaternalID(), sample.getID(), vc);
            }
        }
        return this.violations_total;
    }

    public boolean isViolation(Sample mother, Sample father, Sample child, VariantContext vc) {
        this.nocall = 0;
        this.lowQual = 0;
        this.familyCalled = 0;
        this.varFamilyCalled = 0;
        this.violations_total = 0;
        this.violationFamilies.clear();
        this.clearInheritanceMap();
        this.updateViolations(mother.getFamilyID(), mother.getID(), father.getID(), child.getID(), vc);
        return this.violations_total > 0;
    }

    private void updateViolations(String familyId, String motherId, String fatherId, String childId, VariantContext vc) {
        Genotype gMom = vc.getGenotype(motherId);
        Genotype gDad = vc.getGenotype(fatherId);
        Genotype gChild = vc.getGenotype(childId);
        if (gMom == null || gDad == null || gChild == null) {
            if (this.abortOnSampleNotFound) {
                throw new IllegalArgumentException(String.format("Variant %s:%d: Missing genotypes for family %s: mom=%s dad=%s family=%s", vc.getChr(), vc.getStart(), familyId, motherId, fatherId, childId));
            }
            return;
        }
        if (!(!this.allCalledOnly || gMom.isCalled() && gDad.isCalled() && gChild.isCalled())) {
            ++this.nocall;
        } else if (!gMom.isCalled() && !gDad.isCalled() || !gChild.isCalled()) {
            ++this.nocall;
        } else if (this.minGenotypeQuality > 0.0 && ((double)gMom.getPhredScaledQual() < this.minGenotypeQuality || (double)gDad.getPhredScaledQual() < this.minGenotypeQuality || (double)gChild.getPhredScaledQual() < this.minGenotypeQuality)) {
            ++this.lowQual;
        } else {
            ++this.familyCalled;
            if (!(gMom.isHomRef() && gDad.isHomRef() && gChild.isHomRef())) {
                ++this.varFamilyCalled;
                if (this.isViolation(gMom, gDad, gChild)) {
                    this.violationFamilies.add(familyId);
                    ++this.violations_total;
                }
            }
            int count = this.inheritance.get((Object)gMom.getType()).get((Object)gDad.getType()).get((Object)gChild.getType());
            this.inheritance.get((Object)gMom.getType()).get((Object)gDad.getType()).put(gChild.getType(), count + 1);
        }
    }

    private boolean isViolation(Genotype gMom, Genotype gDad, Genotype gChild) {
        if (!gMom.isCalled()) {
            return gDad.isHomRef() && gChild.isHomVar() || gDad.isHomVar() && gChild.isHomRef();
        }
        if (!gDad.isCalled()) {
            return gMom.isHomRef() && gChild.isHomVar() || gMom.isHomVar() && gChild.isHomRef();
        }
        return !(gMom.getAlleles().contains(gChild.getAlleles().get(0)) && gDad.getAlleles().contains(gChild.getAlleles().get(1)) || gMom.getAlleles().contains(gChild.getAlleles().get(1)) && gDad.getAlleles().contains(gChild.getAlleles().get(0)));
    }

    private void createInheritanceMap() {
        this.inheritance = new EnumMap(GenotypeType.class);
        for (GenotypeType mType : GenotypeType.values()) {
            this.inheritance.put(mType, new EnumMap(GenotypeType.class));
            for (GenotypeType dType : GenotypeType.values()) {
                this.inheritance.get((Object)mType).put(dType, new EnumMap(GenotypeType.class));
                for (GenotypeType cType : GenotypeType.values()) {
                    this.inheritance.get((Object)mType).get((Object)dType).put(cType, 0);
                }
            }
        }
    }

    private void clearInheritanceMap() {
        for (GenotypeType mType : GenotypeType.values()) {
            for (GenotypeType dType : GenotypeType.values()) {
                for (GenotypeType cType : GenotypeType.values()) {
                    this.inheritance.get((Object)mType).get((Object)dType).put(cType, 0);
                }
            }
        }
    }

    public double violationLikelihoodRatio(VariantContext vc, String motherId, String fatherId, String childId) {
        int i;
        double[] logLikAssignments = new double[27];
        double[] momGL = vc.getGenotype(motherId).getLikelihoods().getAsVector();
        double[] dadGL = vc.getGenotype(fatherId).getLikelihoods().getAsVector();
        double[] childGL = vc.getGenotype(childId).getLikelihoods().getAsVector();
        int offset = 0;
        for (int oMom = 0; oMom < 3; ++oMom) {
            for (int oDad = 0; oDad < 3; ++oDad) {
                for (int oChild = 0; oChild < 3; ++oChild) {
                    logLikAssignments[offset++] = momGL[oMom] + dadGL[oDad] + childGL[oChild];
                }
            }
        }
        double[] mvLiks = new double[12];
        double[] nonMVLiks = new double[15];
        for (i = 0; i < 12; ++i) {
            mvLiks[i] = logLikAssignments[mvOffsets[i]];
        }
        for (i = 0; i < 15; ++i) {
            nonMVLiks[i] = logLikAssignments[nonMVOffsets[i]];
        }
        return MathUtils.log10sumLog10(mvLiks) - MathUtils.log10sumLog10(nonMVLiks);
    }
}

