/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.queue.extensions.gatk;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.filters.FilterManager;
import org.broadinstitute.sting.gatk.io.stubs.OutputStreamArgumentTypeDescriptor;
import org.broadinstitute.sting.gatk.io.stubs.SAMFileWriterArgumentTypeDescriptor;
import org.broadinstitute.sting.gatk.io.stubs.VCFWriterArgumentTypeDescriptor;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.queue.extensions.gatk.ArgumentDefinitionField;
import org.broadinstitute.sting.queue.extensions.gatk.ArgumentField;
import org.broadinstitute.sting.queue.extensions.gatk.ReadFilterField;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class GATKExtensionsGenerator
extends CommandLineProgram {
    private static final Logger logger = Logger.getLogger(GATKExtensionsGenerator.class);
    public static final String GATK_EXTENSIONS_PACKAGE_NAME = GATKExtensionsGenerator.class.getPackage().getName();
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final String CLASS_TEMPLATE = "package %s%n%s%nclass %s extends %s {%n%s%s%n%soverride def commandLine = super.commandLine%s%n}%n";
    private static final String TRAIT_TEMPLATE = "package %s%n%s%ntrait %s extends %s {%n%s%s%n%sabstract override def commandLine = super.commandLine%s%n}%n";
    private static final String GATK_DEPENDENCIES_TEMPLATE = "package %s%n%n/** A dynamicly generated list of classes that the GATK Extensions depend on, but are not be detected by default by BCEL. */%nclass %s {%nval types = Seq(%n%s)%n}%n";
    @Output(fullName="output_directory", shortName="outDir", doc="Directory to output the generated scala", required=true)
    public File outputDirectory;
    PluginManager<CommandLineProgram> clpManager = new PluginManager<CommandLineProgram>(CommandLineProgram.class, "CommandLineProgram", "CLP");
    GenomeAnalysisEngine GATKEngine = new GenomeAnalysisEngine();
    WalkerManager walkerManager = new WalkerManager();
    FilterManager filterManager = new FilterManager();
    private static final List<String> gatkPackages = Arrays.asList("org.broadinstitute.sting.gatk", "org.broadinstitute.sting.pipeline", "org.broadinstitute.sting.gatk.datasources.reads.utilities");
    private static final Comparator<Class<?>> classComparator = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> a, Class<?> b) {
            return (a == null ? "" : a.getName()).compareTo(b == null ? "" : b.getName());
        }
    };

    public static void main(String[] argv) {
        try {
            GATKExtensionsGenerator.start(new GATKExtensionsGenerator(), argv);
            System.exit(CommandLineProgram.result);
        }
        catch (Exception e) {
            GATKExtensionsGenerator.exitSystemWithError(e);
        }
    }

    @Override
    protected Collection<ArgumentTypeDescriptor> getArgumentTypeDescriptors() {
        ArrayList<ArgumentTypeDescriptor> typeDescriptors = new ArrayList<ArgumentTypeDescriptor>();
        typeDescriptors.add(new VCFWriterArgumentTypeDescriptor(this.GATKEngine, System.out, Collections.<Object>emptyList()));
        typeDescriptors.add(new SAMFileWriterArgumentTypeDescriptor(this.GATKEngine, System.out));
        typeDescriptors.add(new OutputStreamArgumentTypeDescriptor(this.GATKEngine, System.out));
        return typeDescriptors;
    }

    @Override
    protected int execute() {
        try {
            if (!this.outputDirectory.isDirectory() && !this.outputDirectory.mkdirs()) {
                throw new ReviewedStingException("Unable to create output directory: " + this.outputDirectory);
            }
            TreeSet dependents = new TreeSet(classComparator);
            for (Class<CommandLineProgram> clazz : this.clpManager.getPlugins()) {
                try {
                    if (!this.isGatkProgram(clazz)) {
                        logger.debug("Skipping: " + clazz);
                        continue;
                    }
                    logger.debug("Generating: " + clazz);
                    String clpClassName = this.clpManager.getName(clazz);
                    String clpConstructor = String.format("analysisName = \"%s\"%njavaMainClass = \"%s\"%n", clpClassName, clazz.getName());
                    this.writeClass("org.broadinstitute.sting.queue.function.JavaCommandLineFunction", clpClassName, false, clpConstructor, ArgumentDefinitionField.getArgumentFields(this.parser, clazz), dependents);
                    if (clazz != CommandLineGATK.class) continue;
                    for (Map.Entry<String, Collection<Class<? extends Walker>>> walkersByPackage : this.walkerManager.getWalkerNamesByPackage(false).entrySet()) {
                        for (Class<? extends Walker> walkerType : walkersByPackage.getValue()) {
                            try {
                                String walkerName = this.walkerManager.getName(walkerType);
                                ArrayList<? extends ArgumentField> argumentFields = new ArrayList<ArgumentField>();
                                argumentFields.addAll(ArgumentDefinitionField.getArgumentFields(this.parser, walkerType));
                                argumentFields.addAll(ReadFilterField.getFilterArguments(this.parser, walkerType));
                                String constructor = String.format("analysisName = \"%1$s\"%nanalysis_type = \"%1$s\"%n", walkerName);
                                String scatterClass = this.getScatterClass(walkerType);
                                boolean isScatter = false;
                                if (scatterClass != null) {
                                    isScatter = true;
                                    constructor = constructor + String.format("scatterClass = classOf[%s]%n", scatterClass);
                                }
                                this.writeClass(GATK_EXTENSIONS_PACKAGE_NAME + "." + clpClassName, walkerName, isScatter, constructor, argumentFields, dependents);
                            }
                            catch (Exception e) {
                                throw new ReviewedStingException("Error generating wrappers for walker " + walkerType, e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ReviewedStingException("Error generating wrappers for " + clazz, e);
                }
            }
            for (Class<Object> clazz : this.filterManager.getValues()) {
                String filterName = this.filterManager.getName(clazz);
                this.writeFilter(filterName, ArgumentDefinitionField.getArgumentFields(new ParsingEngine(null), clazz), dependents);
            }
            this.writeDependencies(dependents);
            return 0;
        }
        catch (IOException exception) {
            logger.error("Error generating queue output.", exception);
            return 1;
        }
    }

    private boolean isGatkProgram(Class<?> clazz) {
        if (clazz.getPackage() == null) {
            return false;
        }
        String classPackage = clazz.getPackage().getName();
        for (String gatkPackage : gatkPackages) {
            if (!classPackage.startsWith(gatkPackage)) continue;
            return true;
        }
        return false;
    }

    private String getScatterClass(Class<? extends Walker> walkerType) {
        PartitionType partitionType = walkerType.getAnnotation(PartitionBy.class).value();
        if (partitionType == PartitionType.NONE) {
            return null;
        }
        return StringUtils.capitalize(partitionType.name().toLowerCase()) + "ScatterFunction";
    }

    private void writeClass(String baseClass, String className, boolean isScatter, String constructor, List<? extends ArgumentField> argumentFields, Set<Class<?>> dependents) throws IOException {
        String content = GATKExtensionsGenerator.getContent(CLASS_TEMPLATE, baseClass, className, constructor, isScatter, "", argumentFields, dependents);
        this.writeFile(GATK_EXTENSIONS_PACKAGE_NAME + "." + className, content);
    }

    private void writeFilter(String className, List<? extends ArgumentField> argumentFields, Set<Class<?>> dependents) throws IOException {
        String content = GATKExtensionsGenerator.getContent(TRAIT_TEMPLATE, "org.broadinstitute.sting.queue.function.CommandLineFunction", className, "", false, String.format(" + required(\"--read_filter\", \"%s\")", className), argumentFields, dependents);
        this.writeFile(GATK_EXTENSIONS_PACKAGE_NAME + "." + className, content);
    }

    private void writeDependencies(SortedSet<Class<?>> dependents) throws IOException {
        TreeSet enclosings = new TreeSet(classComparator);
        Iterator i$ = dependents.iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            for (Class<?> enclosing = clazz = (Class<?>)i$.next(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                enclosings.add(enclosing);
            }
        }
        dependents = enclosings;
        enclosings = new TreeSet(classComparator);
        for (Class clazz : dependents) {
            for (Method method : clazz.getDeclaredMethods()) {
                JVMUtils.addGenericTypes(enclosings, method.getGenericReturnType());
                for (Type parameterType : method.getGenericParameterTypes()) {
                    JVMUtils.addGenericTypes(enclosings, parameterType);
                }
                for (Type exceptionType : method.getGenericExceptionTypes()) {
                    JVMUtils.addGenericTypes(enclosings, exceptionType);
                }
            }
        }
        dependents = enclosings;
        String className = "GATKClassDependencies";
        StringBuilder stringBuilder = new StringBuilder();
        for (Class clazz : dependents) {
            if (clazz.isArray() || ArgumentField.isBuiltIn(clazz) || !Modifier.isPublic(clazz.getModifiers())) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",").append(NEWLINE);
            }
            String typeParams = this.getScalaTypeParams(clazz);
            stringBuilder.append("classOf[").append(clazz.getName().replace("$", ".")).append(typeParams).append("]");
        }
        String content = String.format(GATK_DEPENDENCIES_TEMPLATE, GATK_EXTENSIONS_PACKAGE_NAME, className, stringBuilder);
        this.writeFile(GATK_EXTENSIONS_PACKAGE_NAME + "." + className, content);
    }

    private String getScalaTypeParams(Class<?> clazz) {
        TypeVariable<Class<?>>[] typeParams = clazz.getTypeParameters();
        if (typeParams.length == 0) {
            return "";
        }
        return "[" + StringUtils.repeat("_", ",", typeParams.length) + "]";
    }

    private void writeFile(String fullClassName, String content) throws IOException {
        String existingContent;
        File outputFile = new File(this.outputDirectory, fullClassName.replace(".", "/") + ".scala");
        if (outputFile.exists() && StringUtils.equals(content, existingContent = FileUtils.readFileToString(outputFile))) {
            return;
        }
        FileUtils.writeStringToFile(outputFile, content);
    }

    private static String getContent(String scalaTemplate, String baseClass, String className, String constructor, boolean isScatter, String commandLinePrefix, List<? extends ArgumentField> argumentFields, Set<Class<?>> dependents) {
        StringBuilder arguments = new StringBuilder();
        StringBuilder commandLine = new StringBuilder(commandLinePrefix);
        HashSet<String> importSet = new HashSet<String>();
        boolean isGather = false;
        ArrayList<String> freezeFields = new ArrayList<String>();
        for (ArgumentField argumentField : argumentFields) {
            arguments.append(argumentField.getArgumentAddition());
            commandLine.append(argumentField.getCommandLineAddition());
            importSet.addAll(argumentField.getImportStatements());
            freezeFields.add(argumentField.getFreezeFields());
            dependents.addAll(argumentField.getDependentClasses());
            isGather |= argumentField.isGather();
        }
        if (isScatter) {
            importSet.add("import org.broadinstitute.sting.queue.function.scattergather.ScatterGatherableFunction");
            baseClass = baseClass + " with ScatterGatherableFunction";
        }
        if (isGather) {
            importSet.add("import org.broadinstitute.sting.commandline.Gather");
        }
        ArrayList sortedImports = new ArrayList(importSet);
        Collections.sort(sortedImports);
        StringBuffer stringBuffer = new StringBuffer();
        for (String freezeField : freezeFields) {
            stringBuffer.append(freezeField);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, String.format("override def freezeFieldValues() {%nsuper.freezeFieldValues()%n", new Object[0]));
            stringBuffer.append(String.format("}%n%n", new Object[0]));
        }
        String importText = sortedImports.size() == 0 ? "" : NEWLINE + StringUtils.join(sortedImports, NEWLINE) + NEWLINE;
        return String.format(scalaTemplate, GATK_EXTENSIONS_PACKAGE_NAME, importText, className, baseClass, constructor, arguments, stringBuffer, commandLine);
    }
}

