/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import net.sf.samtools.Cigar;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.indels.IndelRealigner;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@DocumentedGATKFeature(groupName="BAM Processing and Analysis Tools", extraDocs={CommandLineGATK.class})
public class LeftAlignIndels
extends ReadWalker<Integer, Integer> {
    @Output(required=false, doc="Output bam")
    protected StingSAMFileWriter writer = null;

    @Override
    public void initialize() {
    }

    private void emit(SAMRecord read) {
        if (this.writer != null) {
            this.writer.addAlignment(read);
        }
    }

    @Override
    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (read.getCigar().numCigarElements() == 0) {
            this.emit(read);
            return 0;
        }
        int numBlocks = AlignmentUtils.getNumAlignmentBlocks(read);
        if (numBlocks == 2) {
            Cigar newCigar = AlignmentUtils.leftAlignIndel(IndelRealigner.unclipCigar(read.getCigar()), ref.getBases(), read.getReadBases(), 0, 0);
            newCigar = IndelRealigner.reclipCigar(newCigar, read);
            read.setCigar(newCigar);
        }
        this.emit(read);
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
    }
}

