/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.filters;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.broadinstitute.sting.gatk.walkers.filters.FiltrationContext;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class FiltrationContextWindow {
    private LinkedList<FiltrationContext> window = new LinkedList();
    private int currentContext;

    public FiltrationContextWindow(List<FiltrationContext> firstVariants) {
        int windowSize = firstVariants == null ? 1 : 2 * firstVariants.size() + 1;
        this.currentContext = firstVariants == null ? 0 : firstVariants.size();
        this.window.addAll(firstVariants);
        while (this.window.size() < windowSize) {
            this.window.addFirst(null);
        }
    }

    public FiltrationContext getContext() {
        return this.window.get(this.currentContext);
    }

    public int maxWindowElements() {
        return this.currentContext;
    }

    public FiltrationContext[] getWindow(int elementsToLeft, int elementsToRight) {
        if (elementsToLeft > this.maxWindowElements() || elementsToRight > this.maxWindowElements()) {
            throw new ReviewedStingException("Too large a window requested");
        }
        if (elementsToLeft < 0 || elementsToRight < 0) {
            throw new ReviewedStingException("Window size cannot be negative");
        }
        FiltrationContext[] array = new FiltrationContext[elementsToLeft + elementsToRight + 1];
        ListIterator<FiltrationContext> iter = this.window.listIterator(this.currentContext - elementsToLeft);
        for (int i = 0; i < elementsToLeft + elementsToRight + 1; ++i) {
            array[i] = iter.next();
        }
        return array;
    }

    public void moveWindow(FiltrationContext context) {
        this.window.removeFirst();
        this.window.addLast(context);
    }
}

