/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffEngine;
import org.broadinstitute.sting.gatk.walkers.diffengine.Difference;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@DocumentedGATKFeature(groupName="Quality Control and Simple Analysis Tools", extraDocs={CommandLineGATK.class})
public class DiffObjects
extends RodWalker<Integer, Integer> {
    @Output(doc="File to which results should be written", required=true)
    protected PrintStream out;
    @Input(fullName="master", shortName="m", doc="Master file: expected results", required=true)
    File masterFile;
    @Input(fullName="test", shortName="t", doc="Test file: new results to compare to the master file", required=true)
    File testFile;
    @Argument(fullName="maxObjectsToRead", shortName="motr", doc="Max. number of objects to read from the files.  -1 [default] means unlimited", required=false)
    int MAX_OBJECTS_TO_READ = -1;
    @Argument(fullName="maxRawDiffsToSummary", shortName="maxRawDiffsToSummary", doc="Max. number of objects to read from the files.  -1 [default] means unlimited", required=false)
    int maxRawDiffsToSummary = -1;
    @Argument(fullName="doPairwise", shortName="doPairwise", doc="If provided, we will compute the minimum pairwise differences to summary, which can be extremely expensive", required=false)
    boolean doPairwise = false;
    @Argument(fullName="maxDiffs", shortName="M", doc="Max. number of diffs to process", required=false)
    int MAX_DIFFS = 0;
    @Argument(fullName="maxCount1Diffs", shortName="M1", doc="Max. number of diffs occuring exactly once in the file to process", required=false)
    int MAX_COUNT1_DIFFS = 0;
    @Argument(fullName="minCountForDiff", shortName="MCFD", doc="Min number of observations for a records to display", required=false)
    int minCountForDiff = 1;
    @Argument(fullName="showItemizedDifferences", shortName="SID", doc="Should we enumerate all differences between the files?", required=false)
    boolean showItemizedDifferences = false;
    @Argument(fullName="iterations", doc="Number of iterations to perform, should be 1 unless you are doing memory testing", required=false)
    int iterations = 1;
    DiffEngine diffEngine;

    @Override
    public void initialize() {
        this.diffEngine = new DiffEngine();
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return counter + sum;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        if (this.iterations > 1) {
            for (int i = 0; i < this.iterations; ++i) {
                DiffEngine.SummaryReportParams params = new DiffEngine.SummaryReportParams(this.out, 20, 10, 0, -1, false);
                boolean success = DiffEngine.simpleDiffFiles(this.masterFile, this.testFile, this.MAX_OBJECTS_TO_READ, params);
                logger.info("Iteration " + i + " success " + success);
            }
        } else {
            DiffElement master = this.diffEngine.createDiffableFromFile(this.masterFile, this.MAX_OBJECTS_TO_READ);
            logger.info(String.format("Read %d objects", master.size()));
            DiffElement test = this.diffEngine.createDiffableFromFile(this.testFile, this.MAX_OBJECTS_TO_READ);
            logger.info(String.format("Read %d objects", test.size()));
            List<Difference> diffs = this.diffEngine.diff(master, test);
            logger.info(String.format("Done computing diff with %d differences found", diffs.size()));
            if (this.showItemizedDifferences) {
                this.out.printf("Itemized results%n", new Object[0]);
                for (Difference diff : diffs) {
                    this.out.printf("DIFF: %s%n", diff.toString());
                }
            }
            DiffEngine.SummaryReportParams params = new DiffEngine.SummaryReportParams(this.out, this.MAX_DIFFS, this.MAX_COUNT1_DIFFS, this.minCountForDiff, this.maxRawDiffsToSummary, this.doPairwise);
            params.setDescending(false);
            this.diffEngine.reportSummarizedDifferences(diffs, params);
            logger.info(String.format("Done summarizing differences", new Object[0]));
        }
    }
}

