/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.HashSet;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFStandardHeaderLines;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

class ThresHolder {
    public static final String AVG_INTERVAL_DP_KEY = "AVG_INTERVAL_DP";
    public static final ThresHolder DEFAULTS = new ThresHolder(20, 20, 5, 700, 20, 50, 0.5, 0.2, 0.5, 0.2, 0.2, 0.5);
    private final int minimumBaseQuality;
    private final int minimumMappingQuality;
    private final int minimumCoverage;
    private final int maximumCoverage;
    private final int minimumMedianDepth;
    private final int maximumInsertSize;
    private final double votePercentageThreshold;
    private final double lowMedianDepthThreshold;
    private final double badMateStatusThreshold;
    private final double coverageStatusThreshold;
    private final double excessiveCoverageThreshold;
    private final double qualityStatusThreshold;

    public ThresHolder(int minimumBaseQuality, int minimumMappingQuality, int minimumCoverage, int maximumCoverage, int minimumMedianDepth, int maximumInsertSize, double votePercentageThreshold, double lowMedianDepthThreshold, double badMateStatusThreshold, double coverageStatusThreshold, double excessiveCoverageThreshold, double qualityStatusThreshold) {
        this.minimumBaseQuality = minimumBaseQuality;
        this.minimumMappingQuality = minimumMappingQuality;
        this.minimumCoverage = minimumCoverage;
        this.maximumCoverage = maximumCoverage;
        this.minimumMedianDepth = minimumMedianDepth;
        this.maximumInsertSize = maximumInsertSize;
        this.votePercentageThreshold = votePercentageThreshold;
        this.lowMedianDepthThreshold = lowMedianDepthThreshold;
        this.badMateStatusThreshold = badMateStatusThreshold;
        this.coverageStatusThreshold = coverageStatusThreshold;
        this.excessiveCoverageThreshold = excessiveCoverageThreshold;
        this.qualityStatusThreshold = qualityStatusThreshold;
    }

    public int getMinimumCoverage() {
        return this.minimumCoverage;
    }

    public int getMaximumCoverage() {
        return this.maximumCoverage;
    }

    public int getMinimumMedianDepth() {
        return this.minimumMedianDepth;
    }

    public int getMaximumInsertSize() {
        return this.maximumInsertSize;
    }

    public double getVotePercentageThreshold() {
        return this.votePercentageThreshold;
    }

    public double getLowMedianDepthThreshold() {
        return this.lowMedianDepthThreshold;
    }

    public double getBadMateStatusThreshold() {
        return this.badMateStatusThreshold;
    }

    public double getCoverageStatusThreshold() {
        return this.coverageStatusThreshold;
    }

    public double getExcessiveCoverageThreshold() {
        return this.excessiveCoverageThreshold;
    }

    public double getQualityStatusThreshold() {
        return this.qualityStatusThreshold;
    }

    public int getFilteredCoverage(ReadBackedPileup pileup) {
        return pileup.getBaseAndMappingFilteredPileup(this.minimumBaseQuality, this.minimumMappingQuality).depthOfCoverage();
    }

    public static Set<VCFHeaderLine> getHeaderInfo() {
        HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
        headerLines.add(VCFStandardHeaderLines.getInfoLine("END"));
        headerLines.add(new VCFInfoHeaderLine(AVG_INTERVAL_DP_KEY, 1, VCFHeaderLineType.Float, "Average depth across the interval. Sum of the depth in a loci divided by interval size."));
        headerLines.add(new VCFInfoHeaderLine("Diagnose Targets", 0, VCFHeaderLineType.Flag, "DiagnoseTargets mode"));
        headerLines.add(VCFStandardHeaderLines.getFormatLine("FT"));
        headerLines.add(new VCFFormatHeaderLine(AVG_INTERVAL_DP_KEY, 1, VCFHeaderLineType.Float, "Average depth across the interval. Sum of the depth in a loci divided by interval size."));
        headerLines.add(new VCFFormatHeaderLine("Q1", 1, VCFHeaderLineType.Float, "Lower Quartile of depth distribution."));
        headerLines.add(new VCFFormatHeaderLine("MED", 1, VCFHeaderLineType.Float, "Median of depth distribution."));
        headerLines.add(new VCFFormatHeaderLine("Q3", 1, VCFHeaderLineType.Float, "Upper Quartile of depth Distribution."));
        for (CallableStatus stat : CallableStatus.values()) {
            headerLines.add(new VCFFilterHeaderLine(stat.name(), stat.description));
        }
        return headerLines;
    }
}

