/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics;

import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@DocumentedGATKFeature(groupName="Quality Control and Simple Analysis Tools", extraDocs={CommandLineGATK.class})
public class ErrorRatePerCycle
extends LocusWalker<Integer, Integer> {
    @Output
    PrintStream out;
    @Argument(fullName="min_base_quality_score", shortName="mbq", doc="Minimum base quality required to consider a base for calling", required=false)
    public Integer MIN_BASE_QUAL = 0;
    @Argument(fullName="min_mapping_quality_score", shortName="mmq", doc="Minimum read mapping quality required to consider a read for calling", required=false)
    public Integer MIN_MAPPING_QUAL = 20;
    private GATKReport report;
    private GATKReportTable table;
    private static final String reportName = "ErrorRatePerCycle";
    private static final String reportDescription = "The error rate per sequenced position in the reads";

    @Override
    public void initialize() {
        this.report = new GATKReport();
        this.report.addTable(reportName, reportDescription, 6, true);
        this.table = this.report.getTable(reportName);
        this.table.addColumn("readgroup");
        this.table.addColumn("cycle");
        this.table.addColumn("mismatches");
        this.table.addColumn("counts");
        this.table.addColumn("qual");
        this.table.addColumn("errorrate", "%.2e");
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        for (PileupElement p : context.getBasePileup()) {
            GATKSAMRecord read = p.getRead();
            int offset = p.getOffset();
            boolean firstOfPair = !read.getReadPairedFlag() || read.getFirstOfPairFlag();
            if (!firstOfPair || read.getMappingQuality() < this.MIN_MAPPING_QUAL || p.getQual() < this.MIN_BASE_QUAL) continue;
            byte readBase = p.getBase();
            byte refBase = ref.getBase();
            int cycle = offset;
            if (!BaseUtils.isRegularBase(readBase) || !BaseUtils.isRegularBase(refBase)) continue;
            TableKey key = new TableKey(read.getReadGroup().getReadGroupId(), cycle);
            if (!this.table.containsRowID(key)) {
                this.table.set(key, "cycle", (Object)cycle);
                this.table.set(key, "readgroup", (Object)read.getReadGroup().getReadGroupId());
                this.table.set(key, "counts", (Object)0);
                this.table.set(key, "mismatches", (Object)0);
            }
            this.table.increment(key, "counts");
            if (readBase == refBase) continue;
            this.table.increment(key, "mismatches");
        }
        return null;
    }

    @Override
    public Integer reduceInit() {
        return null;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return null;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        for (Object key : this.table.getRowIDs()) {
            int mismatches = (Integer)this.table.get(key, "mismatches");
            int count = (Integer)this.table.get(key, "counts");
            double errorRate = (double)(mismatches + 1) / (1.0 * (double)(count + 1));
            byte qual = QualityUtils.probToQual(1.0 - errorRate, 0.0);
            this.table.set(key, "qual", (Object)qual);
            this.table.set(key, "errorrate", (Object)errorRate);
        }
        this.report.print(this.out);
    }

    private static class TableKey
    implements Comparable<TableKey> {
        final String readGroup;
        final int cycle;

        private TableKey(String readGroup, int cycle) {
            this.readGroup = readGroup;
            this.cycle = cycle;
        }

        public int hashCode() {
            return this.readGroup.hashCode() + 33 * this.cycle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableKey oKey = (TableKey)o;
            if (this.cycle != oKey.cycle) {
                return false;
            }
            return this.readGroup.equals(oKey.readGroup);
        }

        @Override
        public int compareTo(TableKey tableKey) {
            int scmp = this.readGroup.compareTo(tableKey.readGroup);
            if (scmp == 0) {
                return Integer.valueOf(this.cycle).compareTo(tableKey.cycle);
            }
            return scmp;
        }
    }
}

