/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.beagle;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.beagle.ProduceBeagleInput;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;
import org.broadinstitute.sting.utils.variantcontext.writer.VariantContextWriter;

@DocumentedGATKFeature(groupName="Variant Discovery Tools", extraDocs={CommandLineGATK.class})
public class VariantsToBeagleUnphased
extends RodWalker<Integer, Integer> {
    @Input(fullName="variants", shortName="V", doc="Input VCF file", required=true)
    public RodBinding<VariantContext> variants;
    @Output(doc="File to which BEAGLE unphased genotypes should be written", required=true)
    protected PrintStream beagleWriter = null;
    @Argument(fullName="bootstrap_fraction", shortName="bs", doc="Proportion of records to be used in bootstrap set", required=false)
    public double bootstrap = 0.0;
    @Argument(fullName="bootstrap_vcf", shortName="bsvcf", doc="Output a VCF with the records used for bootstrapping filtered out", required=false)
    VariantContextWriter bootstrapVCFOutput = null;
    @Argument(fullName="missing", shortName="missing", doc="String to identify missing data in beagle output", required=false)
    public String MISSING = "?";
    private Set<String> samples = null;
    private int bootstrapSetSize = 0;
    private int testSetSize = 0;

    @Override
    public void initialize() {
        this.samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), Arrays.asList(this.variants.getName()));
        this.beagleWriter.print("I marker alleleA alleleB");
        for (String sample : this.samples) {
            this.beagleWriter.print(String.format(" %s %s", sample, sample));
        }
        this.beagleWriter.println();
        if (this.bootstrap < 0.0 | this.bootstrap > 1.0) {
            throw new UserException.BadArgumentValue("bootstrap", "Bootstrap value must be fraction between 0 and 1");
        }
        if (this.bootstrapVCFOutput != null) {
            Set<VCFHeaderLine> hInfo = VCFUtils.getHeaderFields(this.getToolkit());
            this.bootstrapVCFOutput.writeHeader(new VCFHeader(hInfo, SampleUtils.getUniqueSamplesFromRods(this.getToolkit())));
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        GenomeLoc loc;
        VariantContext vc;
        if (tracker != null && ProduceBeagleInput.canBeOutputToBeagle(vc = tracker.getFirstValue(this.variants, loc = context.getLocation()))) {
            boolean makeMissing = this.dropSite(vc);
            if (makeMissing && this.bootstrapVCFOutput != null) {
                this.bootstrapVCFOutput.add(vc);
            }
            this.writeUnphasedBeagleOutput(vc, makeMissing);
        }
        return 0;
    }

    public boolean dropSite(VariantContext vc) {
        if (((double)this.bootstrapSetSize + 1.0) / (1.0 + (double)this.bootstrapSetSize + (double)this.testSetSize) <= this.bootstrap) {
            ++this.bootstrapSetSize;
            return true;
        }
        ++this.testSetSize;
        return false;
    }

    public void writeUnphasedBeagleOutput(VariantContext vc, boolean makeMissing) {
        GenomeLoc currentLoc = VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), vc);
        StringBuffer beagleOut = new StringBuffer();
        String marker = String.format("%s:%d ", currentLoc.getContig(), currentLoc.getStart());
        beagleOut.append("M ").append(marker);
        for (Allele allele : vc.getAlleles()) {
            beagleOut.append(allele.isNoCall() ? "-" : allele.getBaseString()).append(" ");
        }
        for (String sample : this.samples) {
            Genotype genotype = vc.getGenotype(sample);
            if (!makeMissing && genotype.isCalled()) {
                this.addAlleles(beagleOut, genotype);
                continue;
            }
            this.addAlleles(beagleOut, this.MISSING, this.MISSING);
        }
        this.beagleWriter.println(beagleOut.toString());
    }

    private void addAlleles(StringBuffer buf, Genotype g) {
        this.addAlleles(buf, g.getAllele(0).getBaseString(), g.getAllele(1).getBaseString());
    }

    private void addAlleles(StringBuffer buf, String a, String b) {
        buf.append(a).append(" ").append(b);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer includedSites) {
        logger.info("Sites included in beagle genotypes file : " + includedSites);
    }
}

